/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.io;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.CloseableIterator;
import com.complexible.common.base.HandlerBackedIterator;
import com.complexible.common.base.Options;
import com.complexible.common.cancellation.CancelCheck;
import com.google.common.collect.Lists;
import com.stardog.stark.Namespace;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Statement;
import com.stardog.stark.impl.ImmutableNamespaces;
import com.stardog.stark.impl.NamespaceImpl;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFParser;
import com.stardog.stark.query.GraphQueryResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class AsyncGraphQueryResult
extends CloseableIterator.AbstractCloseableIterator<Statement>
implements GraphQueryResult {
    private final CloseableIterator<Statement> mStatements;
    private final List<Namespace> mNamespaces = Lists.newArrayList();
    private final Consumer<Boolean> mOnClose;
    private final Function<Exception, RuntimeException> mOnError;
    private boolean mEndOfData = false;

    public AsyncGraphQueryResult(InputStream input, RDFParser parser, Options parserOptions, ExecutorService execService, int batchSize, CancelCheck cancelCheck, Consumer<Boolean> onClose, Function<Exception, RuntimeException> onError) {
        this.mOnClose = onClose;
        this.mOnError = onError;
        this.mStatements = new HandlerBackedIterator(handler -> {
            try {
                parser.parse(input, (RDFHandler)new DelegatingHandler(handler, this.mNamespaces), parserOptions);
            }
            catch (HandlerBackedIterator.ProducerFinished producerFinished) {
            }
            catch (IOException err) {
                throw new UncheckedIOException(err);
            }
        }, execService, cancelCheck, batchSize);
    }

    public void close() {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mStatements, () -> this.mOnClose.accept(this.mEndOfData)});
    }

    protected Statement computeNext() {
        try {
            if (this.mStatements.hasNext()) {
                return (Statement)this.mStatements.next();
            }
            this.mEndOfData = true;
        }
        catch (Exception e) {
            throw this.mOnError.apply(e);
        }
        return (Statement)this.endOfData();
    }

    @Nonnull
    public Namespaces namespaces() {
        return ImmutableNamespaces.of(this.mNamespaces);
    }

    private static final class DelegatingHandler
    implements RDFHandler {
        final Consumer<Statement> mHandler;
        final List<Namespace> mNamespaces;

        DelegatingHandler(Consumer<Statement> handler, List<Namespace> theNamespaces) {
            this.mHandler = handler;
            this.mNamespaces = theNamespaces;
        }

        public void handle(@Nonnull Statement statement) {
            this.mHandler.accept(statement);
        }

        public void start() {
        }

        public void namespace(@Nonnull String thePrefix, @Nonnull String theIRI) {
            this.mNamespaces.add((Namespace)new NamespaceImpl(thePrefix, theIRI));
        }

        public void end() {
        }
    }
}

