/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.io.binary;

import com.carrotsearch.hppc.ObjectObjectScatterMap;
import com.complexible.common.base.Options;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.BindingSets;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.QueryResultFormats;
import com.stardog.stark.query.io.QueryResultWriter;
import com.stardog.stark.query.io.QueryResultWriterFactory;
import com.stardog.stark.query.io.ResultWritingFailed;
import com.stardog.stark.query.io.SelectQueryResultWriter;
import com.stardog.stark.query.io.binary.BinaryQueryResultConstants;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nonnull;

public final class BinarySelectQueryResultWriter
implements SelectQueryResultWriter,
BinaryQueryResultConstants {
    private final DataOutputStream mWriter;
    private int nextNamespaceID;
    private boolean documentStarted = false;
    private boolean tupleVariablesFound = false;
    private List<String> bindingNames;
    private BindingSet previousBindings = BindingSets.empty();
    private final ObjectObjectScatterMap<String, Integer> namespaceTable = new ObjectObjectScatterMap(32);

    public BinarySelectQueryResultWriter(OutputStream theWriter, Options theOptions) {
        this.mWriter = new DataOutputStream(theWriter);
    }

    public void start() throws ResultWritingFailed {
        if (this.documentStarted) {
            throw new IllegalStateException("Cannot re-start a writer");
        }
        this.documentStarted = true;
        try {
            this.mWriter.write(MAGIC_NUMBER);
            this.mWriter.writeInt(5);
        }
        catch (IOException e) {
            throw new ResultWritingFailed((Throwable)e);
        }
    }

    public void namespace(@Nonnull String thePrefix, @Nonnull String theIRI) throws ResultWritingFailed {
    }

    public void variables(@Nonnull List<String> theVars) {
        this.tupleVariablesFound = true;
        if (!this.documentStarted) {
            this.documentStarted = true;
            try {
                this.mWriter.write(MAGIC_NUMBER);
                this.mWriter.writeInt(5);
            }
            catch (IOException e) {
                throw new ResultWritingFailed((Throwable)e);
            }
        }
        this.bindingNames = theVars;
        try {
            this.mWriter.writeInt(this.bindingNames.size());
            for (String bindingName : this.bindingNames) {
                this.writeString(bindingName);
            }
            this.nextNamespaceID = 0;
        }
        catch (IOException e) {
            throw new ResultWritingFailed((Throwable)e);
        }
    }

    public void handle(@Nonnull BindingSet theBindings) throws ResultWritingFailed {
        if (!this.tupleVariablesFound) {
            throw new IllegalStateException("Must call startQueryResult before handleSolution");
        }
        try {
            if (theBindings.size() == 0) {
                this.mWriter.writeByte(9);
            } else {
                for (String bindingName : this.bindingNames) {
                    Value value = theBindings.get(bindingName);
                    if (value == null) {
                        this.mWriter.writeByte(0);
                        continue;
                    }
                    if (value.equals(this.previousBindings.value(bindingName).orElse(null))) {
                        this.mWriter.writeByte(1);
                        continue;
                    }
                    this.writeValue(value);
                }
                this.previousBindings = theBindings;
            }
        }
        catch (IOException e) {
            throw new ResultWritingFailed((Throwable)e);
        }
    }

    private void writeValue(Value value) throws IOException {
        if (value instanceof IRI) {
            this.writeQName((IRI)value);
        } else if (value instanceof BNode) {
            this.writeBNode((BNode)value);
        } else if (value instanceof Literal) {
            this.writeLiteral((Literal)value);
        } else if (value instanceof Statement) {
            this.writeStatement((Statement)value);
        } else {
            throw new ResultWritingFailed("Unknown Value object type: " + String.valueOf(value.getClass()));
        }
    }

    private void writeStatement(Statement theStatement) throws IOException {
        this.mWriter.writeByte(10);
        this.writeValue((Value)theStatement.subject());
        this.writeValue((Value)theStatement.predicate());
        this.writeValue(theStatement.object());
        if (theStatement.context().equals((Object)Values.DEFAULT_GRAPH)) {
            this.mWriter.writeByte(1);
        } else {
            this.mWriter.writeByte(2);
            this.writeValue((Value)theStatement.context());
        }
    }

    public void end() throws ResultWritingFailed {
        if (!this.tupleVariablesFound) {
            throw new IllegalStateException("Could not end query result as variables was not called first.");
        }
        try {
            this.mWriter.writeByte(127);
            this.mWriter.flush();
        }
        catch (IOException e) {
            throw new ResultWritingFailed((Throwable)e);
        }
    }

    public void links(@Nonnull List<String> theLinks) throws ResultWritingFailed {
    }

    @Nonnull
    public QueryResultFormat format() {
        return QueryResultFormats.BINARY;
    }

    private void writeQName(IRI uri) throws IOException {
        String namespace = uri.namespace();
        Integer nsID = (Integer)this.namespaceTable.get((Object)namespace);
        if (nsID == null) {
            nsID = this.writeNamespace(namespace);
        }
        this.mWriter.writeByte(3);
        this.mWriter.writeInt(nsID);
        this.writeString(uri.localName());
    }

    private void writeBNode(BNode bnode) throws IOException {
        this.mWriter.writeByte(5);
        this.writeString(bnode.id());
    }

    private void writeLiteral(Literal literal) throws IOException {
        int marker;
        String label = literal.label();
        IRI datatype = literal.datatypeIRI();
        if (Literal.isLanguageLiteral((Literal)literal)) {
            marker = 7;
        } else {
            String namespace = datatype.namespace();
            if (!this.namespaceTable.containsKey((Object)namespace)) {
                this.writeNamespace(namespace);
            }
            marker = 8;
        }
        this.mWriter.writeByte(marker);
        this.writeString(label);
        if (Literal.isLanguageLiteral((Literal)literal)) {
            this.writeString((String)literal.lang().get());
        } else {
            this.writeQName(datatype);
        }
    }

    private void writeString(@Nonnull String s) throws IOException {
        byte[] utf8Bytes = s.getBytes(StandardCharsets.UTF_8);
        this.mWriter.writeInt(utf8Bytes.length);
        this.mWriter.write(utf8Bytes, 0, utf8Bytes.length);
    }

    private Integer writeNamespace(String namespace) throws IOException {
        this.mWriter.writeByte(2);
        this.mWriter.writeInt(this.nextNamespaceID);
        this.writeString(namespace);
        Integer result = this.nextNamespaceID;
        this.namespaceTable.put((Object)namespace, (Object)result);
        ++this.nextNamespaceID;
        return result;
    }

    public static final class BinarySelectQueryResultWriterFactory
    implements QueryResultWriterFactory {
        @Nonnull
        public QueryResultFormat format() {
            return QueryResultFormats.BINARY;
        }

        @Nonnull
        public QueryResultWriter<BindingSet> create(@Nonnull OutputStream theOutputStream, @Nonnull Options theOptions) {
            return new BinarySelectQueryResultWriter(theOutputStream, theOptions);
        }
    }
}

