/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.io.binary;

import com.complexible.common.base.Options;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.BindingSets;
import com.stardog.stark.query.SelectQueryResultHandler;
import com.stardog.stark.query.io.InvalidQueryResults;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.QueryResultFormats;
import com.stardog.stark.query.io.SelectQueryResultParser;
import com.stardog.stark.query.io.binary.BinaryQueryResultConstants;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.io.Charsets;

public final class BinarySelectQueryResultParser
implements SelectQueryResultParser,
BinaryQueryResultConstants {
    private static final long MAX_STR_LENGTH = 0xA00000L;

    @Nonnull
    public QueryResultFormat format() {
        return QueryResultFormats.BINARY;
    }

    public void parse(@Nonnull InputStream theStream, @Nonnull SelectQueryResultHandler theHandler, @Nonnull Options theOptions) throws IOException {
        DataInputStream in = new DataInputStream(theStream);
        BindingSet aPrev = BindingSets.empty();
        byte[] magicNumber = new byte[MAGIC_NUMBER.length];
        ByteStreams.readFully((InputStream)in, (byte[])magicNumber);
        if (!Arrays.equals(magicNumber, MAGIC_NUMBER)) {
            throw new InvalidQueryResults("File does not contain a binary query result");
        }
        int formatVersion = in.readInt();
        if (formatVersion < 5 || formatVersion > 6) {
            throw new InvalidQueryResults("Incompatible format version: " + formatVersion);
        }
        theHandler.start();
        int columnCount = in.readInt();
        if (columnCount < 0) {
            throw new InvalidQueryResults("Illegal column count specified: " + columnCount);
        }
        CharsetDecoder charsetDecoder = Charsets.UTF_8.newDecoder();
        ArrayList<String> columnHeaders = new ArrayList<String>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            columnHeaders.add(this.readString(in, charsetDecoder));
        }
        theHandler.variables(columnHeaders);
        byte recordTypeMarker = in.readByte();
        int idx = 0;
        BindingSets.Builder aBuilder = BindingSets.builder();
        ArrayList namespaces = Lists.newArrayListWithExpectedSize((int)32);
        while (recordTypeMarker != 127) {
            if (recordTypeMarker == 126) {
                this.processError(in, charsetDecoder);
            } else if (recordTypeMarker == 9) {
                theHandler.handle((Object)BindingSets.empty());
            } else {
                Value value = recordTypeMarker == 1 ? (Value)aPrev.value((String)columnHeaders.get(idx)).orElse(null) : this.readValue(recordTypeMarker, in, charsetDecoder, namespaces);
                aBuilder.add((String)columnHeaders.get(idx++), value);
                if (idx == columnCount) {
                    aPrev = aBuilder.build();
                    theHandler.handle((Object)aPrev);
                    aBuilder = BindingSets.builder();
                    idx = 0;
                }
            }
            recordTypeMarker = in.readByte();
        }
        theHandler.end();
    }

    private Value readValue(int recordTypeMarker, DataInputStream in, CharsetDecoder charsetDecoder, List<String> namespaces) throws IOException {
        int marker = recordTypeMarker;
        if (recordTypeMarker == 2) {
            this.processNamespace(in, charsetDecoder, namespaces);
            marker = in.readByte();
        }
        switch (marker) {
            case 0: {
                return null;
            }
            case 3: {
                return this.readQName(in, charsetDecoder, namespaces);
            }
            case 4: {
                return Values.iri((String)this.readString(in, charsetDecoder));
            }
            case 5: {
                return Values.bnode((String)this.readString(in, charsetDecoder));
            }
            case 6: 
            case 7: 
            case 8: {
                return this.readLiteral(in, charsetDecoder, marker, namespaces);
            }
            case 10: {
                return this.readStatement(in, charsetDecoder, namespaces);
            }
        }
        throw new InvalidQueryResults("Unknown record type: " + marker);
    }

    private Statement readStatement(DataInputStream in, CharsetDecoder charsetDecoder, List<String> namespaces) throws IOException {
        IRI graph;
        Resource subject = (Resource)this.readValue(in.readByte(), in, charsetDecoder, namespaces);
        IRI predicate = (IRI)this.readValue(in.readByte(), in, charsetDecoder, namespaces);
        Value object = this.readValue(in.readByte(), in, charsetDecoder, namespaces);
        byte graphMarker = in.readByte();
        if (graphMarker == 1) {
            graph = Values.DEFAULT_GRAPH;
        } else if (graphMarker == 2) {
            graph = (Resource)this.readValue(in.readByte(), in, charsetDecoder, namespaces);
        } else {
            throw new InvalidQueryResults("Invalid statement graph marker: " + graphMarker);
        }
        return Values.statement((Resource)subject, (IRI)predicate, (Value)object, (Resource)graph);
    }

    private void processError(@Nonnull DataInputStream in, @Nonnull CharsetDecoder theDecoder) throws IOException {
        byte errTypeFlag = in.readByte();
        if (errTypeFlag == 1 || errTypeFlag == 2) {
            String msg = this.readString(in, theDecoder);
            throw new InvalidQueryResults("code: " + errTypeFlag + " : " + msg);
        }
        throw new InvalidQueryResults("Unkown error type: " + errTypeFlag);
    }

    private void processNamespace(@Nonnull DataInputStream in, @Nonnull CharsetDecoder theDecoder, @Nonnull List<String> namespaces) throws IOException {
        int namespaceID = in.readInt();
        String namespace = this.readString(in, theDecoder);
        if (namespaceID >= namespaces.size()) {
            namespaces.add(namespace);
        }
    }

    private IRI readQName(@Nonnull DataInputStream in, @Nonnull CharsetDecoder theDecoder, @Nonnull List<String> namespaces) throws IOException {
        int nsID = in.readInt();
        String localName = this.readString(in, theDecoder);
        return Values.iri((String)(namespaces.get(nsID) + localName));
    }

    private Literal readLiteral(@Nonnull DataInputStream in, @Nonnull CharsetDecoder theDecoder, int recordTypeMarker, @Nonnull List<String> theNamespaces) throws IOException {
        String label = this.readString(in, theDecoder);
        if (recordTypeMarker == 8) {
            IRI datatype = null;
            byte dtTypeMarker = in.readByte();
            switch (dtTypeMarker) {
                case 3: {
                    datatype = this.readQName(in, theDecoder, theNamespaces);
                    break;
                }
                case 4: {
                    datatype = Values.iri((String)this.readString(in, theDecoder));
                    break;
                }
                default: {
                    throw new InvalidQueryResults("Illegal record type marker for literal's datatype");
                }
            }
            return Values.literal((String)label, (IRI)datatype);
        }
        if (recordTypeMarker == 7) {
            String language = this.readString(in, theDecoder);
            return Values.literal((String)label, (String)language);
        }
        return Values.literal((String)label);
    }

    private String readString(@Nonnull DataInputStream in, @Nonnull CharsetDecoder theDecoder) throws IOException {
        int stringLength = in.readInt();
        if (stringLength < 0 || (long)stringLength > 0xA00000L) {
            throw new InvalidQueryResults("Invalid string length");
        }
        byte[] encodedString = new byte[stringLength];
        ByteStreams.readFully((InputStream)in, (byte[])encodedString);
        return theDecoder.decode(ByteBuffer.wrap(encodedString)).toString();
    }
}

