/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.serf.db;

import com.complexible.common.base.Objects2;
import com.complexible.common.base.Options;
import com.complexible.common.base.Streams;
import com.complexible.stardog.serf.db.TableMappingVocabulary;
import com.google.common.base.Preconditions;
import com.stardog.model.DataModel;
import com.stardog.model.DataModelFormat;
import com.stardog.model.DataModelWriter;
import com.stardog.model.DataModelWriterOptions;
import com.stardog.model.Property;
import com.stardog.model.Type;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespace;
import com.stardog.stark.OWL;
import com.stardog.stark.Resource;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFWriters;
import com.stardog.stark.vocabs.RDF;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TableMappingDataModelWriter
implements DataModelWriter {
    private RDFHandler handler;

    public DataModelFormat getFormat() {
        return DataModelFormat.SQL;
    }

    public void write(OutputStream out, DataModel model, Options options) {
        FileFormat format = (FileFormat)Preconditions.checkNotNull((Object)((FileFormat)options.get(DataModelWriterOptions.SERIALIZATION_FORMAT)), (Object)"No serialization format provided");
        this.handler = (RDFHandler)RDFWriters.to((OutputStream)out, (RDFFormat)((RDFFormat)Objects2.castTo((Object)format, RDFFormat.class, (String)"Not a valid RDF format: %s", (Object[])new Object[]{format}))).orElseThrow(() -> new IllegalArgumentException("Unsupported RDF format provided" + String.valueOf(format)));
        this.handler.start();
        Function formatter = (Function)options.get(DataModelWriterOptions.NAME_FORMATTER);
        Iterable namespaces = (Iterable)options.get(DataModelWriterOptions.NAMESPACES);
        Map<String, String> prefixMap = Streams.stream((Iterable)namespaces).collect(Collectors.toMap(Namespace::prefix, Namespace::iri, (a, b) -> b));
        prefixMap.putIfAbsent("sql", "tag:stardog:api:sql:");
        prefixMap.entrySet().forEach(ns -> this.handler.namespace((String)ns.getKey(), (String)ns.getValue()));
        for (Type type : model.getTypes()) {
            if (type.isDatatype() || type.getName().equals(OWL.THING.toString())) continue;
            String entityName = type.getName();
            String tableName = (String)formatter.apply(type.getName());
            IRI mapping = this.tableMappingIRI(type);
            this.output((Resource)mapping, RDF.TYPE, (Value)TableMappingVocabulary.TABLE_MAPPING);
            this.output((Resource)mapping, TableMappingVocabulary.TABLE_NAME, (Value)Values.literal((String)tableName));
            this.output((Resource)mapping, TableMappingVocabulary.CLASS, (Value)Values.iri((String)entityName));
            for (Type superType : type.getSupers()) {
                this.output((Resource)mapping, TableMappingVocabulary.EXTENDS, (Value)this.tableMappingIRI(superType));
            }
            for (Property reln : type.getProperties()) {
                String relnName = reln.getName();
                String fieldName = (String)formatter.apply(relnName);
                BNode field = Values.bnode();
                this.output((Resource)mapping, TableMappingVocabulary.HAS_FIELD, (Value)field);
                this.output((Resource)field, TableMappingVocabulary.PROPERTY, (Value)Values.iri((String)relnName));
                this.output((Resource)field, TableMappingVocabulary.FIELD_NAME, (Value)Values.literal((String)fieldName));
                if (reln.getMinCardinality().orElse(0) == 0) {
                    this.output((Resource)field, TableMappingVocabulary.OPTIONAL, (Value)Values.literal((boolean)true));
                }
                if (!reln.getRange().isPresent()) continue;
                Type range = (Type)reln.getRange().get();
                if (range.isDatatype()) {
                    this.output((Resource)field, TableMappingVocabulary.FIELD_TYPE, (Value)Values.iri((String)range.getName()));
                    continue;
                }
                this.output((Resource)field, TableMappingVocabulary.REFERS_TO, (Value)this.tableMappingIRI(range));
            }
        }
        this.handler.end();
    }

    private IRI tableMappingIRI(Type type) {
        return Values.iri((String)(type.getName() + "TableMapping"));
    }

    private void output(Resource s, IRI p, Value o) {
        this.handler.handle(Values.statement((Resource)s, (IRI)p, (Value)o));
    }
}

