/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.protocols.http.client;

import com.complexible.common.base.Options;
import com.complexible.common.base.PropertiesBuilder;
import com.complexible.common.rdf.StatementSource;
import com.complexible.common.rdf.impl.MemoryStatementSource;
import com.complexible.common.rdf.rio.ParserConfigs;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.api.admin.DelegatingAdminConnection;
import com.complexible.stardog.protocols.http.JSON;
import com.complexible.stardog.protocols.http.ReplicationUtils;
import com.complexible.stardog.protocols.http.UrlUtil;
import com.complexible.stardog.protocols.http.client.AdminConnectionImpl;
import com.complexible.stardog.protocols.http.client.ApacheHttp;
import com.complexible.stardog.protocols.http.client.BaseHttpClient;
import com.complexible.stardog.protocols.http.client.Client;
import com.complexible.stardog.protocols.http.client.HttpAdminClient;
import com.complexible.stardog.protocols.http.client.HttpAdminClientImpl;
import com.complexible.stardog.protocols.http.client.HttpClient;
import com.complexible.stardog.protocols.http.shared.virtual.VirtualAdminProtocolConsts;
import com.complexible.stardog.security.ResourceNotFoundException;
import com.complexible.stardog.virtual.api.DataSourceQueryResult;
import com.complexible.stardog.virtual.api.VirtualGraph;
import com.complexible.stardog.virtual.api.admin.DataSourceInfo;
import com.complexible.stardog.virtual.api.admin.VirtualGraphAdminConnection;
import com.complexible.stardog.virtual.api.admin.VirtualGraphInfo;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Statement;
import com.stardog.stark.Values;
import com.stardog.stark.io.ParserOptions;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFParsers;
import com.stardog.stark.io.RDFWriter;
import com.stardog.stark.io.RDFWriters;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.KerberosCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.mime.ByteArrayBody;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.InputStreamBody;
import org.apache.hc.client5.http.entity.mime.StringBody;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicHeader;

public class HttpVirtualGraphAdminConnectionImpl
extends DelegatingAdminConnection
implements VirtualGraphAdminConnection,
VirtualAdminProtocolConsts {
    protected final HttpAdminClientImpl mClient;
    public static final ContentType TEXT_PLAIN_UTF_8 = ContentType.create((String)ContentType.TEXT_PLAIN.getMimeType(), (Charset)StandardCharsets.UTF_8);
    public static final ContentType MAPPING_SMS2 = ContentType.create((String)"application/mapping+sms", (Charset)StandardCharsets.UTF_8);

    protected HttpVirtualGraphAdminConnectionImpl(AdminConnectionImpl theConnection) {
        super((AdminConnection)theConnection);
        this.mClient = (HttpAdminClientImpl)theConnection.getClient();
    }

    public Collection<VirtualGraphInfo> getVirtualGraphInfos() {
        CloseableHttpResponse aResp = this.mClient.executeHttpGet(String.format("%s/%s", "virtual_graphs", "list"));
        JsonArray aResult = BaseHttpClient.parseResponseAsJsonObject((CloseableHttpResponse)aResp).getAsJsonArray("virtual_graphs");
        return StreamSupport.stream(aResult.spliterator(), false).map(JsonObject.class::cast).map(jo -> new VirtualGraphInfo(jo.get("name").getAsString(), jo.has("data_source") ? jo.get("data_source").getAsString() : null, jo.get("database").getAsString(), jo.get("available").getAsBoolean())).collect(Collectors.toList());
    }

    public VirtualGraph getGraph(String theName) throws StardogException {
        return new VirtualGraphProxy(this.getVirtualGraphInfo(theName));
    }

    public VirtualGraphInfo getVirtualGraphInfo(String theName) {
        String aEncodedName = UrlUtil.encodeUrl((String)theName);
        CloseableHttpResponse aResp = this.mClient.executeHttpGet(String.format("%s/%s/%s", "virtual_graphs", aEncodedName, "info"));
        JsonObject aResult = BaseHttpClient.parseResponseAsJsonObject((CloseableHttpResponse)aResp).getAsJsonObject("info");
        return new VirtualGraphInfo(aResult.get("name").getAsString(), aResult.get("data_source").getAsString(), aResult.get("database").getAsString(), aResult.get("available").getAsBoolean());
    }

    public VirtualGraphInfo getVirtualGraphInfoOrNull(String theName) {
        try {
            return this.getVirtualGraphInfo(theName);
        }
        catch (ResourceNotFoundException ignore) {
            return null;
        }
    }

    public Properties getOptions(String theName) {
        return this.getGraphOptions(theName);
    }

    public String getMappingsString(String theName, String theSyntax) {
        String aEncodedName = UrlUtil.encodeUrl((String)theName);
        HttpGet req = new HttpGet(this.mClient.url(String.format("%s/%s/%s/%s", "virtual_graphs", aEncodedName, "mappingsString", theSyntax)));
        req.addHeader((Header)new BasicHeader("Accept", (Object)"text/plain"));
        CloseableHttpResponse resp = null;
        try {
            resp = this.mClient.execute((ClassicHttpRequest)req);
            String string = ApacheHttp.Entities.toString((HttpEntity)resp.getEntity());
            return string;
        }
        catch (IOException | ParseException e) {
            throw Client.toStardogException((Exception)e);
        }
        finally {
            if (resp != null) {
                ApacheHttp.HttpResponses.consumeQuietly((CloseableHttpResponse)resp);
            }
        }
    }

    public boolean removeGraph(String theName) throws StardogException {
        return this.setAdminTxContext(() -> {
            try {
                String aEncodedName = UrlUtil.encodeUrl((String)theName);
                CloseableHttpResponse aResp = this.mClient.executeHttpDelete("virtual_graphs/" + aEncodedName);
                return aResp.getCode() == 204;
            }
            catch (ResourceNotFoundException ignore) {
                return false;
            }
        });
    }

    public void onlineGraph(String theName) {
        this.setAdminTxContext(() -> {
            String aEncodedName = UrlUtil.encodeUrl((String)theName);
            this.mClient.executeHttpPost("virtual_graphs/" + aEncodedName + "/online");
        });
    }

    public void addGraph(String theName, String theDatabase, Properties theProps, Iterable<Statement> theMappings) throws StardogException {
        this.addOrUpdate(false, theName, null, null, theDatabase, theProps, HttpVirtualGraphAdminConnectionImpl.serializeMappings(theMappings));
    }

    public void addGraph(String theName, String theDataSource, String theDatabase, Properties theProps, Iterable<Statement> theMappings) {
        this.addGraph(theName, theDataSource, theDatabase, theProps, HttpVirtualGraphAdminConnectionImpl.serializeMappings(theMappings));
    }

    public void addGraph(String theName, String theDatabase, Properties theProps, String theMappings) throws StardogException {
        this.addGraph(theName, null, theDatabase, theProps, theMappings);
    }

    public void addGraph(String theName, @Nullable String theDataSourceName, @Nullable Set<Statement> theMetadata, String theDatabase, Properties theProps, String theMappings) {
        this.addOrUpdate(false, theName, theDataSourceName, theMetadata, theDatabase, theProps, theMappings);
    }

    public void updateGraph(String theName, String theDatabase, Properties theProps, Iterable<Statement> theMappings) throws StardogException {
        this.updateGraph(theName, null, theDatabase, theProps, HttpVirtualGraphAdminConnectionImpl.serializeMappings(theMappings));
    }

    public void updateGraph(String theName, String theDatabase, Properties theProps, String theMappings) throws StardogException {
        this.updateGraph(theName, null, theDatabase, theProps, theMappings);
    }

    public void updateGraph(String theName, @Nullable String theDataSourceName, @Nullable Set<Statement> theMetadata, String theDatabase, Properties theProps, String theMappings) {
        this.addOrUpdate(true, theName, theDataSourceName, theMetadata, theDatabase, theProps, theMappings);
    }

    public void importGraph(String theDatabase, @Nullable String theDataSource, Properties theProps, String theMappings, String theNamedGraph, boolean theRemoveAll) {
        this.setAdminTxContext(() -> {
            JsonObject payload = new JsonObject();
            payload.addProperty("db", theDatabase);
            payload.addProperty("data_source", theDataSource);
            payload.add("options", (JsonElement)JSON.toJson((Object)theProps));
            payload.addProperty("mappings", theMappings);
            payload.addProperty("named_graph", theNamedGraph);
            payload.addProperty("remove_all", Boolean.valueOf(theRemoveAll));
            this.mClient.executeHttpPost("virtual_graphs/import_db", payload);
        });
    }

    public void importFile(String theMappings, Properties theProperties, String theDb, IRI theNg, File theFile, VirtualGraphAdminConnection.InputFileType theInputFileType) {
        this.setAdminTxContext(() -> {
            String canonicalPath;
            try {
                canonicalPath = theFile.getCanonicalPath();
            }
            catch (IOException e) {
                canonicalPath = theFile.getAbsolutePath();
            }
            LinkedHashMap<String, ContentBody> parts = this.newImportFilePartsBase(theMappings, theProperties, theDb, theNg, theFile.getName(), Values.iri((String)("file://" + canonicalPath)), theInputFileType);
            parts.put("input_file", (ContentBody)new FileBody(theFile, theInputFileType == VirtualGraphAdminConnection.InputFileType.JSON ? ContentType.APPLICATION_JSON : TEXT_PLAIN_UTF_8));
            CloseableHttpResponse resp = this.mClient.executeHttpPostMultipart("virtual_graphs/import", parts);
            ApacheHttp.HttpResponses.consumeQuietly((CloseableHttpResponse)resp);
        });
    }

    public void importFile(String theMappings, Properties theProperties, String theDb, IRI theNg, InputStream theData, String thePathFileName, IRI theFileIri, VirtualGraphAdminConnection.InputFileType theInputFileType) {
        this.setAdminTxContext(() -> {
            block12: {
                LinkedHashMap<String, ContentBody> parts = this.newImportFilePartsBase(theMappings, theProperties, theDb, theNg, thePathFileName, theFileIri, theInputFileType);
                if (this.isKerberosContext()) {
                    try {
                        File tempFile = File.createTempFile("ImportFile", "tmp");
                        try (FileOutputStream os = new FileOutputStream(tempFile);){
                            ByteStreams.copy((InputStream)theData, (OutputStream)os);
                            ((OutputStream)os).close();
                            theData.close();
                            parts.put("input_file", (ContentBody)new FileBody(tempFile, theInputFileType == VirtualGraphAdminConnection.InputFileType.JSON ? ContentType.APPLICATION_JSON : TEXT_PLAIN_UTF_8));
                            CloseableHttpResponse resp = this.mClient.executeHttpPostMultipart("virtual_graphs/import", parts);
                            ApacheHttp.HttpResponses.consumeQuietly((CloseableHttpResponse)resp);
                            break block12;
                        }
                        finally {
                            if (!tempFile.delete()) {
                                tempFile.deleteOnExit();
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                parts.put("input_file", (ContentBody)new InputStreamBody(theData, theInputFileType == VirtualGraphAdminConnection.InputFileType.JSON ? ContentType.APPLICATION_JSON : TEXT_PLAIN_UTF_8));
                CloseableHttpResponse resp = this.mClient.executeHttpPostMultipart("virtual_graphs/import", parts);
                ApacheHttp.HttpResponses.consumeQuietly((CloseableHttpResponse)resp);
            }
        });
    }

    private LinkedHashMap<String, ContentBody> newImportFilePartsBase(String theMappings, Properties theProperties, String theDb, IRI theNg, String thePathFileName, IRI theFileIri, VirtualGraphAdminConnection.InputFileType theInputFileType) {
        LinkedHashMap<String, ContentBody> parts = new LinkedHashMap<String, ContentBody>();
        parts.put("database", (ContentBody)new StringBody(theDb, TEXT_PLAIN_UTF_8));
        if (theMappings != null) {
            parts.put("mappings", (ContentBody)new ByteArrayBody(theMappings.getBytes(StandardCharsets.UTF_8), MAPPING_SMS2, "mappings"));
        }
        parts.put("options", (ContentBody)new StringBody(PropertiesBuilder.propertiesToString((Properties)theProperties), TEXT_PLAIN_UTF_8));
        if (theNg != null) {
            parts.put("named_graph", (ContentBody)new StringBody(theNg.toString(), TEXT_PLAIN_UTF_8));
        }
        if (thePathFileName != null) {
            parts.put("input_file_name", (ContentBody)new StringBody(thePathFileName, TEXT_PLAIN_UTF_8));
        }
        if (theFileIri != null) {
            parts.put("input_file_iri", (ContentBody)new StringBody(theFileIri.toString(), TEXT_PLAIN_UTF_8));
        }
        parts.put("input_file_type", (ContentBody)new StringBody(theInputFileType.name(), TEXT_PLAIN_UTF_8));
        return parts;
    }

    private boolean isKerberosContext() {
        BasicCredentialsProvider credentialsProvider = (BasicCredentialsProvider)this.mClient.context().getAttribute("http.auth.credentials-provider");
        return credentialsProvider != null && credentialsProvider.getCredentials(new AuthScope(null, -1), this.mClient.context()) instanceof KerberosCredentials;
    }

    public void addDataSource(String theName, Properties theOptions) {
        this.addOrUpdateDataSource(theName, null, theOptions, false, false, true, false);
    }

    public void updateDataSource(String theName, @Nullable Set<Statement> theMetadata, Properties theOptions, boolean theForce, boolean theShareable) {
        this.addOrUpdateDataSource(theName, theMetadata, theOptions, true, theForce, theShareable, false);
    }

    public void modifyDataSource(String theName, Properties theOptionUpdates) {
        DataSourceInfo dataSourceInfo = this.getDataSourceInfo(theName);
        this.addOrUpdateDataSource(theName, null, theOptionUpdates, true, true, dataSourceInfo.isSharable(), true);
    }

    private void addOrUpdateDataSource(String theName, @Nullable Set<Statement> theMetadata, Properties theOptions, boolean theIsUpdate, boolean theForce, boolean theShareable, boolean theDeltaOptions) {
        this.setAdminTxContext(() -> {
            JsonObject payload = new JsonObject();
            if (theMetadata != null) {
                String turtle = RDFWriters.toString((Iterable)theMetadata, (RDFFormat)RDFFormats.TURTLE);
                payload.addProperty("metadata", turtle);
            }
            payload.add("options", (JsonElement)JSON.toJson((Object)theOptions));
            if (theIsUpdate) {
                payload.add("force", (JsonElement)new JsonPrimitive(Boolean.valueOf(theForce)));
                payload.add("sharable", (JsonElement)new JsonPrimitive(Boolean.valueOf(theShareable)));
                payload.add("delta_options", (JsonElement)new JsonPrimitive(Boolean.valueOf(theDeltaOptions)));
                this.mClient.executeHttpPut("data_sources/" + theName, payload);
            } else {
                payload.add("name", (JsonElement)new JsonPrimitive(theName));
                this.mClient.executeHttpPost("data_sources", payload);
            }
        });
    }

    public boolean removeDataSource(String theName, boolean theForce) {
        return this.setAdminTxContext(() -> {
            try {
                String aEncodedName = UrlUtil.encodeUrl((String)theName);
                CloseableHttpResponse aResp = this.mClient.executeHttpDelete("data_sources/" + aEncodedName + "?force=" + theForce);
                return aResp.getCode() == 204;
            }
            catch (ResourceNotFoundException ignore) {
                return false;
            }
        });
    }

    public void shareDataSource(String theName) {
        this.setAdminTxContext(() -> {
            try {
                String aEncodedName = UrlUtil.encodeUrl((String)theName);
                this.mClient.executeHttpPost(String.format("%s/%s/%s", "data_sources", aEncodedName, "share"));
            }
            catch (Exception e) {
                Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
                throw new StardogException((Throwable)e);
            }
        });
    }

    public Collection<DataSourceInfo> getDataSourceInfos() {
        CloseableHttpResponse aResp = this.mClient.executeHttpGet(String.format("%s/%s", "data_sources", "list"));
        JsonArray aResult = BaseHttpClient.parseResponseAsJsonObject((CloseableHttpResponse)aResp).getAsJsonArray("data_sources");
        return StreamSupport.stream(aResult.spliterator(), false).map(JsonObject.class::cast).map(jo -> new DataSourceInfo(Values.iri((String)jo.get("entityName").getAsString()), jo.get("sharable").getAsBoolean(), jo.get("available").getAsBoolean(), jo.get("type").getAsString())).collect(Collectors.toList());
    }

    public void onlineDataSource(String theName) {
        this.setAdminTxContext(() -> {
            String aEncodedName = UrlUtil.encodeUrl((String)theName);
            this.mClient.executeHttpPost("data_sources/" + aEncodedName + "/online");
        });
    }

    public void testDataSource(String theName) {
        this.setAdminTxContext(() -> {
            String aEncodedName = UrlUtil.encodeUrl((String)theName);
            this.mClient.executeHttpPost("data_sources/" + aEncodedName + "/test_data_source");
        });
    }

    public void testNewConnection(Properties theOptions) {
        this.setAdminTxContext(() -> {
            JsonObject payload = new JsonObject();
            payload.add("options", (JsonElement)JSON.toJson((Object)theOptions));
            this.mClient.executeHttpPost("data_sources/test_new_connection", payload);
        });
    }

    public DataSourceInfo getDataSourceInfo(String theName) {
        try {
            String aEncodedName = UrlUtil.encodeUrl((String)theName);
            CloseableHttpResponse aResp = this.mClient.executeHttpGet(String.format("%s/%s/%s", "data_sources", aEncodedName, "info"));
            JsonObject aResult = BaseHttpClient.parseResponseAsJsonObject((CloseableHttpResponse)aResp).getAsJsonObject("info");
            return new DataSourceInfo(Values.iri((String)aResult.get("entityName").getAsString()), aResult.get("sharable").getAsBoolean(), aResult.get("available").getAsBoolean(), aResult.get("type").getAsString());
        }
        catch (BaseHttpClient.HttpClientException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e.getCause();
            }
            throw e;
        }
    }

    public Properties getDataSourceOptions(String theName) {
        String aEncodedName = UrlUtil.encodeUrl((String)theName);
        CloseableHttpResponse aResp = this.mClient.executeHttpGet("data_sources/" + aEncodedName + "/options");
        return this.parseResponseAsOptions(aResp);
    }

    public Set<Statement> getDataSourceMetadata(String theName) {
        Set set;
        String aEncodedName = UrlUtil.encodeUrl((String)theName);
        HttpGet get = new HttpGet(this.mClient.url(String.format("%s/%s/%s", "data_sources", aEncodedName, "metadata")));
        RDFFormat format = RDFFormats.TURTLE;
        ApacheHttp.HttpRequests.accept((HttpMessage)get, (String)format.defaultMimeType());
        CloseableHttpResponse response = null;
        try {
            response = this.mClient.execute((ClassicHttpRequest)get);
            InputStream stream = response.getEntity().getContent();
            set = RDFParsers.read((InputStream)stream, (RDFFormat)format);
        }
        catch (Exception e) {
            try {
                Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
                throw new StardogException((Throwable)e);
            }
            catch (Throwable throwable) {
                ApacheHttp.HttpResponses.consumeQuietly(response);
                throw throwable;
            }
        }
        ApacheHttp.HttpResponses.consumeQuietly((CloseableHttpResponse)response);
        return set;
    }

    public void replaceTableMetadata(String theDataSourceName, @Nullable String theCatalog, @Nullable String theSchema, String theTableName, String theTableType, Set<Statement> theMetadata, Map<String, Boolean> theVgAvailability) {
        JsonObject payload = new JsonObject();
        payload.addProperty("catalog", theCatalog);
        payload.addProperty("schema", theSchema);
        payload.addProperty("table_name", theTableName);
        payload.addProperty("table_type", theTableType);
        payload.add("metadata", (JsonElement)new JsonPrimitive(this.getBinaryRdfBase64(theMetadata)));
        JsonObject availability = new JsonObject();
        theVgAvailability.forEach((k, v) -> availability.add(k, (JsonElement)new JsonPrimitive(v)));
        payload.add("vg_availability", (JsonElement)availability);
        this.callRefreshEndPoint(theDataSourceName, "replace_table_metadata", payload);
    }

    public void replaceAllMetadata(String theDataSourceName, Set<Statement> theMetadata, Map<String, Boolean> theVgAvailability) {
        JsonObject payload = new JsonObject();
        payload.add("metadata", (JsonElement)new JsonPrimitive(this.getBinaryRdfBase64(theMetadata)));
        JsonObject availability = new JsonObject();
        theVgAvailability.forEach((k, v) -> availability.add(k, (JsonElement)new JsonPrimitive(v)));
        payload.add("vg_availability", (JsonElement)availability);
        this.callRefreshEndPoint(theDataSourceName, "replace_all_metadata", payload);
    }

    private String getBinaryRdfBase64(Set<Statement> theStatements) {
        ByteArrayOutputStream aOut = new ByteArrayOutputStream();
        RDFWriters.write((RDFWriter)((RDFWriter)RDFWriters.to((OutputStream)aOut, (RDFFormat)RDFFormats.BINARY).get()), theStatements, (Iterable)Namespaces.DEFAULT);
        byte[] bytes = aOut.toByteArray();
        return Base64.getEncoder().encodeToString(bytes);
    }

    public JsonArray getDataSourceTables(String dsName) {
        String aEncodedName = UrlUtil.encodeUrl((String)dsName);
        CloseableHttpResponse resp = this.mClient.executeHttpGet(String.format("%s/%s/%s", "data_sources", aEncodedName, "tables"));
        try {
            String s = ApacheHttp.Entities.toString((HttpEntity)resp.getEntity());
            return (JsonArray)new GsonBuilder().create().fromJson(s, JsonArray.class);
        }
        catch (IOException | ParseException e) {
            throw new StardogException(e);
        }
    }

    public Set<Statement> getTableMetadataRdf(String dsName, @Nullable String catalog, @Nullable String schema, String tableName, String tableType) {
        Set set;
        JsonObject payload = new JsonObject();
        payload.addProperty("catalog", catalog);
        payload.addProperty("schema", schema);
        payload.addProperty("table_name", tableName);
        payload.addProperty("table_type", tableType);
        CloseableHttpResponse response = null;
        try {
            HttpPost post = new HttpPost(this.mClient.url(String.format("%s/%s/%s", "data_sources", dsName, "table_metadata")));
            post.setEntity((HttpEntity)new StringEntity(payload.toString()));
            post.setHeader("Content-type", (Object)"application/json");
            RDFFormat format = RDFFormats.TURTLE;
            ApacheHttp.HttpRequests.accept((HttpMessage)post, (String)format.defaultMimeType());
            response = this.mClient.execute((ClassicHttpRequest)post);
            InputStream stream = response.getEntity().getContent();
            set = RDFParsers.read((InputStream)stream, (RDFFormat)format);
        }
        catch (Exception e) {
            try {
                Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
                throw new StardogException((Throwable)e);
            }
            catch (Throwable throwable) {
                ApacheHttp.HttpResponses.consumeQuietly(response);
                throw throwable;
            }
        }
        ApacheHttp.HttpResponses.consumeQuietly((CloseableHttpResponse)response);
        return set;
    }

    public JsonObject getTableMetadataJson(String dsName, @Nullable String catalog, @Nullable String schema, String tableName, String tableType) {
        JsonObject jsonObject;
        JsonObject payload = new JsonObject();
        payload.addProperty("catalog", catalog);
        payload.addProperty("schema", schema);
        payload.addProperty("table_name", tableName);
        payload.addProperty("table_type", tableType);
        CloseableHttpResponse response = null;
        try {
            HttpPost post = new HttpPost(this.mClient.url(String.format("%s/%s/%s", "data_sources", dsName, "table_metadata")));
            post.setEntity((HttpEntity)new StringEntity(payload.toString()));
            post.setHeader("Content-type", (Object)"application/json");
            ApacheHttp.HttpRequests.accept((HttpMessage)post, (String)"application/json");
            response = this.mClient.execute((ClassicHttpRequest)post);
            jsonObject = (JsonObject)new GsonBuilder().create().fromJson(ApacheHttp.Entities.toString((HttpEntity)response.getEntity()), JsonObject.class);
        }
        catch (Exception e) {
            try {
                Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
                throw new StardogException((Throwable)e);
            }
            catch (Throwable throwable) {
                ApacheHttp.HttpResponses.consumeQuietly(response);
                throw throwable;
            }
        }
        ApacheHttp.HttpResponses.consumeQuietly((CloseableHttpResponse)response);
        return jsonObject;
    }

    public void refreshMetadata(String theDataSourceName, @Nullable String theTableName) {
        this.callRefreshEndPoint(theDataSourceName, "refresh_metadata", this.nameAsJson(theTableName));
    }

    public void refreshCounts(String theDataSourceName, @Nullable String theTableName) {
        this.callRefreshEndPoint(theDataSourceName, "refresh_counts", this.nameAsJson(theTableName));
    }

    private JsonObject nameAsJson(@Nullable String theName) {
        JsonObject payload = new JsonObject();
        if (theName != null) {
            payload.addProperty("name", theName);
        }
        return payload;
    }

    private void callRefreshEndPoint(String theDataSourceName, String theRefreshEndPoint, JsonObject thePayload) {
        this.setAdminTxContext(() -> {
            try {
                String aEncodedName = UrlUtil.encodeUrl((String)theDataSourceName);
                this.mClient.executeHttpPost("data_sources/" + aEncodedName + "/" + theRefreshEndPoint, thePayload);
            }
            catch (BaseHttpClient.HttpClientException e) {
                if (e.getCause() != null) {
                    Throwables.throwIfUnchecked((Throwable)e.getCause());
                }
                throw e;
            }
        });
    }

    public void replaceDataSourceMetadata(String theName, Collection<Statement> theStatements) {
        this.setAdminTxContext(() -> {
            String aEncodedName = UrlUtil.encodeUrl((String)theName);
            String turtle = RDFWriters.toString((Iterable)theStatements, (RDFFormat)RDFFormats.TURTLE);
            this.mClient.executeHttpPut("data_sources/" + aEncodedName + "/metadata", turtle, "application/x-turtle");
        });
    }

    public DataSourceQueryResult queryDataSource(String theName, String theQuery, String theTimeout, Properties theOptions) {
        DataSourceQueryResult dataSourceQueryResult;
        CloseableHttpResponse response = null;
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("query", theQuery);
            payload.add("options", (JsonElement)JSON.toJson((Object)theOptions));
            String aEncodedName = UrlUtil.encodeUrl((String)theName);
            HttpPost aPost = new HttpPost(this.mClient.url(String.format("%s/%s/query", "data_sources", aEncodedName)));
            aPost.addHeader((Header)new BasicHeader("timeout", (Object)theTimeout));
            aPost.setEntity((HttpEntity)new StringEntity(payload.toString()));
            aPost.setHeader("Content-type", (Object)"application/json");
            aPost.setHeader("Accept", (Object)"application/json");
            response = this.mClient.execute((ClassicHttpRequest)aPost);
            InputStream stream = response.getEntity().getContent();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            Gson gson = new Gson();
            dataSourceQueryResult = (DataSourceQueryResult)gson.fromJson((Reader)reader, DataSourceQueryResult.class);
        }
        catch (Exception e) {
            try {
                Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
                throw new StardogException((Throwable)e);
            }
            catch (Throwable throwable) {
                ApacheHttp.HttpResponses.consumeQuietly(response);
                throw throwable;
            }
        }
        ApacheHttp.HttpResponses.consumeQuietly((CloseableHttpResponse)response);
        return dataSourceQueryResult;
    }

    public String getDbTypeOptionsDescription() {
        CloseableHttpResponse resp = this.mClient.executeHttpGet("data_sources/data_source_type_description");
        try {
            String resultString = ApacheHttp.Entities.toString((HttpEntity)resp.getEntity());
            JsonObject root = (JsonObject)JsonParser.parseString((String)resultString);
            return root.get("data_source_type_description").toString();
        }
        catch (Exception e) {
            throw new StardogException((Throwable)e);
        }
    }

    private void addOrUpdate(boolean theIsUpdate, String theName, String theDataSource, Set<Statement> theMetadata, String theDatabase, Properties theProps, String theMappings) throws StardogException {
        this.setAdminTxContext(() -> {
            JsonObject payload = new JsonObject();
            payload.add("options", (JsonElement)JSON.toJson((Object)theProps));
            payload.addProperty("data_source", theDataSource);
            if (theMetadata != null) {
                String turtle = RDFWriters.toString((Iterable)theMetadata, (RDFFormat)RDFFormats.TURTLE);
                payload.addProperty("metadata", turtle);
            }
            payload.addProperty("db", theDatabase);
            payload.addProperty("mappings", theMappings);
            if (theIsUpdate) {
                this.mClient.executeHttpPut("virtual_graphs/" + theName, payload);
            } else {
                payload.addProperty("name", theName);
                this.mClient.executeHttpPost("virtual_graphs", payload);
            }
        });
    }

    private static String serializeMappings(Iterable<Statement> theMappings) {
        if (!Iterables.isEmpty(theMappings)) {
            return RDFWriters.toString(theMappings, (RDFFormat)RDFFormats.TURTLE);
        }
        return "";
    }

    private Set<Statement> getGraphMappings(String theName) throws StardogException {
        String aEncodedName = UrlUtil.encodeUrl((String)theName);
        HttpGet aGet = new HttpGet(this.mClient.url("virtual_graphs/" + aEncodedName + "/mappings"));
        aGet.setHeader(HttpClient.ACCEPT_TRIG_HEADER);
        CloseableHttpResponse aResponse = this.mClient.execute((ClassicHttpRequest)aGet);
        String aContentType = aResponse.getEntity().getContentType();
        RDFFormat aFmt = aContentType == null ? RDFFormats.TRIG : RDFFormats.forMime((String)aContentType).orElse(RDFFormats.TRIG);
        try {
            InputStream aContent = aResponse.getEntity().getContent();
            return RDFParsers.read((InputStream)aContent, (RDFFormat)aFmt, (Options)ParserConfigs.strict().set(ParserOptions.BASE_IRI, (Object)"http://api.stardog.com/"));
        }
        catch (IOException ioe) {
            throw new StardogException((Throwable)ioe);
        }
    }

    private Properties getGraphOptions(String theName) throws StardogException {
        String aEncodedName = UrlUtil.encodeUrl((String)theName);
        CloseableHttpResponse aResp = this.mClient.executeHttpGet("virtual_graphs/" + aEncodedName + "/options");
        return this.parseResponseAsOptions(aResp);
    }

    private Properties parseResponseAsOptions(CloseableHttpResponse aResp) {
        Properties properties = new Properties();
        BaseHttpClient.parseResponseAsJsonObject((CloseableHttpResponse)aResp).getAsJsonObject("options").entrySet().forEach(option -> properties.setProperty((String)option.getKey(), ((JsonElement)option.getValue()).getAsString()));
        return properties;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isGraphAvailable(String theName) throws StardogException {
        String aEncodedName = UrlUtil.encodeUrl((String)theName);
        try (CloseableHttpResponse aResp = this.mClient.executeHttpGet("virtual_graphs/" + aEncodedName + "/available");){
            boolean bl;
            try (InputStreamReader aReader = new InputStreamReader(aResp.getEntity().getContent());){
                JsonObject aObj = JsonParser.parseReader((Reader)aReader).getAsJsonObject();
                bl = aObj.has("available") && aObj.get("available").getAsBoolean();
            }
            return bl;
        }
        catch (IOException e) {
            Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    public Set<Statement> getMatchingSuggestions(Set<Statement> theInput) {
        Set set;
        CloseableHttpResponse aResponse = null;
        try {
            HttpPost aPost = new HttpPost(this.mClient.getHost().toURI() + "/matcher/suggestions");
            aPost.setEntity(ApacheHttp.Entities.create((StatementSource)new MemoryStatementSource(theInput), (RDFFormat)RDFFormats.BINARY));
            aPost.setHeader("Content-type", (Object)"application/x-binary-rdf");
            aPost.setHeader("Accept", (Object)"application/x-binary-rdf");
            aResponse = this.mClient.execute((ClassicHttpRequest)aPost);
            HttpEntity entity = aResponse.getEntity();
            String contentType = entity.getContentType();
            RDFFormat aFormat = contentType == null ? RDFFormats.BINARY : RDFFormats.forMime((String)contentType).orElse(RDFFormats.BINARY);
            set = RDFParsers.read((InputStream)aResponse.getEntity().getContent(), (RDFFormat)aFormat);
        }
        catch (Exception e) {
            try {
                Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
                throw new StardogException((Throwable)e);
            }
            catch (Throwable throwable) {
                ApacheHttp.HttpResponses.consumeQuietly(aResponse);
                throw throwable;
            }
        }
        ApacheHttp.HttpResponses.consumeQuietly((CloseableHttpResponse)aResponse);
        return set;
    }

    private void setAdminTxContext(Runnable theRunnable) {
        HttpVirtualGraphAdminConnectionImpl.setAdminTxContext((HttpAdminClient)this.mClient, () -> {
            theRunnable.run();
            return null;
        });
    }

    private <T> T setAdminTxContext(Callable<T> theRunnable) {
        return HttpVirtualGraphAdminConnectionImpl.setAdminTxContext((HttpAdminClient)this.mClient, theRunnable);
    }

    private static <T> T setAdminTxContext(HttpAdminClient theClient, Callable<T> theRunnable) {
        try {
            ((Optional)ReplicationUtils.OPTIONAL_ADMIN_TX_ID.get()).ifPresent(v -> theClient.context().setAttribute("headers", (Object)ImmutableList.of((Object)new BasicHeader("SD-Admin-TxId", v))));
            T t = theRunnable.call();
            return t;
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
        finally {
            theClient.context().removeAttribute("headers");
        }
    }

    private class VirtualGraphProxy
    implements VirtualGraph {
        private final String mName;
        private final IRI mDataSourceName;
        private final String mDatabase;

        VirtualGraphProxy(VirtualGraphInfo info) {
            this.mName = info.getName();
            this.mDatabase = info.getDatabase();
            this.mDataSourceName = Values.iri((String)info.getDataSourceName());
        }

        public String getName() {
            return this.mName;
        }

        public IRI getDataSourceName() {
            return this.mDataSourceName;
        }

        public String getDatabase() {
            return this.mDatabase;
        }

        public Set<Statement> getMappings() {
            try {
                return HttpVirtualGraphAdminConnectionImpl.this.getGraphMappings(this.mName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Properties getOptions() {
            try {
                return HttpVirtualGraphAdminConnectionImpl.this.getGraphOptions(this.mName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public boolean isAvailable() {
            try {
                return HttpVirtualGraphAdminConnectionImpl.this.isGraphAvailable(this.mName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

