/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.catalog.protocols.http.client;

import com.complexible.common.base.Pair;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.api.admin.DelegatingAdminConnection;
import com.complexible.stardog.catalog.CatalogAdminConnection;
import com.complexible.stardog.catalog.CatalogDatabaseStatus;
import com.complexible.stardog.catalog.CatalogJobStatus;
import com.complexible.stardog.catalog.CatalogProviderStatus;
import com.complexible.stardog.catalog.CatalogStatus;
import com.complexible.stardog.catalog.ConnectionStatus;
import com.complexible.stardog.catalog.Credentials;
import com.complexible.stardog.protocols.http.client.AdminConnectionImpl;
import com.complexible.stardog.protocols.http.client.ApacheHttp;
import com.complexible.stardog.protocols.http.client.BaseHttpClient;
import com.complexible.stardog.protocols.http.client.HttpAdminClientImpl;
import com.google.common.base.Throwables;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.stardog.stark.IRI;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.json.JSONObject;

public class HttpCatalogAdminConnectionImpl
extends DelegatingAdminConnection
implements CatalogAdminConnection {
    protected final HttpAdminClientImpl mClient;
    public static final String CATALOG_PATH_COMPONENT = "catalog";
    public static final String CATALOG_RELOAD = "reload";
    public static final String RELOAD_MODEL = "reloadModel";
    public static final String CATALOG_STATUS = "status";
    public static final String CATALOG_ACTIVE = "active";
    public static final String CREDENTIALS = "credentials";
    public static final String JOBS = "jobs";
    public static final String DATABASE = "database";

    protected HttpCatalogAdminConnectionImpl(AdminConnectionImpl theConnection) {
        super((AdminConnection)theConnection);
        this.mClient = (HttpAdminClientImpl)theConnection.getClient();
    }

    public void reloadCatalog(IRI theProvider) {
        HttpPost req = new HttpPost(this.mClient.url("catalog/reload"));
        try {
            JsonObject body = new JsonObject();
            body.addProperty("provider", theProvider.toString());
            req.setEntity((HttpEntity)new StringEntity(body.toString()));
            req.setHeader("Accept", (Object)"application/json");
            ApacheHttp.HttpResponses.consume((CloseableHttpResponse)this.mClient.execute((ClassicHttpRequest)req));
        }
        catch (Exception e) {
            throw new StardogException((Throwable)e);
        }
    }

    public void reloadModel() {
        HttpPost req = new HttpPost(this.mClient.url("catalog/reloadModel"));
        try {
            ApacheHttp.HttpResponses.consume((CloseableHttpResponse)this.mClient.execute((ClassicHttpRequest)req));
        }
        catch (Exception e) {
            throw new StardogException((Throwable)e);
        }
    }

    public CatalogStatus getStatus() {
        HttpGet req = new HttpGet(this.mClient.url("catalog/status"));
        try {
            CloseableHttpResponse aResp = this.mClient.execute((ClassicHttpRequest)req);
            JsonObject aResult = BaseHttpClient.parseResponseAsJsonObject((CloseableHttpResponse)aResp).getAsJsonObject();
            CatalogStatus result = new CatalogStatus();
            result.setScheduler(aResult.get("scheduler").getAsString());
            result.setStartTime(aResult.get("started").getAsString());
            result.setThreadCount(aResult.get("threads").getAsInt());
            JsonArray providers = aResult.get("providers").getAsJsonArray();
            for (JsonElement provider : providers) {
                JsonObject provObj = provider.getAsJsonObject();
                String name = provObj.get("name").getAsString();
                String type = provObj.get("type").getAsString();
                String sched = provObj.get("schedule").getAsString();
                String update = provObj.get("lastupdate").getAsString();
                CatalogProviderStatus provStat = new CatalogProviderStatus(name, type, sched, update);
                result.getProviders().add(provStat);
            }
            JsonArray jobs = aResult.get(JOBS).getAsJsonArray();
            for (JsonElement job : jobs) {
                JsonObject jobObj = job.getAsJsonObject();
                String name = jobObj.get("name").getAsString();
                String group = jobObj.get("group").getAsString();
                String prev = jobObj.get("prev").getAsString();
                String next = jobObj.get("next").getAsString();
                String jobState = jobObj.get("job_state").getAsString();
                String schedState = jobObj.get("schedule_state").getAsString();
                CatalogJobStatus jobStat = new CatalogJobStatus(name, group, prev, next, schedState, jobState);
                result.getJobs().add(jobStat);
            }
            return result;
        }
        catch (Exception e) {
            throw new StardogException((Throwable)e);
        }
    }

    public CatalogDatabaseStatus getDatabaseStatus() {
        HttpGet req = new HttpGet(this.mClient.url("catalog/database/status"));
        try {
            CloseableHttpResponse aResp = this.mClient.execute((ClassicHttpRequest)req);
            JsonObject aResult = BaseHttpClient.parseResponseAsJsonObject((CloseableHttpResponse)aResp).getAsJsonObject();
            CatalogDatabaseStatus status = new CatalogDatabaseStatus();
            JsonObject statusObj = aResult.getAsJsonObject();
            status.setDatabaseExists(statusObj.get("database_exists").getAsBoolean());
            status.setDatabaseName(statusObj.get("catalog_database").getAsString());
            status.setCatalogIdentity(Values.iri((String)statusObj.get("catalog_identity").getAsString()));
            JsonArray permsObj = statusObj.getAsJsonArray("database_permissions");
            if (permsObj != null) {
                for (JsonElement perm : permsObj) {
                    status.addPermission(perm.getAsString());
                }
            }
            return status;
        }
        catch (Exception e) {
            throw new StardogException((Throwable)e);
        }
    }

    public String addCredentials(Credentials theCredentials, String theLabel) {
        String string;
        block16: {
            HttpPost req = new HttpPost(this.mClient.url("catalog/credentials"));
            JsonObject body = new JsonObject();
            if (theCredentials.get("username") != null) {
                body.addProperty("username", theCredentials.get("username"));
                body.addProperty("password", theCredentials.get("password"));
            } else if (theCredentials.get("token") != null) {
                body.addProperty("token", theCredentials.get("token"));
            } else if (theCredentials.get("clientId") != null) {
                body.addProperty("clientId", theCredentials.get("clientId"));
                body.addProperty("clientSecret", theCredentials.get("clientSecret"));
            }
            body.addProperty("label", theLabel);
            if (theCredentials.hasSecret()) {
                JsonObject secretObj = new JsonObject();
                secretObj.addProperty("manager", theCredentials.getSecret().getSecretSourceIdentity().toString());
                if (theCredentials.getSecret().getSecretId() != null) {
                    secretObj.addProperty("id", theCredentials.getSecret().getSecretId());
                }
                if (theCredentials.getSecret().getVersionId() != null) {
                    secretObj.addProperty("version", theCredentials.getSecret().getVersionId());
                }
                body.add("secret", (JsonElement)secretObj);
            }
            req.setEntity((HttpEntity)new StringEntity(body.toString()));
            req.setHeader("Content-type", (Object)"application/json");
            req.setHeader("Accept", (Object)"application/json");
            CloseableHttpResponse response = this.mClient.execute((ClassicHttpRequest)req);
            try {
                JSONObject aJson = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
                string = aJson.getString("accessKey");
                if (response == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
                    throw new StardogException((Throwable)e);
                }
            }
            response.close();
        }
        return string;
    }

    public void removeCredential(UUID theId) {
        HttpDelete req = new HttpDelete(this.mClient.url("catalog/credentials/" + theId.toString()));
        try {
            this.mClient.execute((ClassicHttpRequest)req);
        }
        catch (Exception e) {
            throw new StardogException((Throwable)e);
        }
    }

    public List<Pair<UUID, String>> listCredentials() {
        HttpGet req = new HttpGet(this.mClient.url("catalog/credentials"));
        try {
            CloseableHttpResponse aResp = this.mClient.execute((ClassicHttpRequest)req);
            JsonArray aResult = BaseHttpClient.parseResponseAsJsonArray((CloseableHttpResponse)aResp);
            ArrayList<Pair<UUID, String>> results = new ArrayList<Pair<UUID, String>>();
            for (JsonElement cred : aResult) {
                JsonObject credObj = cred.getAsJsonObject();
                String key = credObj.get("key").getAsString();
                String label = credObj.get("label").getAsString();
                results.add((Pair<UUID, String>)Pair.create((Object)UUID.fromString(key), (Object)label));
            }
            return results;
        }
        catch (Exception e) {
            throw new StardogException((Throwable)e);
        }
    }

    public void runJob(String theJobName) {
        HttpPost req = new HttpPost(this.mClient.url("catalog/jobs/run"));
        try {
            JsonObject body = new JsonObject();
            body.addProperty("jobname", theJobName);
            req.setEntity((HttpEntity)new StringEntity(body.toString()));
            req.setHeader("Content-type", (Object)"application/json");
            req.setHeader("Accept", (Object)"application/json");
            this.mClient.execute((ClassicHttpRequest)req);
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    public ConnectionStatus getProviderConnectionStatus(Set<Statement> theProperties) {
        HttpPost req = new HttpPost(this.mClient.url("catalog/providers/test_connection_properties"));
        try {
            JsonObject body = new JsonObject();
            for (Statement aStatement : theProperties) {
                body.addProperty(aStatement.predicate().localName(), Value.lex((Value)aStatement.object()));
            }
            req.setEntity((HttpEntity)new StringEntity(body.toString()));
            req.setHeader("Content-type", (Object)"application/json");
            req.setHeader("Accept", (Object)"application/json");
            CloseableHttpResponse aResp = this.mClient.execute((ClassicHttpRequest)req);
            JsonObject respObj = BaseHttpClient.parseResponseAsJsonObject((CloseableHttpResponse)aResp);
            boolean connected = respObj.get("connected").getAsBoolean();
            String msg = respObj.get("message").getAsString();
            return new ConnectionStatus(connected, msg);
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }
}

