/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.rdfxml;

import com.complexible.common.base.Options;
import com.google.common.collect.Maps;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.io.ParserOptions;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFWriter;
import com.stardog.stark.io.RDFWriterFactory;
import com.stardog.stark.io.WritingFailed;
import com.stardog.stark.io.rdfxml.RDFXMLWriterOptions;
import com.stardog.stark.io.rdfxml.XMLUtil;
import com.stardog.stark.vocabs.RDF;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import javax.annotation.Nonnull;

public class RDFXMLWriter
implements RDFWriter {
    protected final Writer mWriter;
    protected final Options mOptions;
    protected String defaultNamespace;
    protected boolean writingStarted;
    protected boolean headerWritten;
    protected Resource lastWrittenSubject;
    protected Map<String, String> namespaceTable = Maps.newHashMap();

    public RDFXMLWriter(OutputStream theStream, Options theOptions) {
        this.mOptions = theOptions;
        this.mWriter = new OutputStreamWriter(theStream, this.format().charset());
        this.writingStarted = false;
        this.headerWritten = false;
        this.lastWrittenSubject = null;
    }

    public void start() throws WritingFailed {
        if (this.writingStarted) {
            throw new WritingFailed("Document writing has already started");
        }
        this.writingStarted = true;
    }

    protected void writeHeader() throws IOException {
        try {
            this.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            if (this.mOptions.is(RDFXMLWriterOptions.INCLUDE_XML_PI)) {
                this.mWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            }
            if (this.mOptions.is(RDFXMLWriterOptions.INCLUDE_ROOT_RDF_TAG)) {
                this.writeStartOfStartTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF");
                if (this.defaultNamespace != null) {
                    this.writeNewLine();
                    this.writeIndent();
                    this.mWriter.write("xmlns=\"");
                    this.mWriter.write(XMLUtil.escapeDoubleQuotedAttValue(this.defaultNamespace));
                    this.mWriter.write(34);
                }
                this.namespaceTable.forEach((name, prefix) -> {
                    try {
                        this.writeNewLine();
                        this.writeIndent();
                        this.mWriter.write("xmlns:");
                        this.mWriter.write((String)prefix);
                        this.mWriter.write("=\"");
                        this.mWriter.write(XMLUtil.escapeDoubleQuotedAttValue(name));
                        this.mWriter.write(34);
                    }
                    catch (IOException e) {
                        throw new WritingFailed((Throwable)e);
                    }
                });
                this.writeEndOfStartTag();
            }
            this.writeNewLine();
        }
        finally {
            this.headerWritten = true;
        }
    }

    public void end() throws WritingFailed {
        if (!this.writingStarted) {
            throw new IllegalStateException("Document writing has not yet started");
        }
        try {
            if (!this.headerWritten) {
                this.writeHeader();
            }
            this.flushPendingStatements();
            this.writeNewLine();
            if (this.mOptions.is(RDFXMLWriterOptions.INCLUDE_ROOT_RDF_TAG)) {
                this.writeEndTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF");
            }
            this.mWriter.flush();
        }
        catch (IOException e) {
            throw new WritingFailed((Throwable)e);
        }
        finally {
            this.writingStarted = false;
            this.headerWritten = false;
        }
    }

    public void namespace(@Nonnull String prefix, @Nonnull String name) {
        this.setNamespace(prefix, name);
    }

    protected String setNamespace(String prefix, String name) {
        if (this.headerWritten) {
            return prefix;
        }
        if (((String)prefix).length() == 0) {
            this.defaultNamespace = name;
            return prefix;
        }
        if (this.namespaceTable.containsKey(name)) {
            return prefix;
        }
        boolean isLegalPrefix = XMLUtil.isNCName((String)prefix);
        if (!isLegalPrefix || this.namespaceTable.containsValue(prefix)) {
            if (!isLegalPrefix) {
                prefix = "ns";
            }
            int number = 1;
            while (this.namespaceTable.containsValue((String)prefix + number)) {
                ++number;
            }
            prefix = (String)prefix + number;
        }
        this.namespaceTable.put(name, (String)prefix);
        return prefix;
    }

    public void handle(@Nonnull Statement theStmt) throws WritingFailed {
        if (!this.writingStarted) {
            throw new WritingFailed("Document writing has not yet been started");
        }
        Resource subj = theStmt.subject();
        IRI pred = theStmt.predicate();
        Value obj = theStmt.object();
        String predString = pred.toString();
        int predSplitIdx = XMLUtil.findURISplitIndex(predString);
        if (predSplitIdx == -1) {
            throw new WritingFailed("Unable to create XML namespace-qualified name for predicate: " + predString);
        }
        String predNamespace = predString.substring(0, predSplitIdx);
        String predLocalName = predString.substring(predSplitIdx);
        try {
            if (!this.headerWritten) {
                this.writeHeader();
            }
            if (!subj.equals((Object)this.lastWrittenSubject)) {
                this.flushPendingStatements();
                this.writeNewLine();
                this.writeStartOfStartTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
                if (subj instanceof BNode) {
                    BNode bNode = (BNode)subj;
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID", this.getValidNodeId(bNode));
                } else {
                    IRI uri = (IRI)subj;
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about", uri.toString());
                }
                this.writeEndOfStartTag();
                this.writeNewLine();
                this.lastWrittenSubject = subj;
            }
            this.writeIndent();
            this.writeStartOfStartTag(predNamespace, predLocalName);
            if (obj instanceof Resource) {
                Resource objRes = (Resource)obj;
                if (objRes instanceof BNode) {
                    BNode bNode = (BNode)objRes;
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID", this.getValidNodeId(bNode));
                } else {
                    IRI uri = (IRI)objRes;
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", uri.toString());
                }
                this.writeEndOfEmptyTag();
            } else if (obj instanceof Literal) {
                Literal objLit = (Literal)obj;
                boolean isXMLLiteral = false;
                if (Literal.isLanguageLiteral((Literal)objLit)) {
                    this.writeAttribute("xml:lang", (String)objLit.lang().get());
                } else {
                    IRI datatype = objLit.datatypeIRI();
                    isXMLLiteral = datatype.equals((Object)RDF.XMLLITERAL);
                    if (isXMLLiteral) {
                        this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType", "Literal");
                    } else {
                        this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype", datatype.toString());
                    }
                }
                this.writeEndOfStartTag();
                if (isXMLLiteral) {
                    this.mWriter.write(objLit.label());
                } else {
                    this.writeCharacterData(objLit.label());
                }
                this.writeEndTag(predNamespace, predLocalName);
            }
            this.writeNewLine();
        }
        catch (IOException e) {
            throw new WritingFailed((Throwable)e);
        }
    }

    public void comment(@Nonnull String comment) throws WritingFailed {
        try {
            if (!this.headerWritten) {
                this.writeHeader();
            }
            this.flushPendingStatements();
            this.mWriter.write("<!-- ");
            this.mWriter.write(comment);
            this.mWriter.write(" -->");
            this.writeNewLine();
        }
        catch (IOException e) {
            throw new WritingFailed((Throwable)e);
        }
    }

    protected void flushPendingStatements() throws IOException, WritingFailed {
        if (this.lastWrittenSubject != null) {
            this.writeEndTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
            this.writeNewLine();
            this.lastWrittenSubject = null;
        }
    }

    protected void writeStartOfStartTag(@Nonnull String theNamespace, @Nonnull String theLocalName) throws IOException {
        if (theNamespace.equals(this.defaultNamespace)) {
            this.mWriter.write("<");
            this.mWriter.write(theLocalName);
        } else {
            boolean aNoPrefix;
            String prefix = this.namespaceTable.get(theNamespace);
            boolean bl = aNoPrefix = prefix == null || !this.mOptions.is(RDFXMLWriterOptions.INCLUDE_ROOT_RDF_TAG);
            if (aNoPrefix) {
                this.mWriter.write(60);
                this.mWriter.write(theLocalName);
                this.mWriter.write(" xmlns=\"");
                this.mWriter.write(XMLUtil.escapeDoubleQuotedAttValue(theNamespace));
                this.mWriter.write("\"");
            } else {
                this.mWriter.write(60);
                this.mWriter.write(prefix);
                this.mWriter.write(58);
                this.mWriter.write(theLocalName);
            }
        }
    }

    protected void writeAttribute(String attName, String value) throws IOException {
        this.mWriter.write(32);
        this.mWriter.write(attName);
        this.mWriter.write("=\"");
        this.mWriter.write(XMLUtil.escapeDoubleQuotedAttValue(value));
        this.mWriter.write(34);
    }

    protected void writeAttribute(String namespace, String attName, String value) throws IOException, WritingFailed {
        String prefix = this.namespaceTable.get(namespace);
        if (prefix == null) {
            throw new WritingFailed("No prefix has been declared for the namespace used in this attribute: " + namespace);
        }
        this.mWriter.write(32);
        this.mWriter.write(prefix);
        this.mWriter.write(58);
        this.mWriter.write(attName);
        this.mWriter.write("=\"");
        this.mWriter.write(XMLUtil.escapeDoubleQuotedAttValue(value));
        this.mWriter.write(34);
    }

    protected void writeEndOfStartTag() throws IOException {
        this.mWriter.write(62);
    }

    protected void writeEndOfEmptyTag() throws IOException {
        this.mWriter.write("/>");
    }

    protected void writeEndTag(String namespace, String localName) throws IOException {
        if (namespace.equals(this.defaultNamespace)) {
            this.mWriter.write("</");
            this.mWriter.write(localName);
            this.mWriter.write(62);
        } else {
            this.mWriter.write("</");
            String prefix = this.namespaceTable.get(namespace);
            if (prefix != null) {
                this.mWriter.write(prefix);
                this.mWriter.write(58);
            }
            this.mWriter.write(localName);
            this.mWriter.write(62);
        }
    }

    protected void writeCharacterData(String chars) throws IOException {
        this.mWriter.write(XMLUtil.escapeCharacterData(chars));
    }

    protected void writeIndent() throws IOException {
        this.mWriter.write(9);
    }

    protected void writeNewLine() throws IOException {
        this.mWriter.write(System.lineSeparator());
    }

    protected String getValidNodeId(@Nonnull BNode theBNode) throws IOException {
        String validNodeId = theBNode.id();
        if (!XMLUtil.isNCName(validNodeId)) {
            StringBuilder builder = new StringBuilder();
            if (validNodeId.isEmpty()) {
                if (this.mOptions.is(ParserOptions.PRESERVE_BNODE_IDS)) {
                    throw new IOException("Cannot consistently write blank nodes with empty internal identifiers");
                }
                builder.append("genid-hash-");
                builder.append(Integer.toHexString(System.identityHashCode(theBNode)));
            } else {
                if (!XMLUtil.isNCNameStartChar(validNodeId.charAt(0))) {
                    builder.append("genid-start-");
                    builder.append(Integer.toHexString(validNodeId.charAt(0)));
                } else {
                    builder.append(validNodeId.charAt(0));
                }
                for (int i = 1; i < validNodeId.length(); ++i) {
                    if (XMLUtil.isNCNameChar(validNodeId.charAt(i))) {
                        builder.append(validNodeId.charAt(i));
                        continue;
                    }
                    builder.append(Integer.toHexString(validNodeId.charAt(i)));
                }
            }
            validNodeId = builder.toString();
        }
        return validNodeId;
    }

    @Nonnull
    public RDFFormat format() {
        return RDFFormats.RDFXML;
    }

    public static final class RDFXMLWriterFactory
    implements RDFWriterFactory {
        @Nonnull
        public RDFFormat format() {
            return RDFFormats.RDFXML;
        }

        @Nonnull
        public RDFWriter create(@Nonnull OutputStream theStream, @Nonnull Options theOptions) {
            return new RDFXMLWriter(theStream, theOptions);
        }
    }
}

