/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.rdfxml;

import com.complexible.common.base.Options;
import com.google.common.collect.Iterables;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.WritingFailed;
import com.stardog.stark.io.rdfxml.RDFXMLWriter;
import com.stardog.stark.vocabs.RDF;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class RDFXMLPrettyWriter
extends RDFXMLWriter
implements Closeable,
Flushable {
    private final Deque<Node> nodeStack = new ArrayDeque<Node>();
    private final Deque<IRI> predicateStack = new ArrayDeque<IRI>();

    public RDFXMLPrettyWriter(OutputStream theStream, Options theOptions) {
        super(theStream, theOptions);
    }

    @Override
    protected void writeHeader() throws IOException {
        this.setNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        super.writeHeader();
    }

    @Override
    public void flush() throws IOException {
        if (this.writingStarted) {
            if (!this.headerWritten) {
                this.writeHeader();
            }
            try {
                this.flushPendingStatements();
            }
            catch (WritingFailed e) {
                if (e.getCause() != null && e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e);
            }
            this.mWriter.flush();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.writingStarted) {
                this.end();
            }
        }
        catch (WritingFailed e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
        finally {
            this.nodeStack.clear();
            this.predicateStack.clear();
            this.mWriter.close();
        }
    }

    @Override
    protected void flushPendingStatements() throws IOException, WritingFailed {
        if (!this.nodeStack.isEmpty()) {
            this.popStacks(null);
        }
    }

    private void popStacks(@Nullable Resource theNewSubj) throws IOException, WritingFailed {
        Node nextElement;
        Iterator<Node> aIter = this.nodeStack.descendingIterator();
        for (int i = 0; i < this.nodeStack.size() - 1; ++i) {
            Node node = aIter.next();
            if (node.isWritten()) continue;
            if (i > 0) {
                this.writeIndents(i * 2 - 1);
                int aPosition = this.predicateStack.size() - 1 - (i - 1);
                IRI predicate = (IRI)Iterables.get(this.predicateStack, (int)aPosition);
                this.writeStartTag(predicate.namespace(), predicate.localName());
                this.writeNewLine();
            }
            this.writeIndents(i * 2);
            this.writeNodeStartTag(node);
            node.setIsWritten(true);
        }
        Node topNode = this.nodeStack.pop();
        if (this.predicateStack.isEmpty()) {
            this.writeIndents(this.nodeStack.size() * 2);
            this.writeNodeEmptyTag(topNode);
            this.writeNewLine();
        } else {
            IRI topPredicate = this.predicateStack.pop();
            if (!topNode.hasType()) {
                this.writeIndents(this.nodeStack.size() * 2 - 1);
                this.writeAbbreviatedPredicate(topPredicate, topNode.getValue());
            } else {
                this.writeIndents(this.nodeStack.size() * 2 - 1);
                this.writeStartTag(topPredicate.namespace(), topPredicate.localName());
                this.writeNewLine();
                this.writeIndents(this.nodeStack.size() * 2);
                this.writeNodeEmptyTag(topNode);
                this.writeNewLine();
                this.writeIndents(this.nodeStack.size() * 2 - 1);
                this.writeEndTag(topPredicate.namespace(), topPredicate.localName());
                this.writeNewLine();
            }
        }
        while (!this.nodeStack.isEmpty() && !(nextElement = this.nodeStack.peek()).getValue().equals((Object)theNewSubj)) {
            this.nodeStack.pop();
            this.writeIndents(this.predicateStack.size() + this.nodeStack.size());
            this.writeNodeEndTag(nextElement);
            if (this.predicateStack.size() <= 0) continue;
            IRI nextPredicate = this.predicateStack.pop();
            this.writeIndents(this.predicateStack.size() + this.nodeStack.size());
            this.writeEndTag(nextPredicate.namespace(), nextPredicate.localName());
            this.writeNewLine();
        }
    }

    @Override
    public void handle(@Nonnull Statement theStmt) throws WritingFailed {
        if (!this.writingStarted) {
            throw new WritingFailed("Document writing has not yet been started");
        }
        Resource subj = theStmt.subject();
        IRI pred = theStmt.predicate();
        Value obj = theStmt.object();
        try {
            if (!this.headerWritten) {
                this.writeHeader();
            }
            if (!this.nodeStack.isEmpty() && !subj.equals((Object)this.nodeStack.peek().getValue())) {
                this.popStacks(subj);
            }
            if (this.nodeStack.isEmpty()) {
                this.nodeStack.push(new Node((Value)subj));
            }
            Node topSubject = this.nodeStack.peek();
            if (pred.equals((Object)RDF.TYPE) && obj instanceof IRI && !topSubject.hasType() && !topSubject.isWritten()) {
                topSubject.setType((IRI)obj);
            } else {
                if (!this.nodeStack.isEmpty() && pred.equals((Object)this.nodeStack.peek().nextLi())) {
                    pred = RDF.LI;
                    this.nodeStack.peek().incrementNextLi();
                }
                this.predicateStack.push(pred);
                this.nodeStack.push(new Node(obj));
            }
        }
        catch (IOException e) {
            throw new WritingFailed((Throwable)e);
        }
    }

    private void writeNodeStartOfStartTag(@Nonnull Node theNode) throws IOException, WritingFailed {
        Value value = theNode.getValue();
        if (theNode.hasType()) {
            if (!"".equals(theNode.getType().localName())) {
                this.writeStartOfStartTag(theNode.getType().namespace(), theNode.getType().localName());
            } else {
                this.writeStartOfStartTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
                this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type", theNode.getType().toString());
            }
        } else {
            this.writeStartOfStartTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
        }
        if (value instanceof IRI) {
            IRI uri = (IRI)value;
            this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about", uri.toString());
        } else {
            BNode bNode = (BNode)value;
            this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID", this.getValidNodeId(bNode));
        }
    }

    private void writeNodeStartTag(@Nonnull Node theNode) throws IOException, WritingFailed {
        this.writeNodeStartOfStartTag(theNode);
        this.writeEndOfStartTag();
        this.writeNewLine();
    }

    private void writeNodeEndTag(@Nonnull Node theNode) throws IOException {
        if (theNode.getType() != null) {
            this.writeEndTag(theNode.getType().namespace(), theNode.getType().localName());
        } else {
            this.writeEndTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
        }
        this.writeNewLine();
    }

    private void writeNodeEmptyTag(@Nonnull Node theNode) throws IOException, WritingFailed {
        this.writeNodeStartOfStartTag(theNode);
        this.writeEndOfEmptyTag();
    }

    private void writeAbbreviatedPredicate(@Nonnull IRI thePred, @Nonnull Value theObj) throws IOException, WritingFailed {
        this.writeStartOfStartTag(thePred.namespace(), thePred.localName());
        if (theObj instanceof Resource) {
            Resource objRes = (Resource)theObj;
            if (objRes instanceof IRI) {
                IRI uri = (IRI)objRes;
                this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", uri.toString());
            } else {
                BNode bNode = (BNode)objRes;
                this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID", this.getValidNodeId(bNode));
            }
            this.writeEndOfEmptyTag();
        } else if (theObj instanceof Literal) {
            Literal objLit = (Literal)theObj;
            IRI datatype = objLit.datatypeIRI();
            boolean isXmlLiteral = datatype.equals((Object)RDF.XMLLITERAL);
            if (Literal.isLanguageLiteral((Literal)objLit)) {
                this.writeAttribute("xml:lang", (String)objLit.lang().get());
            } else if (isXmlLiteral) {
                this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType", "Literal");
            } else {
                this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype", datatype.toString());
            }
            this.writeEndOfStartTag();
            if (isXmlLiteral) {
                this.mWriter.write(objLit.label());
            } else {
                this.writeCharacterData(objLit.label());
            }
            this.writeEndTag(thePred.namespace(), thePred.localName());
        }
        this.writeNewLine();
    }

    protected void writeStartTag(String namespace, String localName) throws IOException {
        this.writeStartOfStartTag(namespace, localName);
        this.writeEndOfStartTag();
    }

    protected void writeIndents(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.writeIndent();
        }
    }

    private static class Node {
        private int nextLiIndex = 1;
        private Resource nextLi;
        private Value value;
        private IRI type = null;
        private boolean isWritten = false;

        public Node(Value value) {
            this.value = value;
        }

        Resource nextLi() {
            if (this.nextLi == null) {
                this.nextLi = Values.iri((String)("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + this.nextLiIndex));
            }
            return this.nextLi;
        }

        public void incrementNextLi() {
            ++this.nextLiIndex;
            this.nextLi = null;
        }

        public Value getValue() {
            return this.value;
        }

        public void setType(IRI type) {
            this.type = type;
        }

        public IRI getType() {
            return this.type;
        }

        public boolean hasType() {
            return this.type != null;
        }

        public void setIsWritten(boolean isWritten) {
            this.isWritten = isWritten;
        }

        public boolean isWritten() {
            return this.isWritten;
        }
    }
}

