/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.rdfxml;

import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.InvalidRDF;
import com.stardog.stark.io.ParserContext;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.rdfxml.Att;
import com.stardog.stark.io.rdfxml.Atts;
import com.stardog.stark.io.rdfxml.RDFXMLParser;
import com.stardog.stark.io.rdfxml.RDFXMLParserOptions;
import com.stardog.stark.io.rdfxml.XMLUtil;
import com.stardog.stark.vocabs.RDF;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Locator;

final class RDFXMLParserContext
extends ParserContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(RDFXMLParser.class);
    private final Deque<Object> elementStack = new ArrayDeque<Object>();
    private final Set<IRI> usedIDs = new HashSet<IRI>();
    @Nullable
    private String xmlLang;
    @Nullable
    private Locator mLocator;
    private Runnable parseLiteralMode = () -> {};

    public RDFXMLParserContext(@Nonnull RDFHandler theHandler, @Nonnull Options theOptions) {
        super(theHandler, theOptions);
    }

    public void error(String theMsg, ParserContext.ParseError theError) {
        if (this.mLocator != null) {
            throw new InvalidRDF(theMsg, (long)this.mLocator.getLineNumber(), (long)this.mLocator.getColumnNumber());
        }
        super.error(theMsg, theError);
    }

    public void resetStatement() {
        super.resetStatement();
        this.xmlLang = null;
    }

    public BNode createBNode(@Nonnull String theNodeID) {
        if (this.is(RDFXMLParserOptions.FAIL_ON_INVALID_NCNAME) && !XMLUtil.isNCName(theNodeID)) {
            throw this.error("Not an XML Name: " + theNodeID);
        }
        return super.createBNode(theNodeID);
    }

    void xmlLang(@Nonnull String theLang) {
        this.xmlLang = "".equals(theLang) ? null : theLang;
    }

    void locator(@Nullable Locator theLocator) {
        this.mLocator = theLocator;
    }

    void parseLiteralMode(Runnable theRunnable) {
        this.parseLiteralMode = theRunnable;
    }

    void startElement(String namespaceURI, String localName, String qName, Atts atts) {
        if (this.topIsProperty()) {
            this.processNodeElt(namespaceURI, localName, qName, atts, false);
        } else {
            this.processPropertyElt(namespaceURI, localName, qName, atts, false);
        }
    }

    void endElement(String namespaceURI, String localName, String qName) {
        Object topElement = this.peekStack(0);
        if (topElement instanceof NodeElement) {
            if (((NodeElement)topElement).isVolatile()) {
                this.elementStack.pop();
            }
        } else {
            PropertyElement predicate = (PropertyElement)topElement;
            if (predicate.parseCollection()) {
                Resource lastListResource = predicate.getLastListResource();
                if (lastListResource == null) {
                    NodeElement subject = (NodeElement)this.peekStack(1);
                    this.handle(Values.statement((Resource)subject.getResource(), (IRI)predicate.getURI(), (Value)RDF.NIL));
                    this.handleReification((Value)RDF.NIL);
                } else {
                    this.handle(Values.statement((Resource)lastListResource, (IRI)RDF.REST, (Value)RDF.NIL));
                }
            }
        }
        this.elementStack.pop();
    }

    void emptyElement(String namespaceURI, String localName, String qName, Atts atts) {
        if (this.topIsProperty()) {
            this.processNodeElt(namespaceURI, localName, qName, atts, true);
        } else {
            this.processPropertyElt(namespaceURI, localName, qName, atts, true);
        }
    }

    void text(String text) {
        if (!this.topIsProperty()) {
            this.warnOrError("unexpected literal", RDFXMLParserOptions.FAIL_ON_NON_STANDARD_ATTRIBUTES);
            return;
        }
        PropertyElement propEl = (PropertyElement)this.peekStack(0);
        IRI datatype = propEl.getDatatype();
        Literal lit = this.createLiteral(text, this.xmlLang, datatype);
        NodeElement subject = (NodeElement)this.peekStack(1);
        PropertyElement predicate = (PropertyElement)this.peekStack(0);
        this.handle(Values.statement((Resource)subject.getResource(), (IRI)predicate.getURI(), (Value)lit));
        this.handleReification((Value)lit);
    }

    private boolean topIsProperty() {
        return this.elementStack.isEmpty() || this.peekStack(0) instanceof PropertyElement;
    }

    private Object peekStack(int distFromTop) {
        return this.elementStack.stream().skip(distFromTop).limit(1L).findFirst().orElse(null);
    }

    void warnOrError(String theMessage, Option<Boolean> theSetting) {
        if (this.is(theSetting)) {
            throw this.error(theMessage);
        }
        LOGGER.warn(theMessage);
    }

    private void checkNoMoreAtts(Atts atts) {
        if (atts.size() > 0) {
            Iterator<Att> iter = atts.iterator();
            while (iter.hasNext()) {
                Att att = iter.next();
                this.warnOrError("unexpected attribute '" + att.getQName() + "'", RDFXMLParserOptions.FAIL_ON_NON_STANDARD_ATTRIBUTES);
                iter.remove();
            }
        }
    }

    private void checkNodeEltName(String namespaceURI, String localName, String qName) {
        if (!(!"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(namespaceURI) || localName.equals("Description") || localName.equals("Seq") || localName.equals("Bag") || localName.equals("Alt") || localName.equals("Statement") || localName.equals("Property") || localName.equals("List") || localName.equals("subject") || localName.equals("predicate") || localName.equals("object") || localName.equals("type") || localName.equals("value") || localName.equals("first") || localName.equals("rest") || localName.equals("nil") || localName.startsWith("_"))) {
            if (localName.equals("li") || localName.equals("RDF") || localName.equals("ID") || localName.equals("about") || localName.equals("parseType") || localName.equals("resource") || localName.equals("nodeID") || localName.equals("datatype")) {
                this.warnOrError("<" + qName + "> not allowed as node element", RDFXMLParserOptions.FAIL_ON_NON_STANDARD_ATTRIBUTES);
            } else if (localName.equals("bagID") || localName.equals("aboutEach") || localName.equals("aboutEachPrefix")) {
                this.warnOrError(qName + " is no longer a valid RDF name", RDFXMLParserOptions.FAIL_ON_NON_STANDARD_ATTRIBUTES);
            } else {
                LOGGER.warn("unknown rdf element <" + qName + ">");
            }
        }
    }

    private void checkRDFAtts(Atts atts) {
        Iterator<Att> iter = atts.iterator();
        while (iter.hasNext()) {
            String localName;
            Att att = iter.next();
            if (!"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(att.getNamespace()) || (localName = att.getLocalName()).equals("Seq") || localName.equals("Bag") || localName.equals("Alt") || localName.equals("Statement") || localName.equals("Property") || localName.equals("List") || localName.equals("subject") || localName.equals("predicate") || localName.equals("object") || localName.equals("type") || localName.equals("value") || localName.equals("first") || localName.equals("rest") || localName.equals("nil") || localName.startsWith("_")) continue;
            if (localName.equals("Description") || localName.equals("li") || localName.equals("RDF") || localName.equals("ID") || localName.equals("about") || localName.equals("parseType") || localName.equals("resource") || localName.equals("nodeID") || localName.equals("datatype")) {
                this.warnOrError("'" + att.getQName() + "' not allowed as attribute name", RDFXMLParserOptions.FAIL_ON_NON_STANDARD_ATTRIBUTES);
                iter.remove();
                continue;
            }
            if (localName.equals("bagID") || localName.equals("aboutEach") || localName.equals("aboutEachPrefix")) {
                this.warnOrError(att.getQName() + " is no longer a valid RDF name", RDFXMLParserOptions.FAIL_ON_NON_STANDARD_ATTRIBUTES);
                continue;
            }
            LOGGER.warn("unknown rdf attribute '" + att.getQName() + "'");
        }
    }

    private void checkPropertyEltName(String namespaceURI, String localName, String qName) {
        if (!(!"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(namespaceURI) || localName.equals("li") || localName.equals("Seq") || localName.equals("Bag") || localName.equals("Alt") || localName.equals("Statement") || localName.equals("Property") || localName.equals("List") || localName.equals("subject") || localName.equals("predicate") || localName.equals("object") || localName.equals("type") || localName.equals("value") || localName.equals("first") || localName.equals("rest") || localName.equals("nil") || localName.startsWith("_"))) {
            if (localName.equals("Description") || localName.equals("RDF") || localName.equals("ID") || localName.equals("about") || localName.equals("parseType") || localName.equals("resource") || localName.equals("nodeID") || localName.equals("datatype")) {
                this.warnOrError("<" + qName + "> not allowed as property element", RDFXMLParserOptions.FAIL_ON_NON_STANDARD_ATTRIBUTES);
            } else if (localName.equals("bagID") || localName.equals("aboutEach") || localName.equals("aboutEachPrefix")) {
                this.warnOrError(qName + " is no longer a valid RDF name", RDFXMLParserOptions.FAIL_ON_NON_STANDARD_ATTRIBUTES);
            } else {
                LOGGER.warn("unknown rdf element <" + qName + ">");
            }
        }
    }

    private Resource getNodeResource(Atts atts) {
        Att id = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "ID");
        Att about = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about");
        Att nodeID = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID");
        if (this.is(RDFXMLParserOptions.FAIL_ON_NON_STANDARD_ATTRIBUTES)) {
            int definedAttsCount = 0;
            if (id != null) {
                ++definedAttsCount;
            }
            if (about != null) {
                ++definedAttsCount;
            }
            if (nodeID != null) {
                ++definedAttsCount;
            }
            if (definedAttsCount > 1) {
                throw this.error("Only one of the attributes rdf:ID, rdf:about or rdf:nodeID can be used here");
            }
        }
        Object result = null;
        result = id != null ? this.buildURIFromID(id.getValue()) : (about != null ? this.resolveURI(about.getValue()) : (nodeID != null ? this.createBNode(nodeID.getValue()) : this.createBNode()));
        return result;
    }

    private IRI buildResourceFromLocalName(String localName) {
        return this.resolveURI("#" + localName);
    }

    private IRI buildURIFromID(String id) {
        if (this.is(RDFXMLParserOptions.FAIL_ON_INVALID_NCNAME) && !XMLUtil.isNCName(id)) {
            throw this.error("Not an XML Name: " + id);
        }
        IRI uri = this.resolveURI("#" + id);
        if (this.is(RDFXMLParserOptions.FAIL_ON_DUPLICATE_RDF_ID) && !this.usedIDs.add(uri)) {
            throw this.error("ID '" + id + "' has already been defined");
        }
        return uri;
    }

    private void handleReification(Value value) {
        PropertyElement predicate = (PropertyElement)this.peekStack(0);
        if (predicate.isReified()) {
            NodeElement subject = (NodeElement)this.peekStack(1);
            IRI reifRes = predicate.getReificationURI();
            this.reifyStatement((Resource)reifRes, subject.getResource(), predicate.getURI(), value);
        }
    }

    private void reifyStatement(Resource reifNode, Resource subj, IRI pred, Value obj) {
        this.handle(Values.statement((Resource)reifNode, (IRI)RDF.TYPE, (Value)RDF.STATEMENT));
        this.handle(Values.statement((Resource)reifNode, (IRI)RDF.SUBJECT, (Value)subj));
        this.handle(Values.statement((Resource)reifNode, (IRI)RDF.PREDICATE, (Value)pred));
        this.handle(Values.statement((Resource)reifNode, (IRI)RDF.OBJECT, (Value)obj));
    }

    private void processNodeElt(String namespaceURI, String localName, String qName, Atts atts, boolean isEmptyElt) {
        Att type;
        if (this.is(RDFXMLParserOptions.FAIL_ON_NON_STANDARD_ATTRIBUTES)) {
            this.checkNodeEltName(namespaceURI, localName, qName);
        }
        Resource nodeResource = this.getNodeResource(atts);
        NodeElement nodeElement = new NodeElement(nodeResource);
        if (!this.elementStack.isEmpty()) {
            NodeElement subject = (NodeElement)this.peekStack(1);
            PropertyElement predicate = (PropertyElement)this.peekStack(0);
            if (predicate.parseCollection()) {
                Resource lastListRes = predicate.getLastListResource();
                BNode newListRes = this.createBNode();
                if (lastListRes == null) {
                    this.handle(Values.statement((Resource)subject.getResource(), (IRI)predicate.getURI(), (Value)newListRes));
                    this.handleReification((Value)newListRes);
                } else {
                    this.handle(Values.statement((Resource)lastListRes, (IRI)RDF.REST, (Value)newListRes));
                }
                this.handle(Values.statement((Resource)newListRes, (IRI)RDF.FIRST, (Value)nodeResource));
                predicate.setLastListResource((Resource)newListRes);
            } else {
                this.handle(Values.statement((Resource)subject.getResource(), (IRI)predicate.getURI(), (Value)nodeResource));
                this.handleReification((Value)nodeResource);
            }
        }
        if (!localName.equals("Description") || !namespaceURI.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
            IRI className = null;
            className = "".equals(namespaceURI) ? this.buildResourceFromLocalName(localName) : Values.iri((String)(namespaceURI + localName));
            this.handle(Values.statement((Resource)nodeResource, (IRI)RDF.TYPE, (Value)className));
        }
        if ((type = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type")) != null) {
            IRI className = this.resolveURI(type.getValue());
            this.handle(Values.statement((Resource)nodeResource, (IRI)RDF.TYPE, (Value)className));
        }
        if (this.is(RDFXMLParserOptions.FAIL_ON_NON_STANDARD_ATTRIBUTES)) {
            this.checkRDFAtts(atts);
        }
        this.processSubjectAtts(nodeElement, atts);
        if (!isEmptyElt) {
            this.elementStack.push(nodeElement);
        }
    }

    private void processSubjectAtts(NodeElement nodeElt, Atts atts) {
        Resource subject = nodeElt.getResource();
        Iterator<Att> iter = atts.iterator();
        while (iter.hasNext()) {
            Att att = iter.next();
            IRI predicate = Values.iri((String)att.getURI());
            Literal lit = this.createLiteral(att.getValue(), this.xmlLang, null);
            this.handle(Values.statement((Resource)subject, (IRI)predicate, (Value)lit));
        }
    }

    private void processPropertyElt(String namespaceURI, String localName, String qName, Atts atts, boolean isEmptyElt) {
        Att parseType;
        if (this.is(RDFXMLParserOptions.FAIL_ON_NON_STANDARD_ATTRIBUTES)) {
            this.checkPropertyEltName(namespaceURI, localName, qName);
        }
        IRI propURI = null;
        if (namespaceURI.equals("")) {
            this.warnOrError("unqualified property element <" + qName + "> not allowed", RDFXMLParserOptions.FAIL_ON_INVALID_QNAME);
            propURI = this.buildResourceFromLocalName(localName);
        } else {
            propURI = Values.iri((String)(namespaceURI + localName));
        }
        if (propURI.equals((Object)RDF.LI)) {
            NodeElement subject = (NodeElement)this.peekStack(0);
            propURI = Values.iri((String)("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + subject.getNextLiCounter()));
        }
        PropertyElement predicate = new PropertyElement(propURI);
        this.elementStack.push(predicate);
        Att id = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "ID");
        if (id != null) {
            IRI reifURI = this.buildURIFromID(id.getValue());
            predicate.setReificationURI(reifURI);
        }
        if ((parseType = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType")) != null) {
            String parseTypeValue;
            if (this.is(RDFXMLParserOptions.FAIL_ON_NON_STANDARD_ATTRIBUTES)) {
                this.checkNoMoreAtts(atts);
            }
            if ((parseTypeValue = parseType.getValue()).equals("Resource")) {
                BNode objectResource = this.createBNode();
                NodeElement subject = (NodeElement)this.peekStack(1);
                this.handle(Values.statement((Resource)subject.getResource(), (IRI)propURI, (Value)objectResource));
                if (isEmptyElt) {
                    this.handleReification((Value)objectResource);
                } else {
                    NodeElement object = new NodeElement((Resource)objectResource);
                    object.setIsVolatile(true);
                    this.elementStack.push(object);
                }
            } else if (parseTypeValue.equals("Collection")) {
                if (isEmptyElt) {
                    NodeElement subject = (NodeElement)this.peekStack(1);
                    this.handle(Values.statement((Resource)subject.getResource(), (IRI)propURI, (Value)RDF.NIL));
                    this.handleReification((Value)RDF.NIL);
                } else {
                    predicate.setParseCollection(true);
                }
            } else {
                if (!parseTypeValue.equals("Literal")) {
                    LOGGER.warn("unknown parseType: " + parseType.getValue());
                }
                if (isEmptyElt) {
                    NodeElement subject = (NodeElement)this.peekStack(1);
                    Literal lit = this.createLiteral("", null, RDF.XMLLITERAL);
                    this.handle(Values.statement((Resource)subject.getResource(), (IRI)propURI, (Value)lit));
                    this.handleReification((Value)lit);
                } else {
                    predicate.setDatatype(RDF.XMLLITERAL);
                    this.parseLiteralMode.run();
                }
            }
        } else if (isEmptyElt) {
            Att datatype = atts.getAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype");
            if (atts.size() == 0 || atts.size() == 1 && datatype != null) {
                NodeElement subject = (NodeElement)this.peekStack(1);
                IRI dtURI = null;
                if (datatype != null) {
                    dtURI = Values.iri((String)datatype.getValue());
                }
                Literal lit = this.createLiteral("", this.xmlLang, dtURI);
                this.handle(Values.statement((Resource)subject.getResource(), (IRI)propURI, (Value)lit));
                this.handleReification((Value)lit);
            } else {
                Resource resourceRes = this.getPropertyResource(atts);
                if (this.is(RDFXMLParserOptions.FAIL_ON_NON_STANDARD_ATTRIBUTES)) {
                    this.checkRDFAtts(atts);
                }
                NodeElement resourceElt = new NodeElement(resourceRes);
                NodeElement subject = (NodeElement)this.peekStack(1);
                this.handle(Values.statement((Resource)subject.getResource(), (IRI)propURI, (Value)resourceRes));
                this.handleReification((Value)resourceRes);
                Att type = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type");
                if (type != null) {
                    IRI className = this.resolveURI(type.getValue());
                    this.handle(Values.statement((Resource)resourceRes, (IRI)RDF.TYPE, (Value)className));
                }
                this.processSubjectAtts(resourceElt, atts);
            }
        } else {
            Att datatype = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype");
            if (datatype != null) {
                IRI dtURI = this.resolveURI(datatype.getValue());
                predicate.setDatatype(dtURI);
            }
            if (this.is(RDFXMLParserOptions.FAIL_ON_NON_STANDARD_ATTRIBUTES)) {
                this.checkNoMoreAtts(atts);
            }
        }
        if (isEmptyElt) {
            this.elementStack.pop();
        }
    }

    private Resource getPropertyResource(Atts atts) {
        Att resource = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
        Att nodeID = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID");
        if (this.is(RDFXMLParserOptions.FAIL_ON_NON_STANDARD_ATTRIBUTES)) {
            int definedAttsCount = 0;
            if (resource != null) {
                ++definedAttsCount;
            }
            if (nodeID != null) {
                ++definedAttsCount;
            }
            if (definedAttsCount > 1) {
                throw this.error("Only one of the attributes rdf:resource or rdf:nodeID can be used here");
            }
        }
        Object result = null;
        result = resource != null ? this.resolveURI(resource.getValue()) : (nodeID != null ? this.createBNode(nodeID.getValue()) : this.createBNode());
        return result;
    }

    static class NodeElement {
        private Resource resource;
        private boolean isVolatile = false;
        private int liCounter = 1;

        public NodeElement(Resource resource) {
            this.resource = resource;
        }

        public Resource getResource() {
            return this.resource;
        }

        public void setIsVolatile(boolean isVolatile) {
            this.isVolatile = isVolatile;
        }

        public boolean isVolatile() {
            return this.isVolatile;
        }

        public int getNextLiCounter() {
            return this.liCounter++;
        }
    }

    static class PropertyElement {
        private IRI uri;
        private IRI reificationURI;
        private IRI datatype;
        private boolean parseCollection = false;
        private Resource lastListResource;

        public PropertyElement(IRI uri) {
            this.uri = uri;
        }

        public IRI getURI() {
            return this.uri;
        }

        public boolean isReified() {
            return this.reificationURI != null;
        }

        public void setReificationURI(IRI reifURI) {
            this.reificationURI = reifURI;
        }

        public IRI getReificationURI() {
            return this.reificationURI;
        }

        public void setDatatype(IRI datatype) {
            this.datatype = datatype;
        }

        public IRI getDatatype() {
            return this.datatype;
        }

        public boolean parseCollection() {
            return this.parseCollection;
        }

        public void setParseCollection(boolean parseCollection) {
            this.parseCollection = parseCollection;
        }

        public Resource getLastListResource() {
            return this.lastListResource;
        }

        public void setLastListResource(Resource resource) {
            this.lastListResource = resource;
        }
    }
}

