/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.rdfxml;

import com.complexible.common.base.Options;
import com.complexible.common.io.XMLReaders;
import com.google.common.base.Throwables;
import com.stardog.stark.io.InvalidRDF;
import com.stardog.stark.io.ParserOptions;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFHandlerException;
import com.stardog.stark.io.RDFParser;
import com.stardog.stark.io.rdfxml.RDFXMLParserContext;
import com.stardog.stark.io.rdfxml.RDFXMLParserOptions;
import com.stardog.stark.io.rdfxml.SAXFilter;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.apache.commons.io.input.BOMInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class RDFXMLParser
implements RDFParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(RDFXMLParser.class);

    @Nonnull
    public RDFFormat format() {
        return RDFFormats.RDFXML;
    }

    public void parse(@Nonnull InputStream theStream, @Nonnull RDFHandler theHandler, @Nonnull Options theOptions) throws IOException {
        InputSource aInput = new InputSource((InputStream)new BOMInputStream(theStream, false));
        aInput.setSystemId((String)theOptions.get(ParserOptions.BASE_IRI));
        RDFXMLParserContext aContext = new RDFXMLParserContext(theHandler, theOptions);
        SAXFilter aFilter = new SAXFilter(aContext);
        aFilter.setDocumentURI(aInput.getSystemId());
        try {
            boolean isSecure = theOptions.is(ParserOptions.SECURE_PROCESSING);
            XMLReader aReader = XMLReaders.createXMLReader((boolean)isSecure);
            aReader.setContentHandler(aFilter);
            aReader.setErrorHandler(new SAXErrorHandler(aContext));
            theHandler.start();
            aReader.parse(aInput);
            theHandler.end();
        }
        catch (SAXParseException e) {
            Exception ex = e.getException();
            if (ex == null) {
                throw new InvalidRDF(e.getMessage(), (long)e.getLineNumber(), (long)e.getColumnNumber());
            }
            throw new InvalidRDF(ex.getMessage(), (long)e.getLineNumber(), (long)e.getColumnNumber());
        }
        catch (SAXException e) {
            Exception ex = e.getException();
            if (ex != null) {
                Throwables.throwIfInstanceOf((Throwable)ex, InvalidRDF.class);
                Throwables.throwIfInstanceOf((Throwable)ex, RDFHandlerException.class);
            }
            throw aContext.error(e.getMessage());
        }
    }

    private static final class SAXErrorHandler
    implements ErrorHandler {
        private final RDFXMLParserContext mContext;

        public SAXErrorHandler(RDFXMLParserContext theContext) {
            this.mContext = theContext;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            LOGGER.warn("ignoring SAXParseException exception", (Throwable)exception);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            if (this.mContext.is(RDFXMLParserOptions.FAIL_ON_SAX_NON_FATAL_ERRORS)) {
                throw this.mContext.error(exception.toString());
            }
            this.warning(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw this.mContext.error(exception.toString());
        }
    }
}

