/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.admin.pack;

import com.complexible.stardog.api.admin.pack.ClusterNodeRole;
import com.complexible.stardog.api.admin.pack.ClusterNodeType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Map;
import java.util.UUID;

public class ClusterNodeStatus {
    private final String mNodeAddress;
    private final Map<String, Object> mMetadata;
    private final Map<String, UUID> mDatabaseTxns;
    private final Map<String, UUID> mZooKeeperDbTxns;
    private final ClusterNodeType mNodeType;
    private final ClusterNodeRole mRole;
    private final boolean mReadOnly;
    private final UUID mLastAdminTx;
    private final UUID mLastZKSystemDbTx;

    public ClusterNodeStatus(String theNodeAddress, Map<String, Object> theMetadata, String theNodeType, String theNodeRole, boolean theReadOnly, UUID theLastAdminTx, UUID theLastZKSystemDbTx, Map<String, UUID> theDatabaseTxns, Map<String, UUID> theZKDatabaseTxns) {
        this.mNodeAddress = theNodeAddress;
        this.mMetadata = theMetadata;
        this.mNodeType = ClusterNodeType.valueOf(theNodeType);
        this.mRole = ClusterNodeRole.valueOf(theNodeRole);
        this.mReadOnly = theReadOnly;
        this.mLastAdminTx = theLastAdminTx;
        this.mLastZKSystemDbTx = theLastZKSystemDbTx;
        this.mDatabaseTxns = theDatabaseTxns;
        this.mZooKeeperDbTxns = theZKDatabaseTxns;
    }

    public ClusterNodeStatus(String theNodeAddress, Map<String, Object> theMetadata, ClusterNodeType theNodeType, ClusterNodeRole theNodeRole, boolean theReadOnly, UUID theLastAdminTx, UUID theLastZKSystemDbTx, Map<String, UUID> theDatabaseTxns, Map<String, UUID> theZKDatabaseTxns) {
        this.mNodeAddress = theNodeAddress;
        this.mMetadata = theMetadata;
        this.mNodeType = theNodeType;
        this.mRole = theNodeRole;
        this.mReadOnly = theReadOnly;
        this.mLastAdminTx = theLastAdminTx;
        this.mLastZKSystemDbTx = theLastZKSystemDbTx;
        this.mDatabaseTxns = theDatabaseTxns;
        this.mZooKeeperDbTxns = theZKDatabaseTxns;
    }

    @JsonProperty(value="address")
    public String getNodeAddress() {
        return this.mNodeAddress;
    }

    @JsonProperty(value="metadata")
    @JsonPropertyOrder(alphabetic=true)
    public Map<String, Object> getMetadata() {
        return this.mMetadata;
    }

    @JsonProperty(value="databaseTxns")
    @JsonPropertyOrder(alphabetic=true)
    public Map<String, UUID> getDatabaseTxns() {
        return this.mDatabaseTxns;
    }

    @JsonProperty(value="zkDatabaseTxns")
    @JsonPropertyOrder(alphabetic=true)
    public Map<String, UUID> getZKDatabaseTxns() {
        return this.mZooKeeperDbTxns;
    }

    @JsonProperty(value="type")
    public ClusterNodeType getNodeType() {
        return this.mNodeType;
    }

    @JsonProperty(value="role")
    public ClusterNodeRole getRole() {
        return this.mRole;
    }

    @JsonProperty(value="readOnly")
    public boolean getReadOnly() {
        return this.mReadOnly;
    }

    @JsonProperty(value="lastAdminTx")
    public UUID getLastAdminTx() {
        return this.mLastAdminTx;
    }

    @JsonProperty(value="lastZKSystemDbTx")
    public String getLastZKSystemDbTx() {
        return this.mLastZKSystemDbTx == null ? null : this.mLastZKSystemDbTx.toString();
    }

    @JsonIgnore
    public boolean isCoordinator() {
        return this.mRole == ClusterNodeRole.COORDINATOR;
    }

    @JsonCreator
    private ClusterNodeStatus(@JsonProperty(value="address") String theNodeAddress, @JsonProperty(value="type") String theNodeType, @JsonProperty(value="role") String theNodeRole, @JsonProperty(value="readOnly") String theReadOnly, @JsonProperty(value="metadata") Map<String, Object> theMetadata, @JsonProperty(value="lastAdminTx") UUID theLastAdminTx, @JsonProperty(value="lastZKSystemDbTx") String theLastZKSystemDbTx, @JsonProperty(value="databaseTxns") Map<String, UUID> theDatabaseTxns, @JsonProperty(value="zkDatabaseTxns") Map<String, UUID> theZKDatabaseTxns) {
        this.mNodeAddress = theNodeAddress;
        this.mMetadata = theMetadata;
        this.mNodeType = ClusterNodeType.valueOf(theNodeType);
        this.mRole = ClusterNodeRole.valueOf(theNodeRole);
        this.mReadOnly = Boolean.valueOf(theReadOnly);
        this.mLastAdminTx = theLastAdminTx;
        this.mLastZKSystemDbTx = UUID.fromString(theLastZKSystemDbTx);
        this.mDatabaseTxns = theDatabaseTxns;
        this.mZooKeeperDbTxns = theZKDatabaseTxns;
    }
}

