/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.protocols.http.icv.client;

import com.complexible.common.base.CloseableIterator;
import com.complexible.common.base.Options;
import com.complexible.common.rdf.StatementIterator;
import com.complexible.common.rdf.query.GraphQueryResultIterator;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.GraphQuery;
import com.complexible.stardog.api.impl.AbstractConnection;
import com.complexible.stardog.cache.api.CacheConnectionOptions;
import com.complexible.stardog.icv.AbstractValidationReporter;
import com.complexible.stardog.icv.Constraint;
import com.complexible.stardog.icv.ICV;
import com.complexible.stardog.icv.ValidationOptions;
import com.complexible.stardog.icv.ValidationReporter;
import com.complexible.stardog.icv.api.AbstractICVConnection;
import com.complexible.stardog.icv.api.ICVConnection;
import com.complexible.stardog.icv.shacl.NodeShape;
import com.complexible.stardog.icv.shacl.SHACL;
import com.complexible.stardog.icv.shacl.ShaclConstraint;
import com.complexible.stardog.icv.shacl.Shape;
import com.complexible.stardog.icv.shacl.ValidationResult;
import com.complexible.stardog.icv.shacl.ValidationResultReader;
import com.complexible.stardog.icv.shacl.validator.ShaclUtils;
import com.complexible.stardog.protocols.http.client.ApacheHttp;
import com.complexible.stardog.protocols.http.client.Client;
import com.complexible.stardog.protocols.http.client.HttpClient;
import com.complexible.stardog.protocols.http.client.HttpConnection;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.io.InvalidRDF;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFParsers;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.GraphQueryResult;
import com.stardog.stark.vocabs.RDF;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;

final class ICVHttpConnection
extends AbstractICVConnection
implements ICVConnection {
    ICVHttpConnection(HttpConnection theConnection) {
        super((AbstractConnection)theConnection);
    }

    protected HttpConnection getConnection() {
        return (HttpConnection)super.getConnection();
    }

    HttpConnection getOpenConnection() throws StardogException {
        this.assertOpen("Connection is closed");
        return (HttpConnection)super.getConnection();
    }

    public Set<Constraint> getConstraints() throws StardogException {
        HttpClient aAPI = this.getOpenConnection().getClient();
        String uri = aAPI.url("icv");
        HttpGet get = new HttpGet(uri);
        get.addHeader("Accept", (Object)RDFFormats.TURTLE.defaultMimeType());
        CloseableHttpResponse aResponse = null;
        try {
            aResponse = aAPI.execute((ClassicHttpRequest)get);
            HttpEntity aEntity = aResponse.getEntity();
            String aContentType = aEntity.getContentType();
            Set<Constraint> set = this.readConstraints(aContentType == null ? null : aContentType, aEntity.getContent());
            return set;
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, StardogException.class);
            throw Client.toStardogException((String)"get constraints", (Exception)e);
        }
        finally {
            ApacheHttp.HttpResponses.consumeQuietly((CloseableHttpResponse)aResponse);
        }
    }

    public CloseableIterator<BindingSet> getViolationBindings(Collection<IRI> theActiveGraphs, Constraint ... theConstraints) throws StardogException {
        Preconditions.checkNotNull(theActiveGraphs, (Object)"Graphs cannot be null");
        Preconditions.checkNotNull((Object)theConstraints, (Object)"Constraints cannot be null");
        Options options = Options.create().set(ValidationOptions.CONSTRAINTS, Arrays.asList(theConstraints)).set(ValidationOptions.GRAPHS, theActiveGraphs);
        String query = ShaclUtils.createValidateServiceSelectQuery((Options)options);
        return (CloseableIterator)this.select(query, "http://api.stardog.com/").execute();
    }

    private Set<Constraint> readConstraints(String theContentType, InputStream theContent) throws StardogException {
        RDFFormat aFormat = RDFFormats.forMime((String)theContentType).orElse(RDFFormats.TURTLE);
        try {
            Set aStatements = RDFParsers.read((InputStream)theContent, (RDFFormat)aFormat);
            Set set = this.readShaclConstraint(aStatements).map(Collections::singleton).orElse(ICV.constraintsFromGraph((Iterable)aStatements));
            return set;
        }
        catch (IOException e) {
            throw new StardogException("Error getting content in response to validate", (Throwable)e);
        }
        catch (InvalidRDF e) {
            throw new StardogException("Parse error reading constraints", (Throwable)e);
        }
        finally {
            try {
                theContent.close();
            }
            catch (IOException e) {
                LOGGER.error("There was an error closing the stream containing the constraints", (Throwable)e);
            }
        }
    }

    private Optional<Constraint> readShaclConstraint(Set<Statement> theStatements) {
        if (theStatements.size() == 1) {
            Statement aStmt = theStatements.iterator().next();
            Resource s = aStmt.subject();
            IRI p = aStmt.predicate();
            Value o = aStmt.object();
            if (p.equals((Object)RDF.TYPE) && o.equals((Object)SHACL.Shape)) {
                return Optional.of(new ShaclConstraint((Shape)new NodeShape(s)));
            }
        }
        return Optional.empty();
    }

    public StatementIterator getValidationReport(Collection<IRI> theActiveGraphs, Options theOptions, Constraint ... theConstraints) throws StardogException {
        Preconditions.checkNotNull(theActiveGraphs, (Object)"Graphs cannot be null");
        Preconditions.checkNotNull((Object)theConstraints, (Object)"Constraints cannot be null");
        Options aOptions = theOptions.copy().set(ValidationOptions.GRAPHS, theActiveGraphs);
        if (theConstraints.length > 0) {
            aOptions.set(ValidationOptions.CONSTRAINTS, Arrays.asList(theConstraints));
        }
        GraphQuery aQuery = this.graph(ShaclUtils.createValidateQuery((Options)aOptions));
        if (!theOptions.is(CacheConnectionOptions.CACHING_ENABLED)) {
            aQuery.hint("cached.dataset.name", "none");
        }
        return new GraphQueryResultIterator((GraphQueryResult)aQuery.execute());
    }

    public ValidationReporter reporter() {
        return new AbstractValidationReporter(){

            public StatementIterator report(Options options) {
                return ICVHttpConnection.this.getValidationReport((Collection)options.get(ValidationOptions.GRAPHS), options, new Constraint[0]);
            }

            protected void report(Options options, RDFHandler handler) throws StardogException {
                try (StatementIterator report = this.report(options);){
                    report.forEachRemaining(arg_0 -> ((RDFHandler)handler).handle(arg_0));
                }
            }

            protected CloseableIterator<ValidationResult> results(Options options) {
                return new ValidationResultReader((CloseableIterator)this.report(options));
            }
        };
    }
}

