/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.update.io;

import com.complexible.stardog.api.update.UpdateHandler;
import com.complexible.stardog.api.update.UpdateOperation;
import com.google.common.base.Preconditions;
import com.stardog.stark.io.ParserOptions;
import com.stardog.stark.io.WritingFailed;
import com.stardog.stark.io.turtle.TurtleUtil;
import com.stardog.stark.io.turtle.TurtleWriter;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;

public class UpdateTurtleWriter
extends TurtleWriter
implements UpdateHandler {
    private final boolean mSPARQLPrefix;
    protected UpdateOperation mOperation = null;

    public UpdateTurtleWriter(OutputStream out, boolean theSPARQLPrefix) {
        super(out, ParserOptions.defaults());
        this.mSPARQLPrefix = theSPARQLPrefix;
    }

    public void comment(@Nonnull String line) {
        if (this.mOperation != null) {
            this.endOperation(this.mOperation);
        }
        super.comment(line);
    }

    protected void writeNamespace(@Nonnull String prefix, @Nonnull String name) {
        if (this.mOperation != null) {
            this.endOperation(this.mOperation);
        }
        try {
            this.mWriter.write(this.mSPARQLPrefix ? "PREFIX " : "@prefix ");
            this.mWriter.write(prefix);
            this.mWriter.write(": <");
            this.mWriter.write(TurtleUtil.encodeURIString((String)name));
            this.mWriter.write(">");
            if (!this.mSPARQLPrefix) {
                this.mWriter.write(" .");
            }
            this.mWriter.write(System.lineSeparator());
        }
        catch (IOException e) {
            throw new WritingFailed((Throwable)e);
        }
    }

    @Override
    public void startOperation(UpdateOperation theOp) {
        Preconditions.checkState((this.mOperation == null ? 1 : 0) != 0, (String)"%s have already been started", (Object)this.mOperation);
        this.mOperation = theOp;
    }

    @Override
    public void endOperation(UpdateOperation theOp) {
        Preconditions.checkState((this.mOperation == theOp ? 1 : 0) != 0, (String)"%s have not been started yet", (Object)this.mOperation);
        this.mOperation = null;
    }
}

