/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.update.io;

import com.complexible.stardog.api.update.UpdateOperation;
import com.complexible.stardog.api.update.io.UpdateTurtleWriter;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.stardog.common.io.block.BlockMarker;
import com.stardog.common.io.block.BlockSpec;
import com.stardog.common.io.block.Bracket;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Values;
import com.stardog.stark.io.RDFHandlerException;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;

public class UpdateSPARQLWriter
extends UpdateTurtleWriter {
    private UpdateOperation.Type currentOperation;
    private Resource currentContext;
    private static final BlockSpec GRAPH_BLOCK = BlockSpec.INDENTED.copy().indentSize(4).marker((BlockMarker)Bracket.CURLY).newLineBeforeEnd(false).newLineAfterEnd(false).immutable();
    private static final BlockSpec QUERY_BLOCK = BlockSpec.INDENTED.copy().indentSize(4).marker("{", "};").newLineBeforeEnd(true).newLineAfterEnd(true).immutable();

    public UpdateSPARQLWriter(OutputStream out) {
        super(out, true);
        this.mBlockSpec = this.mBlockSpec.copy().indentSize(4).immutable();
    }

    public void start() throws RDFHandlerException {
        super.start();
        this.currentContext = null;
        this.currentOperation = null;
    }

    public void end() throws RDFHandlerException {
        super.end();
        try {
            this.closeOperation();
            this.mOperation = null;
            this.mWriter.flush();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handle(@Nonnull Statement st) throws RDFHandlerException {
        Preconditions.checkState((this.mOperation != null ? 1 : 0) != 0, (Object)"Additions or removals need to be started explicitly before handling statements");
        try {
            boolean diffContext;
            Resource context = st.context();
            boolean diffOp = !Objects.equal((Object)((Object)this.mOperation.getType()), (Object)((Object)this.currentOperation));
            boolean bl = diffContext = !Objects.equal((Object)context, (Object)this.currentContext);
            if (diffOp || diffContext) {
                if (diffOp) {
                    this.closeOperation();
                    this.mWriter.write(this.mOperation.getType() == UpdateOperation.Type.ADD ? "INSERT" : "DELETE");
                    this.mWriter.write(" DATA ");
                    this.mWriter.beginBlock(QUERY_BLOCK);
                    this.mWriter.println();
                } else {
                    this.closeContext();
                }
                if (!Values.isDefaultGraph((Resource)context)) {
                    this.mWriter.write("GRAPH ");
                    this.writeResource(context);
                    this.mWriter.write(" ");
                    this.mWriter.beginBlock(GRAPH_BLOCK);
                }
                this.currentContext = context;
                this.currentOperation = this.mOperation.getType();
            }
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
        super.handle(st);
    }

    protected void closeOperation() throws IOException {
        if (this.currentOperation != null) {
            this.closeContext();
            this.mWriter.endBlock();
            this.currentOperation = null;
        }
    }

    protected void closeContext() throws IOException {
        this.closePreviousStatement();
        if (this.currentContext != null) {
            this.mWriter.println();
            if (!Values.isDefaultGraph((Resource)this.currentContext)) {
                this.mWriter.endBlock();
            }
        }
    }
}

