/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.update.impl;

import com.complexible.stardog.api.update.UpdateOperation;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class DefaultUpdateOperation
implements UpdateOperation {
    private final UpdateOperation.Type mType;
    private final Iterable<Statement> mStatements;
    private final ImmutableSet<IRI> mNamedGraphs;
    private final Set<Value> mParameters;
    private final Map<Value, Value> mBindings;
    private final Function<Statement, Statement> mTransfomer = new Function<Statement, Statement>(){
        Resource aSubject;
        IRI aPredicate;
        Value anObject;

        @Override
        public Statement apply(Statement theInput) {
            this.aSubject = theInput.subject();
            this.aPredicate = theInput.predicate();
            this.anObject = theInput.object();
            boolean aParametrized = false;
            if (this.aSubject instanceof IRI && DefaultUpdateOperation.this.mBindings.containsKey(this.aSubject)) {
                this.aSubject = (Resource)DefaultUpdateOperation.this.mBindings.get(this.aSubject);
                aParametrized = true;
            }
            if (DefaultUpdateOperation.this.mBindings.containsKey(this.aPredicate)) {
                this.aPredicate = (IRI)DefaultUpdateOperation.this.mBindings.get(this.aPredicate);
                aParametrized = true;
            }
            if (this.anObject instanceof IRI && DefaultUpdateOperation.this.mBindings.containsKey(this.anObject)) {
                this.anObject = DefaultUpdateOperation.this.mBindings.get(this.aPredicate);
                aParametrized = true;
            }
            return aParametrized ? Values.statement((Resource)this.aSubject, (IRI)this.aPredicate, (Value)this.anObject) : theInput;
        }
    };

    public DefaultUpdateOperation(UpdateOperation.Type theType, Iterable<Statement> theStatements, Set<IRI> theNamedGraphs) {
        this.mType = theType;
        this.mStatements = theStatements;
        this.mNamedGraphs = ImmutableSet.copyOf(theNamedGraphs);
        this.mParameters = DefaultUpdateOperation.collectParameters(theStatements);
        this.mBindings = Maps.newHashMap();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getType().hashCode();
        for (Statement aStmt : this.mStatements) {
            result = 31 * result + aStmt.hashCode();
        }
        result = 31 * result + this.mBindings.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateOperation other = (UpdateOperation)obj;
        return this.getType() == other.getType() && this.getStatements().equals(other.getStatements());
    }

    @Override
    public UpdateOperation.Type getType() {
        return this.mType;
    }

    @Override
    public Iterable<Statement> getStatements() {
        return this.mBindings.isEmpty() ? this.mStatements : Iterables.transform(this.mStatements, this.mTransfomer::apply);
    }

    @Override
    public Set<IRI> getNamedGraphs() {
        return this.mNamedGraphs;
    }

    public String toString() {
        return String.valueOf((Object)this.getType()) + " " + String.valueOf(this.getStatements());
    }

    private static Set<Value> collectParameters(Iterable<Statement> theStatements) {
        HashSet aParameters = Sets.newHashSet();
        for (Statement aStatement : theStatements) {
            DefaultUpdateOperation.addIfParameter((Value)aStatement.subject(), aParameters);
            DefaultUpdateOperation.addIfParameter((Value)aStatement.predicate(), aParameters);
            DefaultUpdateOperation.addIfParameter(aStatement.object(), aParameters);
        }
        return aParameters;
    }

    private static void addIfParameter(Value theValue, Set<Value> theParameters) {
        if (DefaultUpdateOperation.containsParameter(theValue)) {
            theParameters.add(theValue);
        }
    }

    private static boolean containsParameter(Value theValue) {
        if (theValue instanceof IRI) {
            return ((IRI)theValue).namespace().equals("tag:stardog:api:variable:");
        }
        if (theValue instanceof Literal) {
            return ((Literal)theValue).label().startsWith("tag:stardog:api:variable:");
        }
        return false;
    }

    @Override
    public boolean hasParameters() {
        return !this.mParameters.isEmpty();
    }

    @Override
    public Set<Value> getParameters() {
        return this.mParameters;
    }

    @Override
    public Set<Value> getUnboundParameters() {
        return Sets.difference(this.getParameters(), this.mBindings.keySet());
    }

    @Override
    public UpdateOperation parameter(Value theParameter, Value theValue) {
        Preconditions.checkArgument((boolean)this.mParameters.contains(theParameter), (String)"%s is not a parameter for this operation", (Object)theParameter);
        Preconditions.checkArgument((!DefaultUpdateOperation.containsParameter(theValue) ? 1 : 0) != 0, (String)"A parameter cannot be bound to another parameter: %s -> %s", (Object)theParameter, (Object)theValue);
        this.mBindings.put(theParameter, theValue);
        return this;
    }
}

