/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.update;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.update.UpdateExecutor;
import com.complexible.stardog.api.update.UpdateHandler;
import com.complexible.stardog.api.update.UpdateOperation;
import com.complexible.stardog.api.update.UpdateSequence;
import com.complexible.stardog.api.update.impl.DefaultUpdateOperation;
import com.complexible.stardog.api.update.impl.DefaultUpdateSequence;
import com.complexible.stardog.api.update.io.UpdateSPARQLWriter;
import com.google.common.collect.Sets;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespace;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.RDFHandlerException;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public class Updates {
    public static final String VARIABLE_NAMESPACE = "tag:stardog:api:variable:";

    private Updates() {
        throw new AssertionError();
    }

    public static UpdateSequence newSequence(UpdateOperation ... theOperations) {
        return new DefaultUpdateSequence(Arrays.asList(theOperations));
    }

    public static UpdateSequence sequence(Collection<UpdateOperation> theOperations) {
        return new DefaultUpdateSequence(theOperations);
    }

    public static UpdateOperation add(Statement ... theStatements) {
        return Updates.add(Arrays.asList(theStatements), new IRI[0]);
    }

    public static UpdateOperation add(Iterable<Statement> theStatements, IRI ... theNamedGraphs) {
        return Updates.add(theStatements, Sets.newHashSet((Object[])theNamedGraphs));
    }

    public static UpdateOperation add(Iterable<Statement> theStatements, Set<IRI> theNamedGraphs) {
        return new DefaultUpdateOperation(UpdateOperation.Type.ADD, theStatements, theNamedGraphs);
    }

    public static UpdateOperation remove(Statement ... theStatements) {
        return Updates.remove(Arrays.asList(theStatements), new IRI[0]);
    }

    public static UpdateOperation remove(Iterable<Statement> theStatements, IRI ... theNamedGraphs) {
        return new DefaultUpdateOperation(UpdateOperation.Type.REMOVE, theStatements, Sets.newHashSet((Object[])theNamedGraphs));
    }

    public static String toSPARQL(Iterable<UpdateOperation> theOperations, Iterable<Namespace> theNamespaces) {
        try {
            ByteArrayOutputStream aWriter = new ByteArrayOutputStream();
            UpdateSPARQLWriter aHandler = new UpdateSPARQLWriter(aWriter);
            aHandler.start();
            theNamespaces.forEach(ns -> aHandler.namespace(ns.prefix(), ns.iri()));
            Updates.handle(theOperations, (UpdateHandler)aHandler);
            aHandler.end();
            return aWriter.toString();
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public static UpdateHandler executor(Connection theConnection) throws StardogException {
        return new UpdateExecutor(theConnection);
    }

    public static void execute(Iterable<UpdateOperation> theOperations, Connection theConnection) throws StardogException {
        UpdateExecutor aExecutor = new UpdateExecutor(theConnection);
        try {
            aExecutor.start();
            Updates.handle(theOperations, (UpdateHandler)aExecutor);
            aExecutor.end();
        }
        catch (RDFHandlerException e) {
            throw new StardogException((Throwable)e);
        }
    }

    public static void handle(Iterable<UpdateOperation> theOperations, UpdateHandler theHandler) throws RDFHandlerException {
        for (UpdateOperation aOp : theOperations) {
            Updates.handle(aOp, theHandler);
        }
    }

    public static void handle(UpdateOperation aOp, UpdateHandler theHandler) throws RDFHandlerException {
        theHandler.startOperation(aOp);
        for (Statement aStmt : aOp.getStatements()) {
            if (aOp.getNamedGraphs().isEmpty()) {
                theHandler.handle(aStmt);
                continue;
            }
            for (IRI aContext : aOp.getNamedGraphs()) {
                theHandler.handle(Values.statement((Resource)aStmt.subject(), (IRI)aStmt.predicate(), (Value)aStmt.object(), (Resource)aContext));
            }
        }
        theHandler.endOperation(aOp);
    }
}

