/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.test;

import com.complexible.stardog.api.test.Test;
import com.complexible.stardog.api.test.TestSuite;
import com.complexible.stardog.api.test.TestVocab;
import com.complexible.stardog.api.test.Testable;
import com.google.common.base.Preconditions;
import com.google.common.collect.Queues;
import com.stardog.stark.BNode;
import com.stardog.stark.Datatype;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFWriter;
import com.stardog.stark.io.RDFWriters;
import com.stardog.stark.vocabs.RDF;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;

public final class TestWriter {
    private RDFWriter writer;
    private RDFFormat format = RDFFormats.PRETTY_TURTLE;

    public void writeRecursively(TestSuite start) throws IOException {
        ArrayDeque suites = Queues.newArrayDeque();
        suites.add(start);
        while (!suites.isEmpty()) {
            TestSuite suite = (TestSuite)suites.remove();
            Preconditions.checkArgument((suite.dir() != null ? 1 : 0) != 0, (Object)"No directory specified for the test suite");
            Path file = suite.dir().resolve(suite.name() + "." + this.format.defaultExtension());
            if (Files.exists(file, new LinkOption[0])) {
                throw new IOException("File already exists: " + String.valueOf(file));
            }
            OutputStream out = Files.newOutputStream(file, new OpenOption[0]);
            try {
                this.write(suite, out, suites);
            }
            finally {
                if (out == null) continue;
                out.close();
            }
        }
    }

    public void write(TestSuite suite, OutputStream out) throws IOException {
        this.write(suite, out, Queues.newArrayDeque());
    }

    private void write(TestSuite suite, OutputStream out, Queue<TestSuite> includes) throws IOException {
        this.writer = (RDFWriter)RDFWriters.to((OutputStream)out, (RDFFormat)this.format).orElseThrow(() -> new IllegalArgumentException("Unsupported format"));
        this.writer.start();
        this.writer.namespace("", "tag:stardog:api:test:");
        BNode include = Values.bnode();
        Test defaults = suite.defaults();
        this.writeTest(defaults, null);
        for (Testable testable : suite.tests) {
            if (testable instanceof Test) {
                this.writeTest((Test)testable, defaults);
                continue;
            }
            if (testable instanceof TestSuite) {
                TestSuite child = (TestSuite)testable;
                includes.add(child);
                Path childPath = child.dir().resolve(child.name());
                Path relativePath = suite.dir().relativize(childPath);
                this.writer.handle(Values.statement((Resource)include, (IRI)TestVocab.INCLUDE, (Value)Values.literal((String)relativePath.toString())));
                continue;
            }
            throw new IllegalArgumentException("Unrecognized test type: " + String.valueOf(testable.getClass()));
        }
        this.writer.end();
    }

    private void writeTest(Test test, Test defaults) {
        IRI subj;
        if (defaults == null) {
            subj = TestVocab.DEFAULTS;
            defaults = new Test();
        } else {
            subj = Values.iri((String)"tag:stardog:api:test:", (String)test.name());
            this.writer.handle(Values.statement((Resource)subj, (IRI)RDF.TYPE, (Value)TestVocab.TEST));
        }
        this.writeValue(subj, TestVocab.SERVER, test.server(), defaults.server(), Datatype.STRING);
        this.writeValue(subj, TestVocab.DATABASE, test.db(), defaults.db(), Datatype.STRING);
        this.writeValue(subj, TestVocab.QUERY_FILE, test.queryFile(), defaults.queryFile(), Datatype.STRING);
        if (test.isReasoning() == null && defaults.isReasoning() != null) {
            this.writeValue(subj, TestVocab.REASONING, false, true, Datatype.BOOLEAN);
        } else if (Objects.equals(test.isReasoning(), "default") && !Objects.equals(defaults.isReasoning(), "default")) {
            this.writeValue(subj, TestVocab.REASONING, true, false, Datatype.BOOLEAN);
        } else {
            this.writeValue(subj, TestVocab.REASONING, test.isReasoning(), defaults.isReasoning(), Datatype.STRING);
        }
        this.writeValue(subj, TestVocab.RESULT_FILE, test.resultFile(), defaults.resultFile(), Datatype.STRING);
        this.writeValue(subj, TestVocab.RESULT_COUNT, test.resultCount(), defaults.resultCount(), Datatype.INTEGER);
        this.writeValue(subj, TestVocab.RESULT_ORDERED, test.isResultOrdered(), defaults.isResultOrdered(), Datatype.BOOLEAN);
        this.writeValue(subj, TestVocab.EXPECTED_TIME, test.expectedTime(), defaults.expectedTime(), Datatype.INTEGER);
        this.writeValue(subj, TestVocab.FAILURE_THRESHOLD, test.failureThreshold(), defaults.failureThreshold(), Datatype.INTEGER);
        this.writeValue(subj, TestVocab.WARMUPS, test.warmups(), defaults.warmups(), Datatype.INTEGER);
        this.writeValue(subj, TestVocab.RUNS, test.runs(), defaults.runs(), Datatype.INTEGER);
        this.writeValue(subj, TestVocab.IGNORE, test.isIgnored(), defaults.isIgnored(), Datatype.BOOLEAN);
    }

    private void writeValue(IRI subj, IRI pred, Object value, Object defaultValue, Datatype dt) {
        if (value != null && !Objects.equals(value, defaultValue)) {
            this.writer.handle(Values.statement((Resource)subj, (IRI)pred, (Value)Values.literal((String)value.toString(), (Datatype)dt)));
        }
    }
}

