/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.test;

import com.complexible.common.io.Files2;
import com.complexible.common.rdf.query.PathQueryResult;
import com.complexible.common.rdf.query.PathsAsTupleQueryResult;
import com.complexible.common.rdf.query.SPARQLUtil;
import com.complexible.stardog.StoredQuery;
import com.complexible.stardog.api.BooleanQuery;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.ConnectionConfiguration;
import com.complexible.stardog.api.GraphQuery;
import com.complexible.stardog.api.PathQuery;
import com.complexible.stardog.api.Query;
import com.complexible.stardog.api.SelectQuery;
import com.complexible.stardog.api.UpdateQuery;
import com.complexible.stardog.api.test.Test;
import com.complexible.stardog.api.test.TestCreator;
import com.complexible.stardog.api.test.TestFailedException;
import com.complexible.stardog.api.test.TestResult;
import com.complexible.stardog.api.test.TestResultType;
import com.complexible.stardog.api.test.TestSuite;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.stardog.stark.BNode;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFParsers;
import com.stardog.stark.io.RDFWriter;
import com.stardog.stark.io.RDFWriters;
import com.stardog.stark.query.Binding;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.BooleanQueryResult;
import com.stardog.stark.query.GraphQueryResult;
import com.stardog.stark.query.SelectQueryResult;
import com.stardog.stark.query.impl.BooleanQueryResultImpl;
import com.stardog.stark.query.impl.SelectQueryResultImpl;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.QueryResultFormats;
import com.stardog.stark.query.io.QueryResultParsers;
import com.stardog.stark.query.io.QueryResultWriters;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.mutable.MutableInt;

public class TestRunner {
    private static Object UPDATE_RESULT = new Object();
    private final ConnectionConfiguration connConfig;
    private Test config;
    private Connection conn;
    Set<TestCreator.CreateOption> createOptions = EnumSet.noneOf(TestCreator.CreateOption.class);
    private boolean showPlans = false;
    private boolean stopOnFirstFailure = false;
    private boolean runUpdateQueriesOnce = true;
    private boolean showStackTraces = true;

    public TestRunner(ConnectionConfiguration config) {
        this.connConfig = config;
    }

    public List<TestResult> run(TestSuite suite) {
        ArrayList results = Lists.newArrayList();
        int count = suite.count();
        MutableInt progress = new MutableInt(0);
        try {
            suite.test(test -> {
                TestResultType result;
                String msg;
                int i;
                block6: {
                    i = progress.incrementAndGet();
                    System.out.printf("START TEST (%d of %d): %s%n", i, count, test.name());
                    msg = "";
                    try {
                        if (test.isIgnored() || test.warmups() == 0 && test.runs() == 0) {
                            result = TestResultType.IGNORED;
                        } else {
                            this.runTest((Test)test);
                            result = TestResultType.PASSED;
                        }
                    }
                    catch (Throwable e) {
                        msg = Throwables.getRootCause((Throwable)e).toString();
                        if (e instanceof TestFailedException) {
                            result = ((TestFailedException)e).getResult();
                        }
                        result = TestResultType.FAILED_ERROR;
                        if (!this.showStackTraces) break block6;
                        e.printStackTrace(System.out);
                    }
                }
                results.add(new TestResult((Test)test, result, msg));
                System.out.printf("%n%s%nFINISH TEST (%d of %d) %s - %s%n-----%n%n", new Object[]{msg, i, count, test.name(), result});
                if (result.isFailure() && this.stopOnFirstFailure) {
                    throw new StopOnFirstFailure();
                }
            });
        }
        catch (StopOnFirstFailure stopOnFirstFailure) {
            // empty catch block
        }
        return results;
    }

    private void runTest(Test test) throws Exception {
        this.connect(test);
        Query<?> query = this.createQuery(test);
        if (this.showPlans) {
            System.out.printf("Plan:%n%s%n", query.explain());
        }
        LongSummaryStatistics stats = new LongSummaryStatistics();
        int resultCount = test.resultCount();
        int warmups = query instanceof UpdateQuery && this.runUpdateQueriesOnce ? 0 : test.warmups();
        int runs = query instanceof UpdateQuery && this.runUpdateQueriesOnce ? 1 : test.runs();
        for (int iteration = -warmups; iteration <= runs; ++iteration) {
            if (iteration == 0) {
                ++iteration;
            }
            boolean warmup = iteration < 0;
            System.out.printf("%s: %d ", warmup ? "WARMUP" : "RUN", iteration);
            long startTime = System.currentTimeMillis();
            Object queryResult = this.runQuery(query);
            long elapsedTime = System.currentTimeMillis() - startTime;
            int count = this.checkCorrectness(test, queryResult);
            System.out.printf("Results: %d Time: %dms%n", resultCount, elapsedTime);
            if (resultCount == -1) {
                resultCount = count;
            } else if (resultCount != count) {
                throw new TestFailedException(TestResultType.FAILED_CORRECTNESS, TestRunner.formatErrorMessage("Query Results", resultCount, count));
            }
            if (warmup) continue;
            stats.accept(elapsedTime);
        }
        if (!this.createOptions.isEmpty()) {
            if (this.createOptions.contains((Object)TestCreator.CreateOption.EXPECTED_TIME)) {
                test.setExpectedTime((long)stats.getAverage());
            }
            if (this.createOptions.contains((Object)TestCreator.CreateOption.RESULT_COUNT)) {
                test.setResultCount(resultCount);
            }
        } else if (test.expectedTime() != -1L) {
            int threshold = test.failureThreshold();
            int slowdown = (int)(100.0 * (stats.getAverage() - (double)test.expectedTime()) / (double)test.expectedTime());
            if (slowdown > threshold) {
                throw new TestFailedException(TestResultType.FAILED_TIMING, TestRunner.formatErrorMessage("Query Time", test.expectedTime(), (long)stats.getAverage()) + String.format(" (Slowdown: %d%%)", slowdown));
            }
        }
    }

    private void connect(Test test) throws Exception {
        if (!(this.config != null && Objects.equals(this.config.server(), test.server()) && Objects.equals(this.config.db(), test.db()) && Objects.equals(this.config.isReasoning(), test.isReasoning()))) {
            this.config = test;
            if (this.config.server() == null) {
                throw new TestFailedException(TestResultType.FAILED_ERROR, "No server specified");
            }
            if (this.config.db() == null) {
                throw new TestFailedException(TestResultType.FAILED_ERROR, "No database specified");
            }
            System.out.printf("Connecting to %s/%s%n", this.config.server(), this.config.db());
            this.conn = this.connConfig.database(this.config.db()).server(this.config.server()).schema(this.config.isReasoning()).connect();
        }
    }

    private Path resolveFile(Test test, String file) {
        return test.suite() != null ? test.suite().dir().resolve(file) : Paths.get(file, new String[0]);
    }

    private Query<?> createQuery(Test test) throws IOException {
        String query = test.queryString();
        if (test.queryFile() != null) {
            Path queryFile = this.resolveFile(test, test.queryFile());
            query = Files2.toString((Path)queryFile);
        } else if (test.queryStored() != null) {
            try {
                query = this.conn.admin().getStoredQueries().get(test.queryStored()).getQuery();
            }
            catch (Exception e) {
                if (!StoredQuery.isValidName((String)test.queryStored())) {
                    throw new TestFailedException(TestResultType.FAILED_ERROR, "Invalid stored query: " + test.queryStored());
                }
                throw new TestFailedException(TestResultType.FAILED_ERROR, "Stored query not found: " + test.queryStored());
            }
        }
        SPARQLUtil.QueryType type = SPARQLUtil.getType((String)query);
        switch (type) {
            case SELECT: {
                return this.conn.select(query);
            }
            case PATH: {
                return this.conn.paths(query);
            }
            case GRAPH: {
                return this.conn.graph(query);
            }
            case ASK: {
                return this.conn.ask(query);
            }
            case UPDATE: {
                return this.conn.update(query);
            }
            case PLAN: {
                return this.conn.selectPlan(query);
            }
        }
        throw new IllegalArgumentException("Unrecognized queryFile type: " + String.valueOf(type));
    }

    private Object runQuery(Query<?> query) throws Exception {
        if (query instanceof SelectQuery) {
            try (SelectQueryResult queryResult = (SelectQueryResult)((SelectQuery)query).execute();){
                SelectQueryResultImpl selectQueryResultImpl = new SelectQueryResultImpl(queryResult);
                return selectQueryResultImpl;
            }
        }
        if (query instanceof GraphQuery) {
            try (GraphQueryResult gqr = (GraphQueryResult)((GraphQuery)query).execute();){
                Set set = gqr.toGraph();
                return set;
            }
        }
        if (query instanceof PathQuery) {
            try (PathQueryResult queryResult = (PathQueryResult)((PathQuery)query).execute();){
                SelectQueryResultImpl selectQueryResultImpl = new SelectQueryResultImpl((SelectQueryResult)new PathsAsTupleQueryResult(queryResult));
                return selectQueryResultImpl;
            }
        }
        if (query instanceof BooleanQuery) {
            return ((BooleanQuery)query).execute();
        }
        if (query instanceof UpdateQuery) {
            ((UpdateQuery)query).execute();
            return UPDATE_RESULT;
        }
        throw new TestFailedException(TestResultType.FAILED_ERROR, "Unexpected query type: " + String.valueOf(query.getClass()));
    }

    private int checkCorrectness(Test test, Object result) throws Exception {
        int resultCount;
        if (result instanceof SelectQueryResult) {
            SelectQueryResultImpl queryResult = new SelectQueryResultImpl((SelectQueryResult)result);
            resultCount = queryResult.size();
            if (test.resultFile() != null) {
                SelectQueryResultImpl expectedResult = (SelectQueryResultImpl)QueryResultParsers.readSelect((Path)this.resolveFile(test, test.resultFile()));
                TestRunner.compareTupleQueryResults(test.name(), test.isResultOrdered(), queryResult, expectedResult);
            } else if (this.createOptions.contains((Object)TestCreator.CreateOption.RESULT)) {
                Path file = this.setAndResolveResultFile(test, QueryResultFormats.XML.defaultExtension());
                QueryResultWriters.write((SelectQueryResult)queryResult, (Path)file, (QueryResultFormat)QueryResultFormats.XML);
            }
        } else if (result instanceof Set) {
            Set queryResult = (Set)result;
            resultCount = queryResult.size();
            if (test.resultFile() != null) {
                Set expectedResult = RDFParsers.read((Path)this.resolveFile(test, test.resultFile()));
                TestRunner.compareGraphs(test.name(), queryResult, expectedResult);
            } else if (this.createOptions.contains((Object)TestCreator.CreateOption.RESULT)) {
                Path file = this.setAndResolveResultFile(test, RDFFormats.NQUADS.defaultExtension());
                try (OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
                    RDFWriters.write((OutputStream)out, (RDFFormat)RDFFormats.NQUADS, (Iterable)queryResult);
                }
            }
        } else if (result instanceof Boolean) {
            boolean queryResult = (Boolean)result;
            int n = resultCount = (Boolean)result != false ? 1 : 0;
            if (test.resultFile() != null) {
                boolean expectedResult = TestRunner.readBooleanQueryResult(this.resolveFile(test, test.resultFile()));
                if (expectedResult != queryResult) {
                    throw new TestFailedException(TestResultType.FAILED_CORRECTNESS, TestRunner.formatErrorMessage("Query Result", expectedResult ? 0L : 1L, resultCount));
                }
            } else if (this.createOptions.contains((Object)TestCreator.CreateOption.RESULT)) {
                Path file = this.setAndResolveResultFile(test, QueryResultFormats.XML_BOOLEAN.defaultExtension());
                QueryResultWriters.write((BooleanQueryResult)new BooleanQueryResultImpl(queryResult), (Path)file, (QueryResultFormat)QueryResultFormats.XML_BOOLEAN);
            }
        } else if (result.equals(UPDATE_RESULT)) {
            resultCount = 0;
        } else {
            throw new TestFailedException(TestResultType.FAILED_ERROR, "Unexpected query type: " + String.valueOf(result.getClass()));
        }
        return resultCount;
    }

    private static String formatErrorMessage(String msg, long expected, long actual) {
        return String.format("%s Expected : %d Actual: %d", msg, expected, actual);
    }

    private Path setAndResolveResultFile(Test test, String ext) {
        test.setResultFile(FilenameUtils.removeExtension((String)test.queryFile()) + "_results." + ext);
        return this.resolveFile(test, test.resultFile());
    }

    public static boolean readBooleanQueryResult(Path file) throws IOException {
        QueryResultFormat format = QueryResultFormats.booleanFormats().forFile(file).orElse(null);
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            boolean bl = QueryResultParsers.readBoolean((InputStream)in, (QueryResultFormat)format);
            return bl;
        }
    }

    public static void compareTupleQueryResults(String name, boolean ordered, SelectQueryResultImpl actual, SelectQueryResultImpl expected) {
        if (ordered) {
            int index = 0;
            while (expected.hasNext()) {
                ++index;
                BindingSet expectedBindings = expected.next();
                BindingSet actualBindings = actual.hasNext() ? actual.next() : null;
                boolean resultsCorrect = Objects.equals(actualBindings, expectedBindings);
                if (resultsCorrect) continue;
                throw new TestFailedException(TestResultType.FAILED_CORRECTNESS, TestRunner.formatErrorMessage("Query Result", actual.size(), expected.size()) + "\nBinding " + index + " Expected: " + String.valueOf(expectedBindings) + " Actual: " + String.valueOf(actualBindings));
            }
        } else {
            LinkedHashMultiset<Map<String, Value>> expectedBindings;
            LinkedHashMultiset<Map<String, Value>> actualBindings = TestRunner.convertQueryResult((SelectQueryResult)actual);
            boolean resultsCorrect = Objects.equals(actualBindings, expectedBindings = TestRunner.convertQueryResult((SelectQueryResult)expected));
            if (!resultsCorrect) {
                throw new TestFailedException(TestResultType.FAILED_CORRECTNESS, TestRunner.renderErrorMessage(name, ordered, actualBindings, expectedBindings));
            }
        }
    }

    public static LinkedHashMultiset<Map<String, Value>> convertQueryResult(SelectQueryResult queryResult) {
        return queryResult.stream().map(b -> b.stream().collect(Collectors.toMap(Binding::name, Binding::value))).collect(Collectors.toCollection(LinkedHashMultiset::create));
    }

    private static String renderErrorMessage(String name, boolean ordered, Multiset<Map<String, Value>> actual, Multiset<Map<String, Value>> expected) {
        boolean bnodesExist = expected.stream().map(Map::values).flatMap(Collection::stream).anyMatch(BNode.class::isInstance);
        if (bnodesExist) {
            return "Test " + name + ": Bnodes in expected query results not supported";
        }
        StringBuilder aMessage = new StringBuilder(128);
        aMessage.append(TestRunner.formatErrorMessage("Query Result", actual.size(), expected.size()));
        aMessage.append("\n");
        aMessage.append("Differences in bindings: \n");
        if (ordered) {
            Iterator it = actual.entrySet().iterator();
            for (Multiset.Entry e : expected.entrySet()) {
                int expectedCount = e.getCount();
                int actualCount = actual.count(e.getElement());
                if (actualCount >= expectedCount) continue;
                aMessage.append("Expected: " + expectedCount + " Actual: " + actualCount + " " + String.valueOf(e.getElement()) + "\n");
            }
        } else {
            for (Multiset.Entry e : expected.entrySet()) {
                int expectedCount = e.getCount();
                int actualCount = actual.count(e.getElement());
                if (actualCount >= expectedCount) continue;
                aMessage.append("Expected: " + expectedCount + " Actual: " + actualCount + " " + String.valueOf(e.getElement()) + "\n");
            }
            for (Multiset.Entry e : actual.entrySet()) {
                int actualCount = e.getCount();
                int expectedCount = expected.count(e.getElement());
                if (expectedCount != 0) continue;
                aMessage.append("Expected: " + expectedCount + " Actual: " + actualCount + " " + String.valueOf(e.getElement()) + "\n");
            }
        }
        return aMessage.toString();
    }

    public static void compareGraphs(String name, Set<Statement> actual, Set<Statement> expected) {
        if (!expected.equals(actual)) {
            boolean bnodesExist = expected.stream().map(Statement::object).anyMatch(BNode.class::isInstance);
            if (bnodesExist) {
                throw new TestFailedException(TestResultType.FAILED_ERROR, "Test " + name + ": Bnodes in expected query results not supported");
            }
            StringBuilder aMessage = new StringBuilder();
            aMessage.append(TestRunner.formatErrorMessage("Query Result", actual.size(), expected.size()));
            aMessage.append("\n");
            ByteArrayOutputStream aBytes = new ByteArrayOutputStream();
            RDFWriter writer = (RDFWriter)RDFWriters.to((OutputStream)aBytes, (RDFFormat)RDFFormats.TURTLE).get();
            writer.start();
            writer.comment("Missing triple(s): \n");
            for (Statement stmt : expected) {
                if (actual.contains(stmt)) continue;
                writer.handle(stmt);
            }
            writer.comment("=============");
            writer.comment("Unexpected triple(s): \n");
            for (Statement stmt : actual) {
                if (expected.contains(stmt)) continue;
                writer.handle(stmt);
            }
            aMessage.append(new String(aBytes.toByteArray(), Charsets.UTF_8));
            throw new TestFailedException(TestResultType.FAILED_CORRECTNESS, aMessage.toString());
        }
    }

    public boolean isShowPlans() {
        return this.showPlans;
    }

    public void setShowPlans(boolean showPlans) {
        this.showPlans = showPlans;
    }

    public boolean isStopOnFirstFailure() {
        return this.stopOnFirstFailure;
    }

    public void setStopOnFirstFailure(boolean stopOnFirstFailure) {
        this.stopOnFirstFailure = stopOnFirstFailure;
    }

    public boolean isRunUpdateQueriesOnce() {
        return this.runUpdateQueriesOnce;
    }

    public void setRunUpdateQueriesOnce(boolean runUpdateQueriesOnce) {
        this.runUpdateQueriesOnce = runUpdateQueriesOnce;
    }

    public boolean isShowStackTraces() {
        return this.showStackTraces;
    }

    public void setShowStackTraces(boolean showStackTraces) {
        this.showStackTraces = showStackTraces;
    }

    private static class StopOnFirstFailure
    extends RuntimeException {
        private StopOnFirstFailure() {
        }
    }
}

