/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.test;

import com.complexible.stardog.api.test.Test;
import com.complexible.stardog.api.test.TestResultType;
import com.google.common.base.Preconditions;

public class TestResult {
    private final Test test;
    private final TestResultType type;
    private final String msg;

    public TestResult(Test test, TestResultType type) {
        this(test, type, "");
        Preconditions.checkArgument((!type.isFailure() ? 1 : 0) != 0, (Object)"Test failure should have a message");
    }

    public TestResult(Test test, TestResultType type, String msg) {
        this.test = test;
        this.type = type;
        this.msg = msg;
    }

    public Test test() {
        return this.test;
    }

    public TestResultType type() {
        return this.type;
    }

    public String message() {
        return this.msg;
    }

    public String toString() {
        return this.test.name() + ": " + String.valueOf((Object)this.type) + " " + this.msg;
    }
}

