/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.test;

import com.complexible.common.rdf.rio.RDFStreams;
import com.complexible.stardog.Schemas;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.test.Test;
import com.complexible.stardog.api.test.TestDefinitionException;
import com.complexible.stardog.api.test.TestSuite;
import com.complexible.stardog.api.test.TestVocab;
import com.complexible.stardog.api.test.Testable;
import com.google.common.base.MoreObjects;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.impl.BooleanLiteral;
import com.stardog.stark.io.ParserOptions;
import com.stardog.stark.vocabs.RDF;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public final class TestReader {
    public TestSuite read(Path file) throws IOException {
        TestSuite suite = this.readWithDefaults(file, new Test());
        suite.test(this::validate);
        return suite;
    }

    public TestSuite readWithDefaults(Path file, Test defaults) throws IOException {
        String name = Files.getNameWithoutExtension((String)file.getFileName().toString());
        Path dir = (Path)MoreObjects.firstNonNull((Object)file.getParent(), (Object)Paths.get(StandardSystemProperty.USER_DIR.value(), new String[0]));
        TestSuite suite = new TestSuite(name, dir, defaults);
        List<Statement> graph = this.parse(file);
        this.read(graph, suite);
        return suite;
    }

    private List<Statement> parse(Path file) {
        try {
            return (List)RDFStreams.forFile((Path)file).config(ParserOptions.namespaces((Iterable)ImmutableList.of((Object)Values.namespace((String)"", (String)"tag:stardog:api:test:")))).parseInto((Collection)Lists.newArrayList());
        }
        catch (Exception e) {
            throw new StardogException("Failed to read " + String.valueOf(file) + ": " + String.valueOf(e));
        }
    }

    private void read(List<Statement> graph, TestSuite suite) throws IOException {
        LinkedHashMap lookupTable = Maps.newLinkedHashMap();
        Test test = null;
        for (Statement stmt : graph) {
            Resource subj = stmt.subject();
            IRI prop = stmt.predicate();
            Value obj = stmt.object();
            if (prop.equals((Object)TestVocab.INCLUDE)) {
                String include = Value.lex((Value)obj);
                TestSuite child = this.readWithDefaults(suite.dir().resolve(include), suite.defaults());
                suite.tests.add(child);
                test = null;
                continue;
            }
            String testName = this.localName(subj);
            if (subj.equals((Object)TestVocab.DEFAULTS)) {
                test = suite.defaults();
            } else {
                if (prop.equals((Object)RDF.TYPE) && obj.equals((Object)TestVocab.TEST)) {
                    test = new Test(testName, suite.defaults());
                    Testable prev = lookupTable.put(testName, test);
                    this.assertCondition(prev == null, "Duplicate test: " + testName);
                    suite.tests.add(test);
                    continue;
                }
                this.assertCondition((test = lookupTable.put(testName, test)) != null, "Test not defined: " + this.localName(subj));
            }
            if (prop.equals((Object)TestVocab.SERVER)) {
                test.setServer(Value.lex((Value)obj));
                continue;
            }
            if (prop.equals((Object)TestVocab.DATABASE)) {
                test.setDb(Value.lex((Value)obj));
                continue;
            }
            if (prop.equals((Object)TestVocab.REASONING)) {
                Value value = obj;
                test.setReasoning(value.equals((Object)BooleanLiteral.TRUE) ? "default" : (value.equals((Object)BooleanLiteral.FALSE) ? Schemas.NULL : Value.lex((Value)value)));
                continue;
            }
            if (prop.equals((Object)TestVocab.WARMUPS)) {
                test.setWarmups(Literal.intValue((Literal)((Literal)obj)));
                continue;
            }
            if (prop.equals((Object)TestVocab.RUNS)) {
                test.setRuns(Literal.intValue((Literal)((Literal)obj)));
                continue;
            }
            if (prop.equals((Object)TestVocab.QUERY_FILE)) {
                test.setQueryFile(Value.lex((Value)obj));
                continue;
            }
            if (prop.equals((Object)TestVocab.QUERY_STRING)) {
                test.setQueryString(Value.lex((Value)obj));
                continue;
            }
            if (prop.equals((Object)TestVocab.QUERY_STORED)) {
                test.setQueryStored(Value.lex((Value)obj));
                continue;
            }
            if (prop.equals((Object)TestVocab.RESULT_FILE)) {
                test.setResultFile(Value.lex((Value)obj));
                continue;
            }
            if (prop.equals((Object)TestVocab.RESULT_COUNT)) {
                test.setResultCount(Literal.intValue((Literal)((Literal)obj)));
                continue;
            }
            if (prop.equals((Object)TestVocab.RESULT_ORDERED)) {
                test.setResultOrdered(Literal.booleanValue((Literal)((Literal)obj)));
                continue;
            }
            if (prop.equals((Object)TestVocab.EXPECTED_TIME)) {
                test.setExpectedTime(Literal.longValue((Literal)((Literal)obj)));
                continue;
            }
            if (prop.equals((Object)TestVocab.FAILURE_THRESHOLD)) {
                test.setFailureThreshold(Literal.intValue((Literal)((Literal)obj)));
                continue;
            }
            if (prop.equals((Object)TestVocab.IGNORE)) {
                test.setIgnored(Literal.booleanValue((Literal)((Literal)obj)));
                continue;
            }
            System.err.println("Ignoring triple: " + String.valueOf(stmt));
        }
    }

    private String localName(Resource value) {
        return value instanceof IRI ? ((IRI)value).localName() : ((BNode)value).id();
    }

    private void assertCondition(boolean condition, String msg) {
        if (!condition) {
            throw new TestDefinitionException(msg);
        }
    }

    private void validate(Test test) {
        this.assertCondition(test.server() != null, "Server not specified for " + test.name());
        this.assertCondition(test.db() != null, "Database not specified for " + test.name());
        this.assertCondition(Stream.of(test.queryFile(), test.queryString(), test.queryStored()).filter(Objects::isNull).count() == 2L, "Exactly one of [queryFile, queryString, queryStored] should be specified for " + test.name());
        this.assertCondition(test.resultFile() != null || test.resultCount() != -1 || test.expectedTime() != -1L, "One of [resultFile, resultCount, expectedTime] should be specified for " + test.name());
        this.assertCondition(test.resultFile() == null || test.resultCount() == -1, "Only one of [resultFile, resultCount] must be specified for  " + test.name());
    }
}

