/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.test;

import com.complexible.common.util.AlphaNumericComparator;
import com.complexible.stardog.api.ConnectionConfiguration;
import com.complexible.stardog.api.test.Test;
import com.complexible.stardog.api.test.TestDefinitionException;
import com.complexible.stardog.api.test.TestResult;
import com.complexible.stardog.api.test.TestRunner;
import com.complexible.stardog.api.test.TestSuite;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TestCreator {
    private final ConnectionConfiguration connConfig;
    private final Test defaults;
    private final Set<CreateOption> createOptions;

    public TestCreator(ConnectionConfiguration config, Test defaults, Set<CreateOption> options) {
        this.connConfig = config;
        this.createOptions = options;
        this.defaults = new Test(defaults);
        this.defaults.setServer((String)config.get(ConnectionConfiguration.SERVER));
        this.defaults.setDb(config.get(ConnectionConfiguration.DATABASE));
    }

    public TestSuite create(Path path, String glob) throws IOException {
        Preconditions.checkArgument((!this.createOptions.isEmpty() ? 1 : 0) != 0, (Object)"No options to create tests were provided");
        Preconditions.checkArgument((!this.createOptions.contains((Object)CreateOption.RESULT) || !this.createOptions.contains((Object)CreateOption.RESULT_COUNT) ? 1 : 0) != 0, (Object)("Only one of " + String.valueOf((Object)CreateOption.RESULT) + " or " + String.valueOf((Object)CreateOption.RESULT_COUNT) + " should be provided"));
        Preconditions.checkArgument((this.defaults.warmups() != 0 || this.defaults.runs() != 0 ? 1 : 0) != 0, (Object)"Warmups and runs cannot be both 0");
        TestSuite suite = this.createSuite(path, glob);
        this.runAndSetParameters(suite);
        return suite;
    }

    private TestSuite createSuite(Path path, String glob) throws IOException {
        TestSuite suite = new TestSuite(path.getFileName().toString(), path, this.defaults);
        FileSystem fs = path.getFileSystem();
        PathMatcher matcher = fs.getPathMatcher("glob:" + glob);
        DirectoryStream.Filter<Path> filter = entry -> Files.isDirectory(entry, new LinkOption[0]) || matcher.matches(entry.getFileName());
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(path, filter);){
            for (Path child : Ordering.from((Comparator)AlphaNumericComparator.caseInsensitive()).immutableSortedCopy(ds)) {
                if (Files.isDirectory(child, new LinkOption[0])) {
                    TestSuite childSuite = this.createSuite(child, glob);
                    if (childSuite.tests().isEmpty()) continue;
                    suite.tests.add(childSuite);
                    continue;
                }
                Test test = this.createTest(suite, child);
                suite.tests.add(test);
            }
        }
        return suite;
    }

    private Test createTest(TestSuite suite, Path file) throws IOException {
        String name = com.google.common.io.Files.getNameWithoutExtension((String)file.getFileName().toString());
        Test test = new Test(name, this.defaults);
        test.setSuite(suite);
        test.setQueryFile(file.getFileName().toString());
        return test;
    }

    private void runAndSetParameters(TestSuite suite) {
        TestRunner runner = new TestRunner(this.connConfig);
        runner.createOptions = this.createOptions;
        runner.setStopOnFirstFailure(true);
        List<TestResult> results = runner.run(suite);
        List failures = results.stream().filter(r -> r.type().isFailure()).map(r -> r.test().toString()).collect(Collectors.toList());
        if (!failures.isEmpty()) {
            throw new TestDefinitionException("Failures during test generation: " + String.valueOf(failures));
        }
    }

    public static enum CreateOption {
        RESULT,
        RESULT_COUNT,
        EXPECTED_TIME;

    }
}

