/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.impl;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Change;
import com.complexible.common.base.ChangeList;
import com.complexible.common.rdf.impl.MemoryStatementSource;
import com.complexible.stardog.CommitResult;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.impl.AbstractConnection;
import com.complexible.stardog.api.impl.ChangeCollector;
import com.complexible.stardog.api.impl.ConnectionChangeType;
import com.google.common.annotations.VisibleForTesting;
import com.stardog.stark.Statement;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MixedChangeCollector
implements ChangeCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(Connection.class);
    private final int mBufferSize;
    private final ChangeList<ConnectionChangeType, Object> mNonMemoryChanges = ChangeList.create();
    private Boolean mNonMemoryAdd = null;
    private Set<Statement> mAdditions = new LinkedHashSet<Statement>();
    private Set<Statement> mRemovals = new LinkedHashSet<Statement>();
    private final AbstractConnection mConnection;

    MixedChangeCollector(AbstractConnection theConnection, int theBufferSize) {
        this.mConnection = theConnection;
        this.mBufferSize = theBufferSize;
    }

    @Override
    @VisibleForTesting
    public ChangeList<ConnectionChangeType, Object> getPendingChanges() {
        ChangeList mPendingChanges = ChangeList.create();
        mPendingChanges.appendAll(this.mNonMemoryChanges);
        if (!this.mRemovals.isEmpty()) {
            mPendingChanges.append(Change.of((Enum)ConnectionChangeType.Remove, (Object)MemoryStatementSource.of(this.mRemovals)));
        }
        if (!this.mAdditions.isEmpty()) {
            mPendingChanges.append(Change.of((Enum)ConnectionChangeType.Add, (Object)MemoryStatementSource.of(this.mAdditions)));
        }
        return mPendingChanges;
    }

    @Override
    public void cleanupPendingChanges(boolean theClosePending) {
        if (theClosePending) {
            AutoCloser.close(this.mNonMemoryChanges);
        }
        this.mNonMemoryChanges.clear();
        this.mNonMemoryAdd = null;
        this.mRemovals = new LinkedHashSet<Statement>();
        this.mAdditions = new LinkedHashSet<Statement>();
    }

    @Override
    public final void pushOutstandingIfNecessary() throws StardogException {
        if (this.mAdditions.size() + this.mRemovals.size() > this.mBufferSize || this.mNonMemoryChanges.size() > this.mBufferSize) {
            this.pushOutstanding(false);
        }
    }

    @Override
    public final CommitResult pushOutstanding(boolean doCommit) throws StardogException {
        if (!this.mRemovals.isEmpty()) {
            this.mNonMemoryChanges.append(Change.of((Enum)ConnectionChangeType.Remove, (Object)MemoryStatementSource.of(this.mRemovals)));
        }
        if (!this.mAdditions.isEmpty()) {
            this.mNonMemoryChanges.append(Change.of((Enum)ConnectionChangeType.Add, (Object)MemoryStatementSource.of(this.mAdditions)));
        }
        CommitResult aResult = null;
        if (!this.mNonMemoryChanges.isEmpty()) {
            LOGGER.debug("Pushing outstanding changes to index: {} statement sources, {} additions, {} removals", new Object[]{this.mNonMemoryChanges.size(), this.mAdditions.size(), this.mRemovals.size()});
            try {
                aResult = this.mConnection.applyChanges(this.mNonMemoryChanges, doCommit);
            }
            finally {
                this.cleanupPendingChanges(false);
            }
            LOGGER.debug("Index sync complete");
        } else if (doCommit) {
            aResult = this.mConnection._commit();
        }
        return aResult;
    }

    public final void pushNonMemoryChangesIfNecessary(ConnectionChangeType theChangeType) throws StardogException {
        if (this.mNonMemoryAdd != null && this.mNonMemoryAdd.booleanValue() != theChangeType.isAdd()) {
            this.pushNonMemoryChanges();
        }
    }

    private void pushNonMemoryChanges() {
        this.mConnection.applyChanges(this.mNonMemoryChanges, false);
        this.mNonMemoryChanges.clear();
        this.mNonMemoryAdd = null;
    }

    @Override
    public void apply(ConnectionChangeType theChangeType, Statement theChange) throws StardogException {
        assert (theChangeType == ConnectionChangeType.Add || theChangeType == ConnectionChangeType.Remove);
        this.pushNonMemoryChangesIfNecessary(theChangeType);
        if (theChangeType.isAdd()) {
            this.mRemovals.remove(theChange);
            this.mAdditions.add(theChange);
        } else {
            this.mAdditions.remove(theChange);
            this.mRemovals.add(theChange);
        }
        this.pushOutstandingIfNecessary();
    }

    @Override
    public void apply(ConnectionChangeType theChangeType, Collection<Statement> theChange) throws StardogException {
        assert (theChangeType == ConnectionChangeType.Add || theChangeType == ConnectionChangeType.Remove);
        this.pushNonMemoryChangesIfNecessary(theChangeType);
        long aSize = theChange.size();
        if (aSize > (long)this.mBufferSize) {
            this.mNonMemoryChanges.append(Change.of((Enum)theChangeType, (Object)MemoryStatementSource.of(theChange)));
            this.pushNonMemoryChanges();
            return;
        }
        if (theChangeType.isAdd()) {
            this.mRemovals.removeAll(theChange);
            this.mAdditions.addAll(theChange);
        } else {
            this.mAdditions.removeAll(theChange);
            this.mRemovals.addAll(theChange);
        }
        this.pushOutstandingIfNecessary();
    }

    @Override
    public void apply(Change<ConnectionChangeType, Object> theChange) throws StardogException {
        boolean aPushOutstanding;
        ConnectionChangeType aChangeType = (ConnectionChangeType)theChange.getChangeType();
        boolean bl = aPushOutstanding = aChangeType.isAdd() && !this.mRemovals.isEmpty() || aChangeType.isRemove() && !this.mAdditions.isEmpty();
        if (aPushOutstanding) {
            this.pushOutstanding(false);
        } else {
            this.pushNonMemoryChangesIfNecessary(aChangeType);
        }
        this.mNonMemoryChanges.append(theChange);
        this.mNonMemoryAdd = aChangeType.isAdd();
    }
}

