/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.impl;

import com.complexible.common.rdf.StatementSource;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.IO;
import com.complexible.stardog.api.impl.AbstractConnection;
import com.google.common.base.Preconditions;
import com.stardog.stark.Resource;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;

final class IOImpl
implements IO {
    private Resource mBase = null;
    private RDFFormat mFormat;
    private boolean mServerSide = false;
    private final AbstractConnection mConn;
    private final IOListener mChanges;

    IOImpl(AbstractConnection theConn, IOListener theDataHandler) {
        this.mConn = theConn;
        this.mChanges = theDataHandler;
    }

    @Override
    public IO format(RDFFormat theFormat) throws StardogException {
        this.assertOpenConnection();
        this.mFormat = theFormat;
        return this;
    }

    @Override
    public IO stream(InputStream theStream) throws StardogException {
        this.assertOpenConnection();
        this.assertFormat();
        try {
            StatementSource aSrc = this.mConn.statementSourceCreator().create(this.mFormat, theStream, this.mBase);
            this.mChanges.processChange(aSrc);
            return this;
        }
        catch (Exception e) {
            throw new StardogException((Throwable)e);
        }
    }

    @Override
    public IO context(Resource theBase) {
        this.mBase = theBase;
        return this;
    }

    @Override
    public IO file(Path theFile) throws StardogException {
        this.assertOpenConnection();
        RDFFormat aFormat = this.mFormat;
        if (aFormat == null) {
            aFormat = RDFFormats.forFile((File)theFile.toFile(), (RDFFormat)aFormat);
        }
        try {
            if (this.isServerSide()) {
                this.mChanges.processChange(this.mConn.statementSourceCreator().createRef(aFormat, theFile.toFile(), this.mBase));
            } else if (theFile.toFile().isFile()) {
                Preconditions.checkNotNull((Object)aFormat, (Object)("No format specified for " + String.valueOf(theFile)));
                this.mChanges.processChange(this.mConn.statementSourceCreator().create(aFormat, theFile.toFile(), this.mBase));
            } else {
                try (Stream<Path> files = Files.list(theFile);){
                    files.filter(aFile -> this.mFormat != null || RDFFormats.forFile((Path)aFile).isPresent()).forEach(this::file);
                }
            }
            return this;
        }
        catch (IOException e) {
            throw new StardogException((Throwable)e);
        }
    }

    private boolean isServerSide() {
        try {
            return this.mServerSide;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public IO serverSide() {
        this.mServerSide = true;
        return this;
    }

    private void assertOpenConnection() throws StardogException {
        if (!this.mConn.isOpen()) {
            throw new IllegalStateException("Cannot complete IO operation, parent connection has been closed");
        }
    }

    private void assertFormat() throws StardogException {
        if (this.mFormat == null) {
            throw new StardogException("Cannot complete IO operation, no RDF format for IO has been specified");
        }
    }

    static interface IOListener {
        public void processChange(StatementSource var1) throws StardogException;
    }
}

