/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.impl;

import com.complexible.stardog.Contexts;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.Getter;
import com.complexible.stardog.api.GraphQuery;
import com.complexible.stardog.api.ReadQuery;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.query.GraphQueryResult;
import com.stardog.stark.query.sparql.SPARQL;
import java.util.stream.Stream;

public final class GetterImpl
implements Getter {
    private static final String QUERY_GRAPHS = String.format("construct { graph ?g { ?s ?p ?o }}\nfrom named %s where {\ngraph ?g { ?s ?p ?o }}", SPARQL.toQueryString((Value)Contexts.LOCAL));
    protected Connection mConnection;
    protected Resource mSubject;
    protected IRI mPredicate;
    protected Value mObject;
    protected Resource mContext;
    protected boolean mReasoningEnabled;

    public GetterImpl(Connection theConn) throws StardogException {
        this.mConnection = theConn;
        this.mReasoningEnabled = this.mConnection.isReasoningEnabled();
    }

    @Override
    public Getter subject(Resource theRes) {
        this.mSubject = theRes;
        return this;
    }

    @Override
    public Getter predicate(IRI theURI) {
        this.mPredicate = theURI;
        return this;
    }

    @Override
    public Getter object(Value theObj) {
        this.mObject = theObj;
        return this;
    }

    @Override
    public Getter context(Resource theContext) {
        this.mContext = theContext;
        return this;
    }

    @Override
    public Stream<Statement> statements(Resource theSubj, IRI thePredicate, Value theObj, Resource theContext) throws StardogException {
        this.mSubject = theSubj;
        this.mPredicate = thePredicate;
        this.mObject = theObj;
        this.mContext = theContext;
        return this.statements();
    }

    @Override
    public boolean ask() throws StardogException {
        this.assertOpen();
        try (Stream<Statement> aIter = this.statements();){
            boolean bl = aIter.findFirst().isPresent();
            return bl;
        }
    }

    @Override
    public boolean ask(Statement theStatement) throws StardogException {
        return this.subject(theStatement.subject()).predicate(theStatement.predicate()).object(theStatement.object()).context(theStatement.context()).ask();
    }

    @Override
    public Stream<Statement> statements() throws StardogException {
        this.assertOpen();
        if (this.mContext != null && Contexts.isAllOrLocal((Resource)this.mContext)) {
            GraphQueryResult aResult = this.execute(this.bindVariables(this.mConnection.graph(QUERY_GRAPHS)));
            return (Stream)aResult.stream().onClose(() -> ((GraphQueryResult)aResult).close());
        }
        StringBuilder aQueryBuffer = new StringBuilder("construct { ?s ?p ?o } where { ");
        boolean needsGraphClose = false;
        if (this.mContext != null && !this.mContext.equals((Object)Contexts.DEFAULT)) {
            needsGraphClose = true;
            aQueryBuffer.append(" graph ").append(SPARQL.toQueryString((Value)this.mContext)).append(" {\n");
        }
        aQueryBuffer.append(" ?s ?p ?o ");
        aQueryBuffer.append(" } ");
        if (needsGraphClose) {
            aQueryBuffer.append("}");
        }
        GraphQueryResult aResult = this.execute(this.bindVariables(this.mConnection.graph(aQueryBuffer.toString())));
        Stream<Statement> aStream = (Stream<Statement>)aResult.stream().onClose(() -> ((GraphQueryResult)aResult).close());
        Resource aContext = this.mContext;
        if (!Contexts.DEFAULT.equals((Object)aContext)) {
            aStream = aStream.map(theStmt -> Values.statement((Resource)theStmt.subject(), (IRI)theStmt.predicate(), (Value)theStmt.object(), (Resource)aContext));
        }
        return aStream;
    }

    private GraphQuery bindVariables(GraphQuery theQuery) {
        if (this.mSubject != null) {
            theQuery.parameter("s", (Value)this.mSubject);
        }
        if (this.mPredicate != null) {
            theQuery.parameter("p", (Value)this.mPredicate);
        }
        if (this.mObject != null) {
            theQuery.parameter("o", this.mObject);
        }
        return theQuery;
    }

    private <T> T execute(ReadQuery<T> theQuery) throws StardogException {
        return theQuery.reasoning(this.mReasoningEnabled).execute();
    }

    @Override
    public Getter reasoning(boolean theReasoningFlag) {
        this.mReasoningEnabled = theReasoningFlag;
        return this;
    }

    @Override
    public void reset() throws StardogException {
        this.assertOpen();
        this.mSubject = null;
        this.mPredicate = null;
        this.mObject = null;
        this.mContext = null;
        this.mReasoningEnabled = false;
    }

    protected void assertOpen() throws StardogException {
        if (!this.mConnection.isOpen()) {
            throw new IllegalStateException("Operation cannot be performed, connection is not open");
        }
    }
}

