/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.NamespacesInfo;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.db.DatabaseOptions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.stardog.stark.Namespace;
import com.stardog.stark.Values;
import java.util.Collection;
import java.util.Iterator;

public final class DatabaseNamespaces
implements NamespacesInfo {
    private final AdminConnection mDBMS;
    private final String mName;
    private final Collection<Namespace> mNamespaces;

    public DatabaseNamespaces(AdminConnection theDBMS, String theName) throws StardogException {
        this.mDBMS = theDBMS;
        this.mName = theName;
        this.mNamespaces = Sets.newTreeSet((Iterable)((Iterable)this.mDBMS.get(this.mName, DatabaseOptions.NAMESPACES)));
    }

    public String getName() {
        return this.mName;
    }

    public Iterator<Namespace> iterator() {
        return this.mNamespaces.iterator();
    }

    private boolean removeLocal(String thePrefix) {
        return Iterables.removeIf(this.mNamespaces, theNamespace -> theNamespace.prefix().equals(thePrefix));
    }

    @Override
    public boolean remove(String thePrefix) {
        return this.removeLocal(thePrefix) && this.commit();
    }

    private boolean addLocal(String thePrefix, String theNamespace) {
        Iterator<Namespace> i = this.mNamespaces.iterator();
        while (i.hasNext()) {
            Namespace aNamespace = i.next();
            if (!aNamespace.prefix().equals(thePrefix)) continue;
            if (aNamespace.iri().equals(theNamespace)) {
                return false;
            }
            i.remove();
            break;
        }
        this.mNamespaces.add(Values.namespace((String)thePrefix, (String)theNamespace));
        return true;
    }

    @Override
    public boolean add(Namespace theNamespace) {
        return this.addLocal(theNamespace.prefix(), theNamespace.iri()) && this.commit();
    }

    private boolean commit() {
        this.mDBMS.set(this.mName, DatabaseOptions.NAMESPACES, this.mNamespaces);
        return true;
    }
}

