/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.impl;

import com.complexible.common.base.Change;
import com.complexible.common.rdf.StatementSource;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.IO;
import com.complexible.stardog.api.impl.AbstractConnection;
import com.complexible.stardog.api.impl.ConnectionChangeType;
import com.complexible.stardog.api.impl.IOImpl;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Statements;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import java.util.Collection;

class Changer<T> {
    protected final AbstractConnection mConnection;
    private final ConnectionChangeType mChangeType;

    public Changer(AbstractConnection theConnection, ConnectionChangeType theChangeType) {
        this.mConnection = theConnection;
        this.mChangeType = theChangeType;
    }

    public T statement(Statement theStmt) throws StardogException {
        if (this.mConnection.isStrictParsing() && !Values.isValid((Value)theStmt.object())) {
            throw new StardogException(String.valueOf(theStmt.object()) + " is not a well-formed literal value.");
        }
        this.mConnection.apply(this.mChangeType, theStmt);
        return (T)this;
    }

    public T statement(Resource theSubj, IRI thePred, Value theObj, Resource ... theContexts) throws StardogException {
        if (this.mConnection.isStrictParsing() && !Values.isValid((Value)theObj)) {
            throw new StardogException(String.valueOf(theObj) + " is not a well-formed literal value.");
        }
        if (theContexts != null && theContexts.length > 0) {
            for (Resource aCxt : theContexts) {
                this.mConnection.apply(this.mChangeType, Values.statement((Resource)theSubj, (IRI)thePred, (Value)theObj, (Resource)aCxt));
            }
        } else {
            this.mConnection.apply(this.mChangeType, Values.statement((Resource)theSubj, (IRI)thePred, (Value)theObj));
        }
        return (T)this;
    }

    public T graph(Collection<Statement> theGraph, Resource ... theContexts) throws StardogException {
        this.assertOpenConnection();
        if (this.mConnection.isStrictParsing()) {
            for (Statement aStmt : theGraph) {
                if (Values.isValid((Value)aStmt.object())) continue;
                throw new StardogException(String.valueOf(aStmt.object()) + " is not a well-formed literal value.");
            }
        }
        if (theContexts != null && theContexts.length > 0) {
            for (Resource aCxt : theContexts) {
                Function aApplyContext = stmt -> (Statement)Statements.APPLY_CONTEXT.apply(stmt, aCxt);
                this.mConnection.apply(this.mChangeType, Collections2.transform(theGraph, (Function)aApplyContext));
            }
        } else {
            this.mConnection.apply(this.mChangeType, theGraph);
        }
        return (T)this;
    }

    public IO io() throws StardogException {
        this.assertOpenConnection();
        return new IOImpl(this.mConnection, new ChangesHandler());
    }

    public Connection done() throws StardogException {
        this.assertOpenConnection();
        return this.mConnection;
    }

    protected void assertOpenConnection() throws StardogException {
        if (!this.mConnection.isOpen()) {
            throw new IllegalStateException("Enclosing connection has been closed, cannot complete add operation");
        }
    }

    private class ChangesHandler
    implements IOImpl.IOListener {
        private ChangesHandler() {
        }

        @Override
        public void processChange(StatementSource theSrc) throws StardogException {
            Changer.this.mConnection.apply((Change<ConnectionChangeType, Object>)Change.of((Enum)Changer.this.mChangeType, (Object)theSrc));
        }
    }
}

