/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.impl;

import com.complexible.stardog.Contexts;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Exporter;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.stardog.stark.Resource;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public abstract class AbstractExporter
implements Exporter {
    private final Set<Resource> mContexts = Sets.newHashSet((Object[])new Resource[]{Contexts.LOCAL});
    private RDFFormat mFormat = RDFFormats.TRIG;
    private File mObfuscationConfig = null;

    protected abstract String serverExport(Set<Resource> var1, RDFFormat var2, File var3);

    protected abstract void export(Set<Resource> var1, RDFFormat var2, OutputStream var3, File var4);

    protected abstract boolean hasContexts();

    @Override
    public Exporter obfuscated(File theObfuscationConfig) {
        Preconditions.checkNotNull((Object)theObfuscationConfig);
        this.mObfuscationConfig = theObfuscationConfig;
        return this;
    }

    @Override
    public final Exporter context(Collection<Resource> theNamedGraphs) {
        Preconditions.checkNotNull(theNamedGraphs);
        this.mContexts.clear();
        if (theNamedGraphs.isEmpty()) {
            this.mContexts.add((Resource)Contexts.LOCAL);
        } else {
            this.mContexts.addAll(theNamedGraphs);
        }
        return this;
    }

    @Override
    public final Exporter context(Resource theNG, Resource ... theOtherNamedGraphs) {
        Preconditions.checkNotNull((Object)theNG);
        Preconditions.checkNotNull((Object)theOtherNamedGraphs);
        this.mContexts.clear();
        this.mContexts.add(theNG);
        Collections.addAll(this.mContexts, theOtherNamedGraphs);
        return this;
    }

    @Override
    public Exporter format(RDFFormat theFormat) {
        Preconditions.checkNotNull((Object)theFormat);
        this.mFormat = theFormat;
        return this;
    }

    @Override
    public String toServer() throws StardogException {
        this.assertFormatOk();
        return this.serverExport(this.mContexts, this.mFormat, this.mObfuscationConfig);
    }

    @Override
    public void to(OutputStream theOutput) throws StardogException {
        Preconditions.checkNotNull((Object)theOutput);
        this.assertFormatOk();
        FileFormat.Compression aCompression = RDFFormats.compressionOf((RDFFormat)this.mFormat);
        try {
            OutputStream aOutput = aCompression.compress(theOutput);
            RDFFormat aFormat = RDFFormats.baseFormat((RDFFormat)this.mFormat);
            this.export(this.mContexts, aFormat, aOutput, this.mObfuscationConfig);
        }
        catch (IOException e) {
            throw new StardogException((Throwable)e);
        }
    }

    private void assertFormatOk() throws IllegalStateException, StardogException {
        Preconditions.checkState((!this.mContexts.isEmpty() ? 1 : 0) != 0, (Object)"Cannot export to no contexts");
        boolean aFormatHasContext = RDFFormats.supportsContexts((RDFFormat)this.mFormat);
        if (aFormatHasContext) {
            return;
        }
        if (this.mContexts.size() == 1) {
            Resource aContextToExport = (Resource)Iterables.getFirst(this.mContexts, null);
            if (!Contexts.isAllOrLocal((Resource)aContextToExport)) {
                return;
            }
            boolean aDbHasContexts = this.hasContexts();
            if (aDbHasContexts) {
                throw new IllegalStateException(String.format("Cannot export as %s, it does not support contexts but the database contains one or more named graphs", this.mFormat.name()));
            }
            return;
        }
        throw new IllegalStateException(String.format("Cannot export as %s, it does not support contexts and you have specified %s contexts to export.", this.mFormat.name(), this.mContexts.size()));
    }
}

