/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.impl;

import com.complexible.common.rdf.query.SPARQLUtil;
import com.complexible.common.rdf.query.resultio.TextTableQueryResultWriter;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.ReadQuery;
import com.complexible.stardog.api.impl.AbstractConnection;
import com.complexible.stardog.api.impl.AbstractConnectionQuery;
import com.google.common.base.Preconditions;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.query.Dataset;
import java.io.InputStream;
import java.util.Map;

public abstract class AbstractConnectionReadQuery<T>
extends AbstractConnectionQuery<T>
implements ReadQuery<T> {
    private long mOffset = -1L;
    private long mLimit = -1L;

    AbstractConnectionReadQuery(AbstractConnection theConnection, String theQueryStr, String theBase) {
        super(theConnection, theQueryStr, theBase);
    }

    @Override
    public long offset() {
        return this.mOffset;
    }

    @Override
    public long limit() {
        return this.mLimit;
    }

    @Override
    public InputStream execute(FileFormat theFormat) throws StardogException {
        Preconditions.checkArgument((!theFormat.equals((Object)TextTableQueryResultWriter.FORMAT) ? 1 : 0) != 0, (Object)"Table format not supported by this function, use execute() instead");
        return this.mConn.executeReadQuery(this, theFormat);
    }

    @Override
    public ReadQuery<T> dataset(Dataset theDataset) {
        return (ReadQuery)super.dataset(theDataset);
    }

    @Override
    public ReadQuery<T> limit(long theLimit) {
        this.mLimit = theLimit;
        return this;
    }

    @Override
    public ReadQuery<T> offset(long theOffset) {
        this.mOffset = theOffset;
        return this;
    }

    @Override
    public String toString() {
        return SPARQLUtil.toQuery((String)this.mQuery, (String)this.mSchema, (long)this.mOffset, (long)this.mLimit, (Map)this.mBindings, (Dataset)this.dataset());
    }
}

