/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.impl;

import com.complexible.common.base.Options;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Query;
import com.complexible.stardog.api.impl.AbstractConnection;
import com.complexible.stardog.api.impl.AbstractQuery;

abstract class AbstractConnectionQuery<T>
extends AbstractQuery<T> {
    protected final AbstractConnection mConn;
    private long mTimeout = -1L;

    AbstractConnectionQuery(AbstractConnection theConnection, String theQueryStr, String theBase) {
        super(theQueryStr, theBase);
        this.mConn = theConnection;
        this.schema(theConnection.getSchema());
    }

    @Override
    public final String explain(Options theOptions) throws StardogException {
        this.mConn.pushOutstanding();
        return this.mConn.explain(this, theOptions);
    }

    @Override
    public Query<T> reasoning(boolean theReasoningFlag) {
        try {
            if (this.mConn.isInTransaction() && theReasoningFlag != this.mConn.isReasoningEnabled()) {
                throw new IllegalStateException("Cannot modify reasoning flag in a transaction.");
            }
            return super.reasoning(theReasoningFlag);
        }
        catch (StardogException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public long timeout() {
        return this.mTimeout;
    }

    @Override
    public Query<T> timeout(long theTimeout) {
        this.mTimeout = theTimeout;
        return this;
    }
}

