/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.impl;

import com.complexible.common.base.Change;
import com.complexible.common.base.ChangeList;
import com.complexible.common.base.Options;
import com.complexible.common.rdf.impl.StreamStatementSources;
import com.complexible.common.rdf.query.Path;
import com.complexible.common.rdf.query.PathQueryResult;
import com.complexible.common.rdf.rio.ParserConfigs;
import com.complexible.common.view.View;
import com.complexible.common.view.Views;
import com.complexible.stardog.CommitResult;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Adder;
import com.complexible.stardog.api.BooleanQuery;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.ConnectionConfiguration;
import com.complexible.stardog.api.Getter;
import com.complexible.stardog.api.GraphQuery;
import com.complexible.stardog.api.PathQuery;
import com.complexible.stardog.api.Query;
import com.complexible.stardog.api.ReadQuery;
import com.complexible.stardog.api.Remover;
import com.complexible.stardog.api.SelectPlanQuery;
import com.complexible.stardog.api.SelectQuery;
import com.complexible.stardog.api.UpdateQuery;
import com.complexible.stardog.api.impl.AdderImpl;
import com.complexible.stardog.api.impl.ChangeCollector;
import com.complexible.stardog.api.impl.ConnectionChangeType;
import com.complexible.stardog.api.impl.GetterImpl;
import com.complexible.stardog.api.impl.MixedChangeCollector;
import com.complexible.stardog.api.impl.OrderedChangeCollector;
import com.complexible.stardog.api.impl.RemoverImpl;
import com.complexible.stardog.server.UnknownTransactionException;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Statement;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.BooleanQueryResult;
import com.stardog.stark.query.GraphQueryResult;
import com.stardog.stark.query.QueryResult;
import com.stardog.stark.query.QueryResults;
import com.stardog.stark.query.SelectQueryResult;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnection
implements Connection {
    protected static final Logger LOGGER = LoggerFactory.getLogger(Connection.class);
    private final Collection<QueryResult<?>> mOpenQueryResults = Collections.synchronizedSet(Sets.newHashSet());
    private final StreamStatementSources.StatementSourceCreator mStreamSourceCreator;
    private boolean mOpen = true;
    private boolean mInTx = false;
    private final String mSchema;
    protected final ChangeCollector mCollector;
    protected final Views<Connection> mConnectionViews;
    private final String mDb;

    protected AbstractConnection(String theDb, Views<Connection> theConnectionViews, Options theOptions, StreamStatementSources.StatementSourceCreator theStreamSourceCreatorSupplier) {
        this.mDb = theDb;
        this.mConnectionViews = theConnectionViews;
        this.mStreamSourceCreator = theStreamSourceCreatorSupplier;
        this.mInTx = theOptions.get(ConnectionConfiguration.TX) != null;
        String aSchema = (String)theOptions.get(ConnectionConfiguration.REASONING_SCHEMA);
        if (aSchema == null && theOptions.is(ConnectionConfiguration.REASONING_ENABLED)) {
            aSchema = "default";
        }
        this.mSchema = aSchema;
        int aBufferSize = (Integer)theOptions.get(ConnectionConfiguration.CLIENT_BUFFER_SIZE);
        this.mCollector = theOptions.is(ConnectionConfiguration.OPTIMIZE_MIXED_UPDATES) ? new MixedChangeCollector(this, aBufferSize) : new OrderedChangeCollector(this, aBufferSize);
    }

    @Override
    public String getSchema() {
        return this.mSchema;
    }

    @Override
    public boolean isReasoningEnabled() throws StardogException {
        return this.mSchema != null;
    }

    public StreamStatementSources.StatementSourceCreator statementSourceCreator() {
        return this.mStreamSourceCreator;
    }

    protected static Options getDefaultParserConfig(Options theOptions) {
        return ParserConfigs.create((Options)theOptions);
    }

    protected abstract boolean isStrictParsing();

    protected final void assertOpen() {
        if (!this.mOpen) {
            throw new IllegalStateException("Cannot perform operations on an closed connection");
        }
    }

    @Override
    public String name() {
        return this.mDb;
    }

    @Override
    public final <T extends Connection> T as(Class<T> theView) throws StardogException {
        this.assertOpen();
        if (theView.isInstance(this)) {
            return (T)this;
        }
        try {
            return (T)((Connection)this.mConnectionViews.as((Object)this, theView));
        }
        catch (View.ViewException e) {
            throw new StardogException(String.format("Could not find an appropriate view implementation of this connection for '%s'.", theView.getName()));
        }
    }

    @Override
    public final void close() throws StardogException {
        this.close(true);
    }

    public final void close(boolean isRollback) throws StardogException {
        if (this.mInTx) {
            if (isRollback) {
                this.rollback();
            } else {
                this.pushOutstanding();
                this.cleanupTx(true);
            }
        }
        if (this.mOpen) {
            try {
                this._close();
            }
            finally {
                this.mOpen = false;
                this.mOpenQueryResults.forEach(QueryResults::closeQuietly);
            }
        }
    }

    @Override
    public UUID begin() throws StardogException {
        LOGGER.debug("Begin transaction");
        this.assertOpen();
        this.assertNotInTransaction();
        UUID aTxId = this._begin();
        this.mInTx = true;
        return aTxId;
    }

    @Override
    public final void rollback() throws StardogException {
        this.assertOpen();
        if (!this.mInTx) {
            return;
        }
        try {
            this._rollback();
        }
        catch (UnknownTransactionException unknownTransactionException) {
        }
        finally {
            this.cleanupTx(true);
        }
    }

    @Override
    public final CommitResult commit() throws StardogException {
        this.assertOpen();
        this.assertInTransaction();
        try {
            CommitResult commitResult = this.pushOutstandingAndCommit();
            return commitResult;
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
        finally {
            this.cleanupTx(true);
        }
    }

    protected void cleanupTx(boolean theClose) {
        this.mInTx = false;
        this.cleanupPendingChanges(theClose);
    }

    protected abstract UUID _begin() throws StardogException;

    protected abstract CommitResult _commit() throws StardogException;

    protected abstract void _rollback() throws StardogException;

    protected abstract void _close() throws StardogException;

    @Override
    public boolean isOpen() throws IllegalStateException {
        return this.mOpen;
    }

    protected final boolean isInTransaction() {
        return this.mInTx;
    }

    protected final void assertInTransaction() throws StardogException {
        if (!this.isInTransaction()) {
            throw new StardogException("Unable to complete operation, a transaction has not been initiated.");
        }
    }

    protected final void assertNotInTransaction() throws StardogException {
        if (this.isInTransaction()) {
            throw new StardogException("A transaction is already open");
        }
    }

    public void pushOutstanding() throws StardogException {
        if (this.mInTx) {
            this.mCollector.pushOutstanding(false);
        }
    }

    protected final CommitResult pushOutstandingAndCommit() throws StardogException {
        Preconditions.checkState((boolean)this.mInTx, (Object)"Not in a transaction");
        return this.mCollector.pushOutstanding(true);
    }

    protected void cleanupPendingChanges(boolean theClosePending) {
        this.mCollector.cleanupPendingChanges(theClosePending);
    }

    final void apply(ConnectionChangeType theChangeType, Statement theChange) throws StardogException {
        if (!this.isInTransaction()) {
            throw new StardogException("Unable to complete operation, a transaction has not been initiated.");
        }
        try {
            this.mCollector.apply(theChangeType, theChange);
        }
        catch (Exception e) {
            this.cleanupTx(true);
            Throwables.propagateIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    final void apply(ConnectionChangeType theChangeType, Collection<Statement> theChange) throws StardogException {
        if (!this.isInTransaction()) {
            throw new StardogException("Unable to complete operation, a transaction has not been initiated.");
        }
        try {
            this.mCollector.apply(theChangeType, theChange);
        }
        catch (Exception e) {
            this.cleanupTx(true);
            Throwables.propagateIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    final void apply(Change<ConnectionChangeType, Object> theChange) throws StardogException {
        if (!this.isInTransaction()) {
            throw new StardogException("Unable to complete operation, a transaction has not been initiated.");
        }
        try {
            this.mCollector.apply(theChange);
        }
        catch (Exception e) {
            this.cleanupTx(true);
            Throwables.propagateIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    protected abstract CommitResult applyChanges(ChangeList<ConnectionChangeType, Object> var1, boolean var2) throws StardogException;

    private <T, R extends QueryResult<T>> R trackQueryResult(R result) {
        this.mOpenQueryResults.add(result);
        return result;
    }

    private void untrackQueryResult(QueryResult<?> result) {
        this.mOpenQueryResults.remove(result);
    }

    protected final SelectQueryResult executeSelect(SelectQuery theSelectQuery) {
        this.assertOpen();
        this.pushOutstanding();
        return new ConnectionTupleQueryResult(this.trackQueryResult(this._select(theSelectQuery)), this);
    }

    protected final SelectQueryResult executeSelectPlan(SelectPlanQuery theSelectPlanQuery) {
        this.assertOpen();
        this.pushOutstanding();
        return new ConnectionTupleQueryResult(this.trackQueryResult(this._selectPlan(theSelectPlanQuery)), this);
    }

    protected final GraphQueryResult executeGraph(GraphQuery theQuery) {
        this.assertOpen();
        this.pushOutstanding();
        return new ConnectionGraphQueryResult(this.trackQueryResult(this._graph(theQuery)), this);
    }

    final PathQueryResult executePaths(PathQuery theQuery) {
        this.assertOpen();
        this.pushOutstanding();
        return new ConnectionPathsQueryResult(this.trackQueryResult(this._paths(theQuery)), this);
    }

    protected final BooleanQueryResult executeAsk(BooleanQuery theQuery) {
        this.assertOpen();
        this.pushOutstanding();
        return new ConnectionBooleanQueryResult(this.trackQueryResult(this._ask(theQuery)), this);
    }

    protected final InputStream executeReadQuery(ReadQuery<?> theQuery, FileFormat theFormat) {
        this.assertOpen();
        this.pushOutstanding();
        return this._read(theQuery, theFormat);
    }

    protected final void executeUpdate(UpdateQuery theQuery) {
        this.assertOpen();
        this.pushOutstanding();
        this._update(theQuery);
    }

    protected abstract SelectQueryResult _select(SelectQuery var1);

    protected abstract SelectQueryResult _selectPlan(SelectPlanQuery var1);

    protected abstract GraphQueryResult _graph(GraphQuery var1);

    protected abstract BooleanQueryResult _ask(BooleanQuery var1);

    protected abstract PathQueryResult _paths(PathQuery var1);

    protected abstract InputStream _read(ReadQuery<?> var1, FileFormat var2);

    protected abstract void _update(UpdateQuery var1);

    protected abstract String explain(Query<?> var1, Options var2);

    protected String explain(Query<?> theQuery) {
        return this.explain(theQuery, Options.empty());
    }

    @Override
    public final SelectQuery select(String theQuery) throws StardogException {
        return this.select(theQuery, "tag:stardog:api:");
    }

    @Override
    public final SelectPlanQuery selectPlan(String theQuery) throws StardogException {
        return this.selectPlan(theQuery, "tag:stardog:api:");
    }

    @Override
    public final GraphQuery graph(String theQuery) throws StardogException {
        return this.graph(theQuery, "tag:stardog:api:");
    }

    @Override
    public final PathQuery paths(String theQuery) throws StardogException {
        return this.paths(theQuery, "tag:stardog:api:");
    }

    @Override
    public final BooleanQuery ask(String theQuery) throws StardogException {
        return this.ask(theQuery, "tag:stardog:api:");
    }

    @Override
    public final UpdateQuery update(String theQuery) throws StardogException {
        return this.update(theQuery, "tag:stardog:api:");
    }

    @Override
    public final Adder add() throws StardogException {
        this.assertOpen();
        return new AdderImpl(this);
    }

    @Override
    public final Remover remove() throws StardogException {
        this.assertOpen();
        return new RemoverImpl(this);
    }

    @Override
    public final Getter get() throws StardogException {
        this.assertOpen();
        return new GetterImpl(this);
    }

    private static class ConnectionTupleQueryResult
    extends ConnectionQueryResult<BindingSet>
    implements SelectQueryResult {
        protected ConnectionTupleQueryResult(SelectQueryResult theResult, AbstractConnection theConnection) {
            super(theResult, theConnection);
        }

        @Nonnull
        public List<String> variables() {
            this.assertOpen();
            return ((SelectQueryResult)this.mResult).variables();
        }
    }

    private static class ConnectionGraphQueryResult
    extends ConnectionQueryResult<Statement>
    implements GraphQueryResult {
        protected ConnectionGraphQueryResult(GraphQueryResult theResult, AbstractConnection theConnection) {
            super(theResult, theConnection);
        }

        @Nonnull
        public Namespaces namespaces() {
            this.assertOpen();
            return ((GraphQueryResult)this.mResult).namespaces();
        }
    }

    private static class ConnectionPathsQueryResult
    extends ConnectionQueryResult<Path>
    implements PathQueryResult {
        ConnectionPathsQueryResult(PathQueryResult theResult, AbstractConnection theConnection) {
            super(theResult, theConnection);
        }

        @Nonnull
        public List<String> getPathStartVariableNames() {
            return ((PathQueryResult)this.mResult).getPathStartVariableNames();
        }

        public List<String> getPathEndVariableNames() {
            return ((PathQueryResult)this.mResult).getPathEndVariableNames();
        }

        public List<String> getEdgeVariableNames() {
            return ((PathQueryResult)this.mResult).getEdgeVariableNames();
        }
    }

    private static class ConnectionBooleanQueryResult
    extends ConnectionQueryResult<Boolean>
    implements BooleanQueryResult {
        protected ConnectionBooleanQueryResult(BooleanQueryResult theResult, AbstractConnection theConnection) {
            super(theResult, theConnection);
        }
    }

    private static class OnCloseQueryResult<T>
    implements QueryResult<T> {
        protected final QueryResult<T> mResult;
        private final Runnable mOnClose;

        public OnCloseQueryResult(QueryResult<T> theResult, Runnable theOnClose) {
            this.mResult = theResult;
            this.mOnClose = theOnClose;
        }

        public final void close() {
            try {
                this.mResult.close();
            }
            finally {
                this.mOnClose.run();
            }
        }

        public boolean hasNext() {
            return this.mResult.hasNext();
        }

        public T next() {
            return (T)this.mResult.next();
        }

        public void remove() {
            this.mResult.remove();
        }
    }

    private static class ConnectionQueryResult<T>
    extends OnCloseQueryResult<T> {
        protected final AbstractConnection mConn;

        protected ConnectionQueryResult(QueryResult<T> theResult, AbstractConnection theConnection) {
            super(theResult, () -> theConnection.untrackQueryResult(theResult));
            this.mConn = theConnection;
        }

        protected void assertOpen() {
            if (!this.mConn.isOpen()) {
                throw new IllegalStateException("Cannot perform operations on an closed connection");
            }
        }

        @Override
        public final boolean hasNext() {
            this.assertOpen();
            return super.hasNext();
        }

        @Override
        public final T next() {
            this.assertOpen();
            return super.next();
        }

        @Override
        public final void remove() {
            this.assertOpen();
            super.remove();
        }
    }
}

