/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.admin;

import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.complexible.stardog.QueryManager;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.StoredFunctions;
import com.complexible.stardog.StoredQueries;
import com.complexible.stardog.api.admin.DatabaseBuilder;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.metadata.Metadata;
import com.complexible.stardog.metrics.MetricOptions;
import com.complexible.stardog.process.ProcessManager;
import com.complexible.stardog.security.PermissionManager;
import com.complexible.stardog.security.RoleManager;
import com.complexible.stardog.security.StardogSecurityException;
import com.complexible.stardog.security.TokenManager;
import com.complexible.stardog.security.UserManager;
import com.complexible.stardog.util.report.DiagnosticsReport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public interface AdminConnection
extends AutoCloseable {
    public static final long NO_TIMEOUT = Long.MAX_VALUE;

    public <T extends AdminConnection> T as(Class<T> var1) throws StardogException;

    @Override
    public void close() throws StardogException;

    public boolean isOpen() throws StardogException;

    @Deprecated
    public DatabaseBuilder builder(Metadata var1) throws StardogException;

    @Deprecated
    public DatabaseBuilder disk(String var1) throws StardogException;

    public DatabaseBuilder newDatabase(String var1) throws StardogException;

    public void renameDatabase(String var1, String var2) throws StardogException;

    public Metadata get(String var1, Iterable<? extends MetaProperty<?>> var2) throws StardogException;

    public <T> T get(String var1, MetaProperty<T> var2) throws StardogException;

    public <T> String set(String var1, MetaProperty<T> var2, T var3) throws StardogException;

    public Metadata getProperty(Collection<String> var1) throws StardogException;

    public String setProperty(String var1, String var2) throws StardogException;

    public String offline(String var1, long var2, TimeUnit var4) throws StardogException;

    public String offline(String var1) throws StardogException;

    public String online(String var1) throws StardogException;

    default public String optimize(String theName) throws StardogException {
        return this.optimize(theName, Metadata.empty());
    }

    public String optimize(String var1, Metadata var2) throws StardogException;

    public Collection<String> list() throws StardogException;

    public String repair(String var1) throws StardogException;

    public void shutdown() throws StardogSecurityException;

    public String drop(String var1) throws StardogException;

    @Deprecated
    default public String backup(String theDatabase) throws StardogException {
        return this.backup(theDatabase, Optional.empty(), Options.empty());
    }

    @Deprecated
    default public String backup(String theDatabase, File theLocation) throws StardogException {
        return this.backup(theDatabase, Optional.of(theLocation.toURI().toString()), Options.empty());
    }

    @Deprecated
    default public String backup(String theDatabase, String theBackupUrl) throws StardogException {
        return this.backup(theDatabase, Optional.of(theBackupUrl), Options.empty());
    }

    public String backup(String var1, Optional<String> var2, Options var3) throws StardogException;

    public String backupAll(Options var1) throws StardogException;

    public String restore(File var1, boolean var2, String var3) throws StardogException;

    public String restore(String var1, boolean var2, String var3) throws StardogException;

    public Collection<String> checkpoint(String var1, Options var2) throws StardogException;

    public UserManager getUserManager();

    public RoleManager getRoleManager();

    public PermissionManager getPermissionManager();

    public QueryManager getQueryManager();

    public ProcessManager getProcessManager();

    public TokenManager getTokenManager();

    @Deprecated
    default public Map<String, Object> currentStatus(boolean theIncludeDbStatus) throws StardogException {
        return this.currentStatus(Options.of((Option)MetricOptions.DATABASES, (Object)theIncludeDbStatus));
    }

    public Map<String, Object> currentStatus(Options var1) throws StardogException;

    public StoredQueries getStoredQueries();

    public StoredFunctions getStoredFunctions();

    public String verify(String var1);

    public String whoami();

    public File generateDiagnosticReport(DiagnosticsReport var1);

    public Path getLogs(Options var1);

    public void transactionLog(String var1, TxLogRange var2, StreamConsumer var3);

    public String replayTransactionLog(String var1, Path var2, boolean var3);

    public static class TxLogRange {
        public final UUID startTxId;
        public final UUID endTxId;
        public final Instant startDate;
        public final Instant endDate;

        private TxLogRange(Builder builder) {
            this.startTxId = builder.startTxId;
            this.endTxId = builder.endTxId;
            this.startDate = builder.startDate;
            this.endDate = builder.endDate;
        }

        public static TxLogRange all() {
            return new Builder().build();
        }

        public static TxLogRange range(UUID start, UUID end) {
            return new Builder().start(start).end(end).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private UUID startTxId;
            private UUID endTxId;
            private Instant startDate = Instant.MIN;
            private Instant endDate = Instant.MAX;

            public Builder start(UUID startTxId) {
                this.startTxId = startTxId;
                return this;
            }

            public Builder end(UUID endTxId) {
                this.endTxId = endTxId;
                return this;
            }

            public Builder startDate(Instant startDate) {
                this.startDate = startDate;
                return this;
            }

            public Builder endDate(Instant endDate) {
                this.endDate = endDate;
                return this;
            }

            public TxLogRange build() {
                return new TxLogRange(this);
            }
        }
    }

    public static interface StreamConsumer {
        public void accept(InputStream var1) throws IOException;
    }
}

