/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.admin;

import com.complexible.common.view.View;
import com.complexible.common.view.Views;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.api.admin.DatabaseBuilder;
import com.complexible.stardog.db.DatabaseOptions;
import com.complexible.stardog.index.IndexOptions;
import com.complexible.stardog.metadata.MetaProperties;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.metadata.Metadata;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.Collections;
import java.util.concurrent.TimeUnit;

public abstract class AbstractAdminConnection
implements AdminConnection {
    private boolean mIsOpen = true;
    private final Views<AdminConnection> mViews;

    public AbstractAdminConnection(Views<AdminConnection> theViews) {
        this.mViews = theViews;
    }

    protected abstract void _close();

    protected abstract DatabaseBuilder newDatabaseBuilder();

    protected abstract <T> String _set(String var1, MetaProperty<T> var2, T var3) throws StardogException;

    protected abstract Metadata _get(String var1, Iterable<? extends MetaProperty<?>> var2) throws StardogException;

    @Override
    public DatabaseBuilder disk(String theName) throws StardogException {
        return this.newDatabase(theName);
    }

    @Override
    public DatabaseBuilder builder(Metadata theOptions) throws StardogException {
        return this.newDatabase((String)theOptions.get((MetaProperty)DatabaseOptions.NAME)).setAll(theOptions);
    }

    @Override
    public final void close() {
        if (!this.mIsOpen) {
            return;
        }
        this.mIsOpen = false;
        this._close();
    }

    @Override
    public final <T extends AdminConnection> T as(Class<T> theView) throws StardogException {
        try {
            return (T)((AdminConnection)this.mViews.as((Object)this, theView));
        }
        catch (View.ViewException e) {
            throw new StardogException(e.getMessage());
        }
    }

    @Override
    public final boolean isOpen() {
        return this.mIsOpen;
    }

    @Override
    public final DatabaseBuilder newDatabase(String theName) throws StardogException {
        this.assertOpen();
        this.assertValidName(theName);
        return this.newDatabaseBuilder().set(IndexOptions.INDEX_TYPE, IndexOptions.IndexType.Disk).set(DatabaseOptions.NAME, theName);
    }

    @Override
    public <T> T get(String theName, MetaProperty<T> theOption) throws StardogException {
        Metadata aOptions = this.get(theName, Collections.singleton(theOption));
        return (T)(aOptions.contains(theOption) ? aOptions.get(theOption) : null);
    }

    @Override
    public final Metadata get(String theName, Iterable<? extends MetaProperty<?>> theOptions) throws StardogException {
        try {
            for (MetaProperty<?> mp : theOptions) {
                if (mp != null) continue;
                throw new StardogException("Invalid option");
            }
            return this._get(theName, theOptions);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, StardogException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public final <T> String set(String theName, MetaProperty<T> theOption, T theValue) throws StardogException {
        if (!MetaProperties.contains(theOption)) {
            throw new StardogException("Unrecognized option: " + String.valueOf(theOption));
        }
        return this._set(theName, theOption, theValue);
    }

    @Override
    public String offline(String theName) throws StardogException {
        return this.offline(theName, DatabaseOptions.DEFAULT_OFFLINE_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    protected void assertOpen() {
        Preconditions.checkState((boolean)this.mIsOpen, (Object)"Cannot perform operation on a closed client");
    }

    protected void assertValidName(String theName) throws StardogException {
        if (theName == null) {
            throw new StardogException("No name specified for database, cannot create");
        }
    }
}

