/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api;

import com.complexible.common.base.Options;
import com.complexible.common.util.ServiceLoaders;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.Driver;
import com.complexible.stardog.api.DriverModule;
import com.complexible.stardog.api.DriversProvider;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import java.util.HashSet;
import java.util.Map;

public final class DriverManager {
    private static final DriverManager INSTANCE = new DriverManager();
    private final Map<Class, Driver> mDrivers = Maps.newHashMap();

    public static DriverManager getInstance() {
        return INSTANCE;
    }

    DriverManager() {
        HashSet drivers = Sets.newHashSet(((DriversProvider)Guice.createInjector((Iterable)ServiceLoaders.instancesOf(DriverModule.class)).getInstance(DriversProvider.class)).get());
        drivers.forEach(this::register);
    }

    public void register(Driver theDriver) {
        if (theDriver != null) {
            this.mDrivers.put(theDriver.getClass(), theDriver);
        }
    }

    public Driver getDriver(String theURL) throws StardogException {
        for (Driver aDriver : this.mDrivers.values()) {
            if (!aDriver.acceptsURL(theURL)) continue;
            return aDriver;
        }
        throw new StardogException(String.format("No driver was found which supports the connection string: '%s', please double-check the URL and verify the protocol is correct and try again.", theURL));
    }

    public Connection getConnection(String theURL, Options theOptions) throws StardogException {
        Driver aDriver = this.getDriver(theURL);
        return aDriver.connect(theURL, theOptions);
    }
}

