/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api;

import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.ConnectionConfiguration;
import com.complexible.stardog.api.impl.PooledConnection;
import org.apache.commons.pool.PoolableObjectFactory;

final class ConnectionPoolableObjectFactory
implements PoolableObjectFactory {
    private final ConnectionConfiguration config;

    public ConnectionPoolableObjectFactory(ConnectionConfiguration theConfig) {
        this.config = theConfig;
    }

    public Object makeObject() throws Exception {
        Connection aConnection = this.config.connect();
        return new PooledConnection(aConnection);
    }

    public void destroyObject(Object o) throws Exception {
        ((Connection)o).close();
    }

    public boolean validateObject(Object o) {
        try {
            return ((Connection)o).isOpen();
        }
        catch (Throwable e) {
            return false;
        }
    }

    public void activateObject(Object o) throws Exception {
        if (o instanceof PooledConnection) {
            ((PooledConnection)o).activate();
        }
    }

    public void passivateObject(Object o) throws Exception {
        if (o instanceof PooledConnection) {
            ((PooledConnection)o).deactivate();
        } else {
            ((Connection)o).rollback();
        }
    }
}

