/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api;

import com.complexible.common.pool.ApachePoolImpl;
import com.complexible.common.pool.PoolConfig;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.ConnectionConfiguration;
import com.complexible.stardog.api.ConnectionPool;
import com.complexible.stardog.api.ConnectionPoolableObjectFactory;
import com.complexible.stardog.api.impl.DelegatingConnection;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public final class ConnectionPoolConfig
extends PoolConfig<Connection, StardogException> {
    private final ConnectionPoolableObjectFactory mFactory;

    private ConnectionPoolConfig(ConnectionConfiguration theConfig) {
        this.mFactory = new ConnectionPoolableObjectFactory(theConfig);
    }

    public static ConnectionPoolConfig using(ConnectionConfiguration theConfig) {
        return new ConnectionPoolConfig(theConfig);
    }

    public ConnectionPoolConfig maxIdle(int theMaxIdle) {
        return (ConnectionPoolConfig)super.maxIdle(theMaxIdle);
    }

    public ConnectionPoolConfig maxPool(int theMax) {
        return (ConnectionPoolConfig)super.maxPool(theMax);
    }

    public ConnectionPoolConfig minPool(int theMin) {
        return (ConnectionPoolConfig)super.minPool(theMin);
    }

    public ConnectionPoolConfig growAtCapacity() {
        return (ConnectionPoolConfig)super.growAtCapacity();
    }

    public ConnectionPoolConfig failAtCapacity() {
        return (ConnectionPoolConfig)super.failAtCapacity();
    }

    public ConnectionPoolConfig blockAtCapacity(long theTime, TimeUnit theUnit) {
        return (ConnectionPoolConfig)super.blockAtCapacity(theTime, theUnit);
    }

    public ConnectionPoolConfig noExpiration() {
        return (ConnectionPoolConfig)super.noExpiration();
    }

    public ConnectionPoolConfig expiration(long theTime, TimeUnit theUnit) {
        return (ConnectionPoolConfig)super.expiration(theTime, theUnit);
    }

    public ConnectionPool create() {
        return new ApacheConnectionPool(this.mFactory, this.mMinPool, this.mConfig);
    }

    private static final class ApacheConnectionPool
    implements ConnectionPool {
        private final ApachePoolImpl<Connection> mPool;

        public ApacheConnectionPool(ConnectionPoolableObjectFactory theFactory, int theMin, GenericObjectPool.Config theConfig) {
            this.mPool = new ApachePoolImpl((PoolableObjectFactory)theFactory, theMin, theConfig);
        }

        private PooledConnection wrapIfNecessary(Connection theConn) {
            return theConn instanceof PooledConnection ? (PooledConnection)theConn : new PooledConnection(theConn);
        }

        public Connection obtain() throws StardogException {
            try {
                return this.wrapIfNecessary((Connection)this.mPool.obtain());
            }
            catch (Exception e) {
                throw new StardogException((Throwable)e);
            }
        }

        public void shutdown() throws StardogException {
            try {
                this.mPool.shutdown();
            }
            catch (Exception e) {
                throw new StardogException((Throwable)e);
            }
        }

        public void release(Connection theObj) throws StardogException {
            try {
                this.mPool.release((Object)theObj);
            }
            catch (Exception e) {
                throw new StardogException((Throwable)e);
            }
        }

        private final class PooledConnection
        extends DelegatingConnection {
            public PooledConnection(Connection theConnection) {
                super(theConnection);
            }

            @Override
            public void close() throws StardogException {
                try {
                    ApacheConnectionPool.this.mPool.release((Object)this.getConnection());
                }
                catch (Exception e) {
                    throw new StardogException((Throwable)e);
                }
            }
        }
    }
}

