/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api;

import com.complexible.common.util.Krb5Utils;
import com.complexible.stardog.StardogException;
import com.sun.security.auth.module.Krb5LoginModule;
import java.io.File;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.KerberosCredentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionCredentials {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionCredentials.class);
    public static final String GSS_KRB5_MECH_OID = "1.2.840.113554.1.2.2";
    public static final String GSS_SPNEGO_MECH_OID = "1.3.6.1.5.5.2";
    private static GSSManager aGSSManager = GSSManager.getInstance();
    private Credentials mCredentials;
    private final String mPrincipalName;

    public ConnectionCredentials(KerberosCredentials theCredentials) {
        try {
            this.mPrincipalName = theCredentials.getGSSCredential().getName().toString();
        }
        catch (GSSException aEx) {
            throw new StardogException("Failed to get the krb5 principal name", (Throwable)aEx);
        }
        this.mCredentials = theCredentials;
    }

    public ConnectionCredentials(String theUsername, String thePassword) {
        this.mPrincipalName = theUsername;
        this.mCredentials = new UsernamePasswordCredentials(theUsername, thePassword.toCharArray());
    }

    public Credentials getHttpCredentials() {
        return this.mCredentials;
    }

    public char[] getPassword() {
        return this.mCredentials.getPassword();
    }

    public static ConnectionCredentials getKrb5Credential(Boolean theDebug) {
        KerberosCredentials aCredential = ConnectionCredentials.gerKrb5Cred(aGSSManager, theDebug);
        return new ConnectionCredentials(aCredential);
    }

    public String getSubject() {
        return this.mPrincipalName;
    }

    public static ConnectionCredentials getKrb5Credential() {
        boolean aKrb5Debug = Boolean.parseBoolean(System.getProperty("stardog.krb5.debug", "false"));
        return ConnectionCredentials.getKrb5Credential(aKrb5Debug);
    }

    public static ConnectionCredentials getKrb5Credential(Subject theSubject) {
        LOGGER.debug("Getting Krb5 credentials");
        try {
            Oid[] oid = new Oid[]{new Oid(GSS_SPNEGO_MECH_OID), new Oid(GSS_KRB5_MECH_OID)};
            KerberosCredentials aCred = Subject.doAs(theSubject, () -> {
                try {
                    GSSCredential aGSSCredential = aGSSManager.createCredential(null, Integer.MAX_VALUE, oid, 1);
                    int life = aGSSCredential.getRemainingLifetime();
                    LOGGER.info("Pack krb5 credential has {} seconds left", (Object)life);
                    KerberosCredentials aKerberosCredentials = new KerberosCredentials(aGSSCredential);
                    return aKerberosCredentials;
                }
                catch (Exception ioEx) {
                    throw new StardogException("Failed to get krb5 credentials", (Throwable)ioEx);
                }
            });
            aCred.getUserPrincipal();
            return new ConnectionCredentials(aCred);
        }
        catch (GSSException aGssEx) {
            throw new StardogException("Kerberos may not be supported on this system.", (Throwable)aGssEx);
        }
    }

    public static ConnectionCredentials createKrb5Credential(File theKeytab, boolean theDebug) {
        return ConnectionCredentials.createKrb5Credential(theKeytab, null, theDebug);
    }

    public static ConnectionCredentials createKrb5Credential(File theKeytab, @Nullable String thePrincipalName, boolean theDebug) {
        LOGGER.debug("Getting Krb5 credentials");
        try {
            LoginContext loginContext;
            if (thePrincipalName == null) {
                Configuration aKrbConf = ConnectionCredentials.getLoginConfigurationForKeytab(theKeytab, (a, b) -> true, theDebug);
                loginContext = new LoginContext("AnyKeytabEntry", new Subject(), null, aKrbConf);
            } else {
                Configuration aKrbConf = ConnectionCredentials.getLoginConfigurationForKeytab(theKeytab, String::equals, theDebug);
                loginContext = new LoginContext(thePrincipalName, new Subject(), null, aKrbConf);
            }
            loginContext.login();
            return ConnectionCredentials.getKrb5Credential(loginContext.getSubject());
        }
        catch (LoginException e) {
            throw new StardogException("Failed to establish a login context", (Throwable)e);
        }
    }

    private static Configuration getLoginConfigurationForKeytab(final File theKeytab, final BiPredicate<String, String> theEntryFilter, final boolean theDebug) {
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String theName) {
                try {
                    ArrayList aAppEntList = new ArrayList();
                    Krb5Utils.forEach((File)theKeytab, aPrincipalString -> {
                        if (theEntryFilter.test(theName, aPrincipalString)) {
                            HashMap<String, String> aOptions = new HashMap<String, String>();
                            aOptions.put("useKeyTab", "true");
                            aOptions.put("storeKey", "true");
                            aOptions.put("doNotPrompt", "true");
                            aOptions.put("isInitiator", "true");
                            aOptions.put("keyTab", theKeytab.getAbsolutePath());
                            aOptions.put("principal", (String)aPrincipalString);
                            aOptions.put("debug", String.valueOf(theDebug));
                            AppConfigurationEntry aEnt = new AppConfigurationEntry(Krb5LoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, aOptions);
                            aAppEntList.add(aEnt);
                        }
                    });
                    if (aAppEntList.isEmpty()) {
                        throw new StardogException("No entry for '" + theName + "' found in keytab file " + String.valueOf(theKeytab));
                    }
                    return aAppEntList.toArray(new AppConfigurationEntry[0]);
                }
                catch (Throwable aEx) {
                    throw new StardogException(aEx);
                }
            }
        };
    }

    public static ConnectionCredentials getUsernamePasswordCredential(String theUsername, String thePassword) {
        return new ConnectionCredentials(theUsername, thePassword);
    }

    public static KerberosCredentials gerKrb5Cred(final GSSManager theGSSManager, final boolean theDebug) {
        LOGGER.debug("Getting Krb5 client credentials gerKrb5Cred()");
        try {
            final String aContextName = ConnectionCredentials.class.getName();
            final Oid[] oid = new Oid[]{new Oid(GSS_SPNEGO_MECH_OID), new Oid(GSS_KRB5_MECH_OID)};
            Configuration aKrbConf = new Configuration(){

                @Override
                public AppConfigurationEntry[] getAppConfigurationEntry(String theName) {
                    if (!aContextName.equals(theName)) {
                        throw new StardogException(String.format("Unsupported context name %s", theName));
                    }
                    HashMap<String, String> aOptions = new HashMap<String, String>();
                    aOptions.put("client", "true");
                    aOptions.put("useTicketCache", "true");
                    aOptions.put("doNotPrompt", "true");
                    aOptions.put("debug", String.format("%b", theDebug));
                    aOptions.put("refreshKrb5Config", "true");
                    AppConfigurationEntry aEnt = new AppConfigurationEntry(Krb5LoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, aOptions);
                    return new AppConfigurationEntry[]{aEnt};
                }
            };
            LOGGER.debug("Attempting to login to JAAS for krb5");
            final Subject aSubject = new Subject();
            LoginContext mLoginContext = new LoginContext(aContextName, aSubject, null, aKrbConf);
            mLoginContext.login();
            KerberosCredentials aKerberosCredentials = Subject.doAs(aSubject, new PrivilegedAction<KerberosCredentials>(){

                @Override
                public KerberosCredentials run() {
                    LOGGER.debug("Getting KerberosCredentials as {}", (Object)aSubject.toString());
                    try {
                        GSSCredential aGSSCredential = theGSSManager.createCredential(null, Integer.MAX_VALUE, oid, 1);
                        return new KerberosCredentials(aGSSCredential);
                    }
                    catch (Exception ioEx) {
                        throw new StardogException("failed to http", (Throwable)ioEx);
                    }
                }
            });
            return aKerberosCredentials;
        }
        catch (GSSException aGssEx) {
            throw new StardogException("Kerberos may not be supported on this system.", (Throwable)aGssEx);
        }
        catch (LoginException aLoginEx) {
            throw new StardogException("Failed to acquire the krb5 credentials", (Throwable)aLoginEx);
        }
    }
}

