/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api;

import com.complexible.common.base.Copyable;
import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.complexible.common.base.Pair;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.AbstractConnectionConfiguration;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.ConnectionCredentials;
import com.complexible.stardog.api.DriverManager;
import com.complexible.stardog.server.InvalidConfigurationException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;

public final class ConnectionConfiguration
extends AbstractConnectionConfiguration<Connection>
implements Copyable<ConnectionConfiguration> {
    @Deprecated
    public static final Option<Boolean> REASONING_ENABLED = Option.create((String)"reasoning", (Object)false);
    public static final Option<String> REASONING_SCHEMA = Option.create((String)"schema", null);
    public static final Option<String> DATABASE = Option.create((String)"database");
    public static final Option<UUID> TX = Option.create((String)"tx");
    public static final Option<Integer> CLIENT_BUFFER_SIZE = Option.create((String)"buffer_size", (Object)100000);
    public static final Option<Boolean> OPTIMIZE_MIXED_UPDATES = Option.create((String)"mixed_updates", (Object)true);
    public static final Option<Boolean> EXACT_SIZE = Option.create((String)"exact_size", (Object)false);

    protected ConnectionConfiguration() {
    }

    protected ConnectionConfiguration(Options theOptions) {
        super(theOptions);
    }

    public ConnectionConfiguration copy() {
        return new ConnectionConfiguration(this.mOptions.copy());
    }

    @Override
    public ConnectionConfiguration credentials(String theUsername, String thePassword) {
        return (ConnectionConfiguration)super.credentials(theUsername, thePassword);
    }

    @Override
    public ConnectionConfiguration credentials(ConnectionCredentials theConnectionCredentials) {
        return (ConnectionConfiguration)super.credentials(theConnectionCredentials);
    }

    public ConnectionConfiguration credentialSupplier(Supplier<ConnectionCredentials> theSupplier) {
        return (ConnectionConfiguration)super.credentialSupplier(theSupplier);
    }

    @Override
    public ConnectionConfiguration server(String theServerURL) {
        return (ConnectionConfiguration)super.server(theServerURL);
    }

    @Override
    public ConnectionConfiguration runningAs(String theUsername) {
        return (ConnectionConfiguration)super.runningAs(theUsername);
    }

    public ConnectionConfiguration reasoning(boolean theReasoningFlag) {
        this.mOptions.set(REASONING_ENABLED, (Object)theReasoningFlag);
        if (!theReasoningFlag) {
            this.mOptions.remove(REASONING_SCHEMA);
        }
        return this;
    }

    public ConnectionConfiguration schema(String theSchema) {
        if (theSchema == null) {
            this.mOptions.remove(REASONING_SCHEMA);
        } else {
            this.mOptions.set(REASONING_SCHEMA, (Object)theSchema);
        }
        return this;
    }

    public ConnectionConfiguration exactSize(boolean theExactSize) {
        this.mOptions.set(EXACT_SIZE, (Object)theExactSize);
        return this;
    }

    public ConnectionConfiguration database(String theDB) {
        this.mOptions.set(DATABASE, (Object)theDB);
        return this;
    }

    public ConnectionConfiguration with(Options theOptions) {
        this.mOptions.setAll(theOptions);
        return this;
    }

    public <V> V get(Option<V> theOption) {
        return (V)this.mOptions.get(theOption);
    }

    @Override
    public Connection connect() throws StardogException {
        if (this.mOptions.is(REASONING_ENABLED) && !this.mOptions.contains(REASONING_SCHEMA)) {
            this.mOptions.set(REASONING_SCHEMA, (Object)"default");
        }
        String serverURL = (String)Preconditions.checkNotNull((Object)((String)this.mOptions.get(SERVER)), (Object)"No server URL has been provided");
        return DriverManager.getInstance().getConnection(serverURL + (String)this.mOptions.get(DATABASE), this.mOptions);
    }

    public static Connection at(String theConnectionString) throws StardogException {
        return ConnectionConfiguration.from(theConnectionString).connect();
    }

    private static String stripPropertyString(StringBuffer theBuffer) {
        int start = theBuffer.indexOf(";");
        if (start == -1) {
            return "";
        }
        String aPropString = theBuffer.substring(start + 1, theBuffer.length());
        theBuffer.replace(start, theBuffer.length(), "");
        return aPropString;
    }

    private static Options parseOptions(String theProps) {
        ArrayList pairs = Lists.newArrayList();
        for (String aPair : theProps.split(";")) {
            String[] kv;
            if ((aPair = aPair.trim()).length() == 0 || (kv = aPair.split("=")).length == 0 || kv.length < 2) continue;
            String theOptionName = kv[0].trim();
            String theOptionValue = kv[1].trim();
            pairs.add(Pair.create((Object)theOptionName, (Object)theOptionValue));
        }
        return mOptionParser.getOptions(pairs);
    }

    public static ConnectionConfiguration from(String theConnectionString) {
        ConnectionConfiguration aConfiguration = new ConnectionConfiguration();
        StringBuffer aURL = new StringBuffer(theConnectionString);
        String aPropsStr = ConnectionConfiguration.stripPropertyString(aURL);
        aConfiguration.mOptions.setAll(ConnectionConfiguration.parseOptions(aPropsStr));
        if (!aConfiguration.mOptions.contains(DATABASE)) {
            int aStart = aURL.lastIndexOf("/") + 1;
            int aEnd = aURL.indexOf(";") != -1 ? aURL.indexOf(";") : aURL.length();
            String aName = aURL.substring(aStart, aEnd);
            aConfiguration.database(aName);
            if (aURL.toString().endsWith(aName)) {
                aURL.replace(aURL.lastIndexOf(aName), aURL.length(), "");
            }
        }
        aConfiguration.server(aURL.toString());
        return aConfiguration;
    }

    public static ConnectionConfiguration to(String theDBName) {
        ConnectionConfiguration aConfig = new ConnectionConfiguration();
        aConfig.database(theDBName);
        return aConfig;
    }

    static {
        mOptionParser.registerOption(REASONING_ENABLED, input -> {
            try {
                return Boolean.parseBoolean(input.toString().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException((Throwable)InvalidConfigurationException.create(REASONING_ENABLED, (String)("Must be either 'true' or 'false', but is " + input.toString())));
            }
        });
        mOptionParser.registerOption(DATABASE, Object::toString);
    }
}

