/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api;

import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.complexible.stardog.api.ConnectionCredentials;
import com.complexible.stardog.api.LoginConnectionConfiguration;
import com.complexible.stardog.api.OptionParser;
import java.util.function.Supplier;

public abstract class AbstractConnectionConfiguration<T>
implements LoginConnectionConfiguration<T> {
    protected final Options mOptions;
    public static final OptionParser mOptionParser = new OptionParser();
    public static final Option<String> RUN_AS_USER = Option.create((String)"run_as_user", null);
    public static final Option<String> CONNECTION_TYPE = Option.create((String)"connection_type", null);

    protected AbstractConnectionConfiguration() {
        this.mOptions = Options.create();
    }

    protected AbstractConnectionConfiguration(Options theOptions) {
        this.mOptions = theOptions;
    }

    @Override
    public <S> AbstractConnectionConfiguration<T> set(Option<S> theOption, S theValue) {
        this.mOptions.set(theOption, theValue);
        return this;
    }

    @Override
    public AbstractConnectionConfiguration<T> credentials(String theUsername, String thePassword) {
        this.set(USERNAME, theUsername);
        this.set(PASSWORD, thePassword);
        return this;
    }

    @Override
    public AbstractConnectionConfiguration<T> credentials(ConnectionCredentials theConnectionCredentials) {
        this.set(CREDENTIALS, theConnectionCredentials);
        return this;
    }

    @Override
    public LoginConnectionConfiguration<T> credentialSupplier(Supplier<ConnectionCredentials> theSupplier) {
        this.set(CREDENTIALS_SUPPLIER, theSupplier);
        return this;
    }

    @Override
    public LoginConnectionConfiguration<T> credentials(String theAPIToken) {
        this.set(USERNAME, "Bearer");
        this.set(PASSWORD, theAPIToken);
        this.set(IS_TOKEN, (Object)true);
        this.set(CREDENTIALS, (Object)null);
        this.set(CREDENTIALS_SUPPLIER, (Object)null);
        return this;
    }

    @Override
    public AbstractConnectionConfiguration<T> server(String theServerURL) {
        Object theURL = theServerURL;
        if (!theServerURL.endsWith("/")) {
            theURL = theServerURL + "/";
        }
        this.set(SERVER, theURL);
        return this;
    }

    public AbstractConnectionConfiguration runningAs(String theUsername) {
        this.mOptions.set(RUN_AS_USER, (Object)theUsername);
        return this;
    }

    @Override
    public LoginConnectionConfiguration<T> setAll(Options theOptions) {
        this.mOptions.setAll(theOptions);
        return this;
    }

    @Override
    public Options getOptions() {
        return this.mOptions.copy();
    }

    static {
        mOptionParser.registerOption(USERNAME, Object::toString);
        mOptionParser.registerOption(PASSWORD, Object::toString);
        mOptionParser.registerOption(SERVER, Object::toString);
    }
}

