/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.protocols.http.client;

import com.complexible.common.base.Options;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.pack.ClusterNodeStatus;
import com.complexible.stardog.api.admin.pack.ClusterStatusView;
import com.complexible.stardog.api.admin.pack.StandbyNodeState;
import com.complexible.stardog.api.admin.pack.StandbyNodeStatus;
import com.complexible.stardog.protocols.http.client.ApacheHttp;
import com.complexible.stardog.protocols.http.client.BaseHttpClient;
import com.complexible.stardog.protocols.http.client.DelegatingHttpAdminClient;
import com.complexible.stardog.protocols.http.client.HttpAdminClient;
import com.complexible.stardog.protocols.http.client.HttpClusterAdminClient;
import com.complexible.stardog.protocols.http.pack.HTTPPackAdminProtocolConsts;
import com.complexible.stardog.util.report.DiagnosticsReport;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.message.BasicNameValuePair;

public final class HttpClusterAdminClientImpl
extends DelegatingHttpAdminClient
implements HttpClusterAdminClient,
HTTPPackAdminProtocolConsts {
    private final HttpAdminClient mClient;

    public HttpClusterAdminClientImpl(HttpAdminClient theDelegate) {
        super(theDelegate);
        this.mClient = theDelegate;
    }

    @Override
    public List<String> getNodes() throws StardogException {
        CloseableHttpResponse aResp = this.mClient.execute((ClassicHttpRequest)new HttpGet(this.mClient.url("cluster")));
        JsonArray aResult = BaseHttpClient.parseResponseAsJsonObject((CloseableHttpResponse)aResp).getAsJsonArray("nodes");
        return Lists.newArrayList((Iterable)BaseHttpClient.convertToStringCollection((JsonArray)aResult));
    }

    @Override
    public void shutdownAll() throws StardogException {
        BaseHttpClient.consumeResponse((CloseableHttpResponse)this.mClient.execute((ClassicHttpRequest)new HttpPost(this.mClient.url("shutdownAll"))));
    }

    @Override
    public List<ClusterNodeStatus> currentPackStatus(Options theOptions) throws StardogException {
        List aParams = StreamSupport.stream(theOptions.spliterator(), false).map(theProp -> new BasicNameValuePair(theProp.getName(), theOptions.get(theProp).toString())).collect(Collectors.toList());
        HttpGet aGet = new HttpGet(ApacheHttp.URIs.uri((String)this.url("cluster/status"), aParams));
        CloseableHttpResponse aResponse = this.mClient.execute((ClassicHttpRequest)aGet);
        try {
            ClusterStatusView statusView = (ClusterStatusView)BaseHttpClient.parseResponseAsObject((CloseableHttpResponse)aResponse, ClusterStatusView.class);
            return statusView.getNodes();
        }
        catch (Exception ex) {
            throw new StardogException((Throwable)ex);
        }
    }

    @Override
    public StandbyNodeStatus standbyStatus() throws StardogException {
        CloseableHttpResponse aResponse = this.mClient.execute((ClassicHttpRequest)new HttpGet(this.mClient.url("cluster/standby/status")));
        try {
            StandbyNodeStatus status = (StandbyNodeStatus)BaseHttpClient.parseResponseAsObject((CloseableHttpResponse)aResponse, StandbyNodeStatus.class);
            return status;
        }
        catch (Exception ex) {
            throw new StardogException((Throwable)ex);
        }
    }

    @Override
    public StandbyNodeState standbyState() throws Exception {
        CloseableHttpResponse aResponse = this.mClient.execute((ClassicHttpRequest)new HttpGet(this.mClient.url("cluster/standby/pause")));
        BaseHttpClient.checkResponseCode((CloseableHttpResponse)aResponse);
        JsonObject aTopObject = BaseHttpClient.parseResponseAsJsonObject((CloseableHttpResponse)aResponse);
        String aState = aTopObject.getAsJsonPrimitive("STATE").getAsString();
        return StandbyNodeState.valueOf((String)aState);
    }

    @Override
    @Deprecated
    public void setPause(boolean thePause) throws Exception {
        ApacheHttp.Parameters.ParameterListBuilder aBuilder = ApacheHttp.Parameters.builder();
        aBuilder.parameter("pause", thePause);
        CloseableHttpResponse aResponse = this.mClient.execute((ClassicHttpRequest)new HttpPut(this.mClient.url("cluster/standby/pause?" + ApacheHttp.Parameters.format((List)aBuilder.build()))));
        BaseHttpClient.checkResponseCode((CloseableHttpResponse)aResponse);
    }

    @Override
    public void removeStandbyMember(String theMemberId) throws Exception {
        CloseableHttpResponse aResponse = this.mClient.execute((ClassicHttpRequest)new HttpDelete(this.mClient.url("cluster/standby/registry/" + theMemberId)));
        BaseHttpClient.checkResponseCode((CloseableHttpResponse)aResponse);
    }

    @Override
    public Set<String> listStandbyMembers() throws Exception {
        CloseableHttpResponse aResponse = this.mClient.execute((ClassicHttpRequest)new HttpGet(this.mClient.url("cluster/standby/registry")));
        BaseHttpClient.checkResponseCode((CloseableHttpResponse)aResponse);
        JsonObject aTopObject = BaseHttpClient.parseResponseAsJsonObject((CloseableHttpResponse)aResponse);
        JsonArray aMemberArray = aTopObject.getAsJsonArray("standbynodes");
        HashSet<String> aMemberSet = new HashSet<String>();
        aMemberArray.iterator().forEachRemaining(j -> aMemberSet.add(j.getAsString()));
        return aMemberSet;
    }

    @Override
    public File generateClusterDiagnosticsReport(DiagnosticsReport theDiagnosticsReport) throws Exception {
        return this.generateDiagnosticsReport(theDiagnosticsReport, "cluster/diagnostics");
    }

    @Override
    public String readOnlyStart() throws Exception {
        CloseableHttpResponse aResponse = this.mClient.execute((ClassicHttpRequest)new HttpPut(this.mClient.url("cluster/readonly")));
        BaseHttpClient.checkResponseCode((CloseableHttpResponse)aResponse);
        JsonObject aTopObject = BaseHttpClient.parseResponseAsJsonObject((CloseableHttpResponse)aResponse);
        JsonPrimitive aJsonPrimitive = aTopObject.getAsJsonPrimitive("message");
        return aJsonPrimitive.getAsString();
    }

    @Override
    public String readOnlyStop() throws Exception {
        CloseableHttpResponse aResponse = this.mClient.execute((ClassicHttpRequest)new HttpDelete(this.mClient.url("cluster/readonly")));
        BaseHttpClient.checkResponseCode((CloseableHttpResponse)aResponse);
        JsonObject aTopObject = BaseHttpClient.parseResponseAsJsonObject((CloseableHttpResponse)aResponse);
        JsonPrimitive aJsonPrimitive = aTopObject.getAsJsonPrimitive("message");
        return aJsonPrimitive.getAsString();
    }

    @Override
    public String attemptSync() throws Exception {
        CloseableHttpResponse aResponse = this.mClient.execute((ClassicHttpRequest)new HttpPut(this.mClient.url("cluster/standby/attemptSync")));
        BaseHttpClient.checkResponseCode((CloseableHttpResponse)aResponse);
        JsonObject aTopObject = BaseHttpClient.parseResponseAsJsonObject((CloseableHttpResponse)aResponse);
        JsonPrimitive aJsonPrimitive = aTopObject.getAsJsonPrimitive("message");
        return aJsonPrimitive.getAsString();
    }

    @Override
    public String repairZk() throws Exception {
        CloseableHttpResponse aResponse = this.mClient.execute((ClassicHttpRequest)new HttpPut(this.mClient.url("cluster/repairZk")));
        BaseHttpClient.checkResponseCode((CloseableHttpResponse)aResponse);
        JsonObject aTopObject = BaseHttpClient.parseResponseAsJsonObject((CloseableHttpResponse)aResponse);
        JsonPrimitive aJsonPrimitive = aTopObject.getAsJsonPrimitive("message");
        return aJsonPrimitive.getAsString();
    }
}

