/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.model;

import com.complexible.common.base.ImmutableCollectors;
import com.complexible.common.base.Options;
import com.complexible.common.base.Streams;
import com.complexible.common.util.PrefixMapping;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.stardog.model.DataModel;
import com.stardog.model.DataModelFormat;
import com.stardog.model.DataModelWriter;
import com.stardog.model.DataModelWriterOptions;
import com.stardog.model.Property;
import com.stardog.model.Term;
import com.stardog.model.Type;
import com.stardog.stark.Namespace;
import com.stardog.stark.Namespaces;
import com.stardog.stark.io.turtle.TurtleUtil;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class DataModelTextWriter
implements DataModelWriter {
    private static final Set<String> BUILTIN_PREFIXES = (Set)Namespaces.DEFAULT.stream().map(Namespace::prefix).filter(prefix -> !prefix.isEmpty()).collect(ImmutableCollectors.toSet());
    private static final Splitter LINE_SPLITTER = Splitter.on((String)"\n");
    private PrefixMapping prefixes;
    private Set<String> usedPrefixes;

    @Override
    public DataModelFormat getFormat() {
        return DataModelFormat.TEXT;
    }

    private String qname(String name) {
        return this.qname(name, false);
    }

    private String qname(String name, boolean generate) {
        Object qname = this.prefixes.qname(name, generate);
        if (!name.equals(qname)) {
            String prefix = ((String)qname).split(":", 2)[0];
            if (!BUILTIN_PREFIXES.contains(prefix)) {
                this.usedPrefixes.add(prefix);
            }
            if (((String)qname).startsWith(":") & ((String)qname).length() > 1) {
                qname = ((String)qname).substring(1);
            }
        } else {
            qname = "<" + name + ">";
        }
        return qname;
    }

    @Override
    public void write(OutputStream out, DataModel model, Options options) {
        PrintStream ps = out instanceof PrintStream ? (PrintStream)out : new PrintStream(out);
        this.prefixes = new PrefixMapping(true);
        ((Iterable)options.get(DataModelWriterOptions.NAMESPACES)).forEach(ns -> this.prefixes.setMapping(ns.prefix(), ns.iri()));
        TreeMap datatypes = Maps.newTreeMap();
        TreeMap classes = Maps.newTreeMap();
        this.usedPrefixes = Sets.newTreeSet();
        for (Type type : model.getTypes()) {
            String qname = this.qname(type.getName(), true);
            if (!type.isBuiltin()) {
                if (type.isDatatype()) {
                    datatypes.put(qname, type);
                } else {
                    classes.put(qname, type);
                }
            }
            type.getProperties().forEach(r -> {
                this.qname(r.getName());
                r.getRange().ifPresent(range -> this.qname(range.getName()));
            });
        }
        if (!this.usedPrefixes.isEmpty()) {
            for (String string : this.usedPrefixes) {
                ps.println("PREFIX " + string + ": <" + this.prefixes.getNamespace(string) + ">");
            }
            ps.println();
        }
        for (Map.Entry entry : datatypes.entrySet()) {
            this.writeTerm(ps, "", "Datatype", (String)entry.getKey(), (Term)entry.getValue());
            ps.println();
        }
        for (Map.Entry entry : classes.entrySet()) {
            this.writeTerm(ps, "", "Class", (String)entry.getKey(), (Term)entry.getValue());
            Type type = (Type)entry.getValue();
            if (!type.getSupers().isEmpty()) {
                ps.print(" extends ");
                ps.print(Streams.stream(type.getSupers()).map(sup -> this.qname(sup.getName())).sorted().collect(Collectors.joining(", ")));
            }
            ps.println();
            Streams.stream(type.getProperties()).sorted(Comparator.comparing(prop -> this.qname(prop.getName()))).forEach(prop -> {
                this.writeTerm(ps, "\t", "", this.qname(prop.getName()), (Term)prop);
                prop.getRange().ifPresent(range -> ps.print(" " + this.qname(range.getName())));
                ps.println();
            });
            ps.println();
        }
    }

    private void writeTerm(PrintStream ps, String indent, String termType, String termName, Term term) {
        ((Iterable)term.getDescription().map(arg_0 -> ((Splitter)LINE_SPLITTER).split(arg_0)).orElse(Collections.emptyList())).forEach(line -> ps.println(indent + "# " + line));
        ps.print(indent);
        ps.print(termType);
        if (!termType.isEmpty()) {
            ps.print(" ");
        }
        ps.print(termName);
        if (term instanceof Property) {
            ps.print(this.formatCardinality((Property)term));
        }
        if (!term.getLabels().isEmpty()) {
            for (String label : term.getLabels()) {
                ps.print(" ");
                ps.print("\"" + TurtleUtil.encodeString((String)label) + "\"");
            }
        }
    }

    private String formatCardinality(Property prop) {
        if (prop.getMinCardinality().isPresent() || prop.getMaxCardinality().isPresent()) {
            StringBuilder sb = new StringBuilder("[");
            prop.getMinCardinality().ifPresent(sb::append);
            sb.append("..");
            prop.getMaxCardinality().ifPresent(sb::append);
            sb.append("]");
            return sb.toString();
        }
        return "";
    }
}

