/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.model;

import com.complexible.common.base.Options;
import com.complexible.common.util.PrefixMapping;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.stardog.model.DataModelBuilder;
import com.stardog.model.DataModelFormat;
import com.stardog.model.DataModelGenerator;
import com.stardog.model.DataModelWriterOptions;
import com.stardog.stark.io.turtle.TurtleUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Optional;

public class DataModelTextParser
implements DataModelGenerator {
    private LineParser parser;
    private PrefixMapping prefixes;

    public DataModelTextParser(InputStream in) {
        this(new InputStreamReader(in, Charsets.UTF_8));
    }

    public DataModelTextParser(Reader reader) {
        this.parser = new LineParser(reader);
    }

    @Override
    public DataModelBuilder generate(DataModelBuilder model, Options options) {
        try {
            this.prefixes = new PrefixMapping(false);
            ((Iterable)options.get(DataModelWriterOptions.NAMESPACES)).forEach(ns -> this.prefixes.setMapping(ns.prefix(), ns.iri()));
            DataModelBuilder.TypeBuilder type = null;
            StringBuilder description = new StringBuilder();
            block2: while (this.parser.nextLine()) {
                String name;
                Optional<String> descriptionLine = this.parser.readDescription();
                if (descriptionLine.isPresent()) {
                    if (description.length() > 0) {
                        description.append("\n");
                    }
                    description.append(descriptionLine.get());
                    continue;
                }
                String token = this.parser.readTokenUntil(type == null ? 0 : 91);
                if (token.isEmpty()) {
                    type = null;
                    continue;
                }
                if (token.toUpperCase().startsWith("PREFIX")) {
                    String prefix = this.parser.readTokenUntil(58);
                    this.parser.assertChar(':');
                    this.parser.skipWS();
                    this.parser.assertChar('<');
                    String ns2 = this.parser.readTokenUntil(62);
                    this.parser.assertChar('>');
                    this.prefixes.setMapping(prefix, ns2);
                    type = null;
                    continue;
                }
                if (token.equalsIgnoreCase("Datatype")) {
                    name = this.expandName(this.parser.readToken());
                    type = model.newDatatype(name);
                    this.setDescription(description, type);
                    this.readLabels(this.parser, type);
                    type = null;
                    continue;
                }
                if (token.equalsIgnoreCase("Class")) {
                    name = this.expandName(this.parser.readToken());
                    type = model.newClass(name);
                    this.setDescription(description, type);
                    this.readLabels(this.parser, type);
                    token = this.parser.readToken();
                    if (token.equalsIgnoreCase("extends")) {
                        while (!(token = this.parser.readTokenUntil(44)).isEmpty()) {
                            type.addSuper(this.expandName(token));
                            this.parser.skipWS();
                            if (this.parser.readChar(',')) continue;
                            continue block2;
                        }
                        continue;
                    }
                    if (token.isEmpty()) continue;
                    this.parser.throwException("Expecting extends but found " + token);
                    continue;
                }
                if (type == null) {
                    this.parser.throwException(String.format("Expecting one of {%s, %s, %s} but found: %s", "PREFIX", "Class", "Datatype", token));
                }
                name = this.expandName(token);
                DataModelBuilder.PropertyBuilder property = type.newProperty(name);
                this.setDescription(description, property);
                if (this.parser.readChar('[')) {
                    String min = this.parser.readTokenUntil(46);
                    if (!min.isEmpty()) {
                        property.minCardinality(Integer.parseInt(min));
                    }
                    this.parser.assertChar('.');
                    this.parser.assertChar('.');
                    String max = this.parser.readTokenUntil(93);
                    if (!max.isEmpty()) {
                        property.maxCardinality(Integer.parseInt(max));
                    }
                    this.parser.assertChar(']');
                }
                this.readLabels(this.parser, property);
                String range = this.parser.readToken();
                if (range.isEmpty()) continue;
                property.range(this.expandName(range));
            }
            return model;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void setDescription(StringBuilder description, DataModelBuilder.TermBuilder term) {
        if (description.length() > 0) {
            term.description(description.toString());
            description.setLength(0);
        }
    }

    private void readLabels(LineParser parser, DataModelBuilder.TermBuilder term) {
        Optional<String> label = parser.readQuotedString();
        while (label.isPresent()) {
            term.addLabel(label.get());
            label = parser.readQuotedString();
        }
    }

    private String expandName(String token) {
        if (token.startsWith("<")) {
            if (!token.endsWith(">")) {
                this.parser.assertChar('>');
            }
            return token.substring(1, token.length() - 1);
        }
        if (token.indexOf(58) == -1) {
            return Strings.nullToEmpty((String)this.prefixes.getNamespace("")) + token;
        }
        String[] split = token.split(":", 2);
        String prefix = split[0];
        String local = split[1];
        String ns = this.prefixes.getNamespace(prefix);
        if (ns == null) {
            this.parser.throwException("Undefined prefix: " + split[0]);
        }
        return ns + local;
    }

    @Override
    public DataModelFormat getFormat() {
        return DataModelFormat.TEXT;
    }

    private static class LineParser {
        private static final char EOL = '\u0000';
        private LineNumberReader reader;
        private StringBuilder sb = new StringBuilder();
        private String line;
        private int col;

        public LineParser(Reader reader) {
            this.reader = new LineNumberReader(new BufferedReader(reader));
        }

        public boolean nextLine() throws IOException {
            if (this.line != null) {
                this.skipWS();
                if (this.col < this.line.length()) {
                    this.throwException("Unexpected token: " + this.line.substring(this.col));
                }
            }
            this.col = 0;
            this.line = this.reader.readLine();
            return this.line != null;
        }

        public String readToken() {
            return this.readTokenUntil(0);
        }

        public Optional<String> readDescription() {
            this.skipWS();
            char ch = this.read();
            if (ch != '#') {
                this.unread(ch);
                return Optional.empty();
            }
            return Optional.of(this.readTokenUntil(0, false));
        }

        public Optional<String> readQuotedString() {
            this.skipWS();
            char ch = this.read();
            if (ch != '\"') {
                this.unread(ch);
                return Optional.empty();
            }
            String label = TurtleUtil.decodeString((String)this.readTokenUntil(34, false));
            this.assertChar('\"');
            return Optional.of(label);
        }

        public String readTokenUntil(int delimiter) {
            return this.readTokenUntil(delimiter, true);
        }

        private String readTokenUntil(int delimiter, boolean stopAtWhitespace) {
            this.skipWS();
            this.sb.setLength(0);
            char ch = this.read();
            while (!(ch == '\u0000' || ch == delimiter || this.isWhitespace(ch) && stopAtWhitespace)) {
                this.sb.append(ch);
                ch = this.read();
            }
            this.unread(ch);
            return this.sb.toString();
        }

        private void assertChar(char expected) {
            char actual = this.read();
            if (actual != expected) {
                this.throwException(String.format("Expecting %s but found: %s", Character.valueOf(expected), (int)actual));
            }
        }

        private boolean readChar(char expected) {
            char actual = this.read();
            if (actual != expected) {
                this.unread(actual);
                return false;
            }
            return true;
        }

        private void throwException(String msg) {
            throw new RuntimeException(String.format("[L%d:C%d] %s", this.reader.getLineNumber(), this.col, msg));
        }

        public char read() {
            return this.col == this.line.length() ? (char)'\u0000' : this.line.charAt(this.col++);
        }

        public void unread(char ch) {
            if (ch != '\u0000' && (this.col <= 0 || this.line.charAt(--this.col) != ch)) {
                this.throwException("Trying to unread invalid character: " + ch);
            }
        }

        public void skipWS() {
            char ch = this.read();
            while (this.isWhitespace(ch)) {
                ch = this.read();
            }
            this.unread(ch);
        }

        private boolean isWhitespace(char ch) {
            return ch == ' ' || ch == '\t';
        }
    }
}

