/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.model;

import com.complexible.common.base.Objects2;
import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.google.common.base.Preconditions;
import com.stardog.model.DataModel;
import com.stardog.model.DataModelFormat;
import com.stardog.model.DataModelWriter;
import com.stardog.model.DataModelWriterOptions;
import com.stardog.model.Property;
import com.stardog.model.Term;
import com.stardog.model.Type;
import com.stardog.stark.IRI;
import com.stardog.stark.OWL;
import com.stardog.stark.Resource;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFWriters;
import com.stardog.stark.vocabs.RDF;
import com.stardog.stark.vocabs.RDFS;
import com.stardog.stark.vocabs.SchemaOrg;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataModelOwlWriter
implements DataModelWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataModelOwlWriter.class);
    public static final Option<Boolean> USE_SCHEMA_ORG = Option.create((String)"use.schema.org", (Object)true);
    public static final Option<Boolean> USE_OWL = Option.create((String)"use.owl", (Object)true);

    @Override
    public DataModelFormat getFormat() {
        return DataModelFormat.OWL;
    }

    @Override
    public void write(OutputStream out, DataModel model, Options options) {
        FileFormat format = (FileFormat)Preconditions.checkNotNull((Object)((FileFormat)options.get(DataModelWriterOptions.SERIALIZATION_FORMAT)), (Object)"No serialization format provided");
        RDFHandler handler = (RDFHandler)RDFWriters.to((OutputStream)out, (RDFFormat)((RDFFormat)Objects2.castTo((Object)format, RDFFormat.class, (String)"Not a valid RDF format: %s", (Object[])new Object[]{format}))).orElseThrow(() -> new IllegalArgumentException("Unsupported RDF format provided" + String.valueOf(format)));
        this.write(handler, model, options);
    }

    public void write(RDFHandler handler, DataModel model, Options options) {
        Iterable namespaces = (Iterable)options.get(DataModelWriterOptions.NAMESPACES);
        handler.start();
        namespaces.forEach(ns -> handler.namespace(ns.prefix(), ns.iri()));
        this.writeTypes(handler, model, options);
        model.getStatements().forEach(arg_0 -> ((RDFHandler)handler).handle(arg_0));
        handler.end();
    }

    private IRI getClassType(boolean useOWLTypes) {
        return useOWLTypes ? OWL.CLASS : RDFS.CLASS;
    }

    private IRI getPropertyType(Property prop, boolean useOWLTypes) {
        return useOWLTypes ? (prop.getRange().map(Type::isClass).orElse(false).booleanValue() ? OWL.OBJECTPROPERTY : OWL.DATATYPEPROPERTY) : RDF.PROPERTY;
    }

    private IRI getDomainProperty(boolean useSchemaOrg) {
        return useSchemaOrg ? SchemaOrg.DOMAIN_INCLUDES : RDFS.DOMAIN;
    }

    private IRI getRangeProperty(boolean useSchemaOrg) {
        return useSchemaOrg ? SchemaOrg.RANGE_INCLUDES : RDFS.RANGE;
    }

    public void writeTypes(RDFHandler handler, DataModel model, Options options) {
        boolean useOWLTypes = (Boolean)options.get(USE_OWL);
        boolean useSchemaOrg = (Boolean)options.get(USE_SCHEMA_ORG);
        for (Type type : model.getTypes()) {
            if (type.isDatatype() || type.getName().equals(OWL.THING.toString())) continue;
            IRI classIRI = Values.iri((String)type.getName());
            this.writeTerm(handler, type, classIRI, this.getClassType(useOWLTypes));
            for (Type superType : type.getSupers()) {
                handler.handle(Values.statement((Resource)classIRI, (IRI)RDFS.SUBCLASSOF, (Value)Values.iri((String)superType.getName())));
            }
            for (Property prop : type.getProperties()) {
                IRI propIRI = Values.iri((String)prop.getName());
                this.writeTerm(handler, prop, propIRI, this.getPropertyType(prop, useOWLTypes));
                handler.handle(Values.statement((Resource)propIRI, (IRI)this.getDomainProperty(useSchemaOrg), (Value)Values.iri((String)prop.getDomain().getName())));
                prop.getRange().ifPresent(range -> handler.handle(Values.statement((Resource)propIRI, (IRI)this.getRangeProperty(useSchemaOrg), (Value)Values.iri((String)range.getName()))));
            }
        }
    }

    private void writeTerm(RDFHandler handler, Term term, IRI termIRI, IRI typeIRI) {
        handler.handle(Values.statement((Resource)termIRI, (IRI)RDF.TYPE, (Value)typeIRI));
        term.getLabels().forEach(label -> handler.handle(Values.statement((Resource)termIRI, (IRI)RDFS.LABEL, (Value)Values.literal((String)label))));
        term.getDescription().ifPresent(desc -> handler.handle(Values.statement((Resource)termIRI, (IRI)RDFS.COMMENT, (Value)Values.literal((String)desc))));
    }
}

