/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.model;

import com.complexible.common.base.Bool;
import com.complexible.common.base.Options;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.stardog.model.DataModelBuilder;
import com.stardog.model.DataModelFormat;
import com.stardog.model.DataModelGenerator;
import com.stardog.stark.Datatype;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.OWL;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.vocabs.RDF;
import com.stardog.stark.vocabs.RDFS;
import com.stardog.stark.vocabs.SchemaOrg;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataModelOwlParser
implements DataModelGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataModelOwlParser.class);
    private final Set<Statement> mStatements;

    public DataModelOwlParser(Set<Statement> statements) {
        this.mStatements = statements;
    }

    @Override
    public DataModelFormat getFormat() {
        return DataModelFormat.OWL;
    }

    @Override
    public DataModelBuilder generate(DataModelBuilder model, Options options) {
        HashMultimap stmtsBySubj = HashMultimap.create();
        this.mStatements.forEach(arg_0 -> DataModelOwlParser.lambda$generate$0((Multimap)stmtsBySubj, arg_0));
        for (Statement stmt : this.mStatements) {
            DataModelBuilder.TypeBuilder aTypeBuilder;
            Resource subj = stmt.subject();
            if (!(subj instanceof IRI)) continue;
            IRI pred = stmt.predicate();
            Value obj = stmt.object();
            if (pred.equals((Object)RDF.TYPE)) {
                if (obj.equals((Object)OWL.CLASS) || obj.equals((Object)RDFS.CLASS)) {
                    aTypeBuilder = model.newClass(subj.toString());
                    for (Statement stmtBySubj : stmtsBySubj.get((Object)subj)) {
                        if (stmtBySubj.predicate().equals((Object)RDFS.LABEL) && stmtBySubj.object() instanceof Literal) {
                            aTypeBuilder.addLabel(((Literal)stmtBySubj.object()).label());
                            continue;
                        }
                        if (!stmtBySubj.predicate().equals((Object)RDFS.COMMENT) || !(stmtBySubj.object() instanceof Literal)) continue;
                        aTypeBuilder.description(((Literal)stmtBySubj.object()).label());
                    }
                    continue;
                }
                if (obj.equals((Object)OWL.OBJECTPROPERTY)) {
                    this.buildProperty((Multimap<Resource, Statement>)stmtsBySubj, subj, model, Bool.TRUE);
                    continue;
                }
                if (obj.equals((Object)OWL.DATATYPEPROPERTY)) {
                    this.buildProperty((Multimap<Resource, Statement>)stmtsBySubj, subj, model, Bool.FALSE);
                    continue;
                }
                if (!obj.equals((Object)RDF.PROPERTY)) continue;
                this.buildProperty((Multimap<Resource, Statement>)stmtsBySubj, subj, model, Bool.UNKNOWN);
                continue;
            }
            if (!pred.equals((Object)RDFS.SUBCLASSOF)) continue;
            aTypeBuilder = model.newClass(subj.toString());
            if (!(obj instanceof IRI)) continue;
            aTypeBuilder.addSuper(obj.toString());
        }
        return model;
    }

    private void buildProperty(Multimap<Resource, Statement> stmtsBySubj, Resource property, DataModelBuilder model, Bool isObjectProperty) {
        HashSet labels = Sets.newHashSet();
        HashSet domains = Sets.newHashSet();
        IRI range = null;
        String description = null;
        assert (property instanceof IRI);
        for (Statement stmt : stmtsBySubj.get((Object)property)) {
            IRI pred = stmt.predicate();
            Value obj = stmt.object();
            if (pred.equals((Object)RDFS.DOMAIN) || pred.equals((Object)SchemaOrg.DOMAIN_INCLUDES)) {
                if (!(obj instanceof IRI)) continue;
                domains.add((IRI)obj);
                continue;
            }
            if (pred.equals((Object)RDFS.RANGE) || pred.equals((Object)SchemaOrg.RANGE_INCLUDES)) {
                if (!(obj instanceof IRI)) continue;
                range = (IRI)obj;
                continue;
            }
            if (pred.equals((Object)RDFS.LABEL) && obj instanceof Literal) {
                labels.add(((Literal)obj).label());
                continue;
            }
            if (!pred.equals((Object)RDFS.COMMENT) || !(obj instanceof Literal)) continue;
            description = ((Literal)obj).label();
        }
        if (domains.isEmpty() && range != null) {
            domains.add(OWL.THING);
        }
        if (range != null || !domains.isEmpty()) {
            if (range != null && !isObjectProperty.isFalse() && Datatype.of(range) == Datatype.UDF) {
                model.newClass(range.toString());
            }
            for (IRI domain : domains) {
                this.addProperty(model, domain, property, range, labels, description);
            }
        } else {
            LOGGER.error(String.valueOf(property) + " has domain and range as null values.");
        }
    }

    private void addProperty(DataModelBuilder model, IRI domain, Resource property, IRI range, Set<String> labels, String description) {
        DataModelBuilder.PropertyBuilder aPropertyBuilder = model.newClass(domain.toString()).newProperty(property.toString());
        if (range != null) {
            aPropertyBuilder.range(range.toString());
        }
        labels.forEach(aPropertyBuilder::addLabel);
        if (description != null) {
            aPropertyBuilder.description(description);
        }
    }

    private static /* synthetic */ void lambda$generate$0(Multimap stmtsBySubj, Statement stmt) {
        stmtsBySubj.put((Object)stmt.subject(), (Object)stmt);
    }
}

