/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.model;

import com.complexible.common.base.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.stardog.model.DataModelWriters;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class DataModelFormat {
    private final String name;
    public static final DataModelFormat TEXT = new DataModelFormat("text");
    public static final DataModelFormat OWL = new DataModelFormat("owl");
    public static final DataModelFormat SHACL = new DataModelFormat("shacl");
    public static final DataModelFormat GRAPHQL = new DataModelFormat("graphql");
    public static final DataModelFormat SQL = new DataModelFormat("sql");
    public static final DataModelFormat VIRTUAL = new DataModelFormat("virtual");
    public static final Set<DataModelFormat> INPUTS = ImmutableSet.of((Object)OWL, (Object)SHACL, (Object)VIRTUAL);
    public static final Set<DataModelFormat> OUTPUTS = DataModelWriters.WRITERS.keySet();
    public static final Map<String, DataModelFormat> FORMATS = (Map)Stream.of(TEXT, OWL, SHACL, GRAPHQL, SQL, VIRTUAL).collect(ImmutableCollectors.toMap(DataModelFormat::getName, Function.identity()));

    public DataModelFormat(String theName) {
        this.name = theName;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DataModelFormat that = (DataModelFormat)obj;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    @Nonnull
    public static DataModelFormat forName(@Nonnull String theName) {
        return (DataModelFormat)Preconditions.checkNotNull((Object)FORMATS.get(theName.toLowerCase()), (String)"Unrecognized format: %s", (Object)theName);
    }
}

