/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.rio;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.rdf.rio.RDFStream;
import com.complexible.common.rdf.rio.RDFStreamBase;
import com.complexible.common.rdf.rio.RDFStreamBuilder;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.stardog.stark.Namespace;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Values;
import com.stardog.stark.io.AbstractRDFHandler;
import com.stardog.stark.io.CollectingRDFHandler;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.io.InvalidRDF;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFHandlerException;
import com.stardog.stark.io.RDFHandlers;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.mutable.MutableBoolean;

public final class RDFStreams {
    public static long BYTE_PER_STATEMENT = 80L;
    public static final RDFStream EMPTY = RDFStreamBase.EMPTY;

    private RDFStreams() {
        throw new AssertionError();
    }

    public static RDFStreamBuilder forFile(Path theFile) {
        return RDFStreams.forFiles((Collection<Path>)ImmutableList.of((Object)theFile));
    }

    public static RDFStreamBuilder forFiles(Path ... theFiles) {
        return RDFStreams.forFiles(Arrays.asList(theFiles));
    }

    public static RDFStreamBuilder forFiles(Collection<Path> theFiles) {
        return new RDFStreamBuilder(theFiles);
    }

    public static RDFStreamBuilder forStream(InputStream theStream) {
        return new RDFStreamBuilder(theStream);
    }

    public static RDFStream forStatements(Iterable<Statement> theStatements, Resource theContext) {
        int aSize = theStatements instanceof Collection ? ((Collection)theStatements).size() : -1;
        return new IterationStream(theStatements.iterator(), theContext, aSize);
    }

    public static RDFStream forStatements(Iterator<Statement> theStatements, Resource theContext) {
        return new IterationStream(theStatements, theContext, -1L);
    }

    public static RDFStream forStatements(Iterator<Statement> theStatements, Resource theContext, long estimatedSize) {
        return new IterationStream(theStatements, theContext, estimatedSize);
    }

    public static boolean hasContext(Iterable<RDFStream> theStreams) {
        return Iterables.any(theStreams, RDFStream::hasContext);
    }

    public static long length(Iterable<RDFStream> theStreams) {
        long aLength = 0L;
        for (RDFStream aStream : theStreams) {
            aLength += aStream.length();
        }
        return aLength;
    }

    public static long estimatedCount(Iterable<RDFStream> theStreams) {
        long aLength = 0L;
        for (RDFStream aStream : theStreams) {
            aLength += aStream.estimatedCount();
        }
        return aLength;
    }

    public static long estimatedCount(long theBytes, RDFFormat theFormat) {
        long aEstimate = theBytes / BYTE_PER_STATEMENT;
        if (RDFFormats.compressionOf((RDFFormat)theFormat) != FileFormat.Compression.NONE) {
            aEstimate *= 10L;
        }
        return aEstimate;
    }

    public static String formatParseException(RDFStream theStream, Exception theError) {
        String aMessage;
        String string = aMessage = theError.getMessage() != null ? theError.getMessage() : theError.toString();
        if (theError instanceof NoSuchFileException) {
            aMessage = String.format("No such file or directory: %s", ((NoSuchFileException)theError).getFile());
        }
        return theStream == null || theStream == EMPTY ? aMessage : theStream.getName() + ": " + aMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(List<RDFStream> theStreams, RDFHandler theHandler) throws InvalidRDF, IOException {
        try {
            for (RDFStream aRDFStream : theStreams) {
                aRDFStream.parse(theHandler);
            }
        }
        finally {
            AutoCloser.close(theStreams);
        }
    }

    public static Set<Statement> parse(List<RDFStream> theStreams) throws InvalidRDF, IOException {
        CollectingRDFHandler aHandler = RDFHandlers.toSet();
        RDFStreams.parse(theStreams, (RDFHandler)aHandler);
        return (Set)aHandler.result();
    }

    public static List<Namespace> parseNamespaces(List<RDFStream> theStreams) throws InvalidRDF {
        ArrayList aNamespaces;
        block2: {
            aNamespaces = Lists.newArrayList();
            final MutableBoolean mFinished = new MutableBoolean(false);
            try {
                RDFStreams.parse(theStreams, (RDFHandler)new AbstractRDFHandler(){

                    public void namespace(@Nonnull String prefix, @Nonnull String uri) throws RDFHandlerException {
                        aNamespaces.add(Values.namespace((String)prefix, (String)uri));
                    }

                    public void handle(@Nonnull Statement theStmt) throws RDFHandlerException {
                        mFinished.setTrue();
                        throw new RDFHandlerException("Importing namespaces finished");
                    }
                });
            }
            catch (Exception e) {
                if (!mFinished.isFalse()) break block2;
                Throwables.propagateIfPossible((Throwable)e, RDFHandlerException.class);
                throw new RuntimeException(e);
            }
        }
        return aNamespaces;
    }

    private static class IterationStream
    implements RDFStream {
        private final Iterator<Statement> mStatements;
        private final Resource mContext;
        private final long mEstimatedCount;
        private final boolean mCountUnknown;
        private int mCurrentCount;

        public IterationStream(Iterator<Statement> theStatements, Resource theContext, long theEstimatedCount) {
            this.mStatements = theStatements;
            this.mContext = theContext == Values.DEFAULT_GRAPH ? null : theContext;
            this.mCountUnknown = theEstimatedCount < 0L;
            this.mEstimatedCount = theEstimatedCount;
            this.mCurrentCount = 0;
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.mStatements instanceof AutoCloseable) {
                    AutoCloser.close((AutoCloseable[])new AutoCloseable[]{(AutoCloseable)((Object)this.mStatements)});
                }
            }
            catch (Throwable e) {
                Throwables.propagateIfPossible((Throwable)e, IOException.class);
                throw new IOException(e);
            }
        }

        @Override
        public void parse(RDFHandler theHandler) throws IOException, InvalidRDF {
            try {
                theHandler.start();
                while (this.mStatements.hasNext()) {
                    ++this.mCurrentCount;
                    theHandler.handle(this.mStatements.next());
                }
                theHandler.end();
            }
            catch (Throwable e) {
                Throwables.propagateIfPossible((Throwable)e, IOException.class);
                Throwables.propagateIfInstanceOf((Throwable)e, InvalidRDF.class);
                throw new RDFHandlerException(e);
            }
        }

        @Override
        public boolean hasContext() {
            return true;
        }

        @Override
        public String getName() {
            return String.format("Memory stream (%s triples)", this.mCountUnknown ? "?" : Long.valueOf(this.mEstimatedCount));
        }

        @Override
        public Resource getContext() {
            return this.mContext;
        }

        @Override
        public long bytesRead() {
            return (long)this.mCurrentCount * BYTE_PER_STATEMENT;
        }

        @Override
        public long length() {
            return this.mEstimatedCount * BYTE_PER_STATEMENT;
        }

        @Override
        public long estimatedCount() {
            return this.mEstimatedCount;
        }
    }
}

