/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.rio;

import com.complexible.common.rdf.query.SPARQLUtil;
import com.complexible.common.rdf.query.parser.sparql.ASTSPARQLRenderer;
import com.complexible.common.rdf.query.parser.sparql.AbstractASTVisitor;
import com.complexible.common.rdf.query.parser.sparql.BaseDeclProcessor;
import com.complexible.common.rdf.query.parser.sparql.PrefixDeclProcessor;
import com.complexible.common.rdf.query.parser.sparql.StringEscapesProcessor;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTFunctionCall;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTIRI;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTIfThenQueryContainer;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTObjectList;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTOperationContainer;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTPropertyList;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTPropertyListPath;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTQueryContainer;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTRDFLiteral;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTTriplesSameSubjectPath;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTUnparsedQuadDataBlock;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTUpdateContainer;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTVar;
import com.complexible.common.rdf.query.parser.sparql.ast.Node;
import com.complexible.common.rdf.query.parser.sparql.ast.ParseException;
import com.complexible.common.rdf.query.parser.sparql.ast.SyntaxTreeBuilder;
import com.complexible.common.rdf.query.parser.sparql.ast.VisitorException;
import com.complexible.common.rdf.rio.RDFStreams;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.stardog.stark.BNode;
import com.stardog.stark.Datatype;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Namespace;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.impl.NamespacesImpl;
import com.stardog.stark.io.AbstractRDFHandler;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.vocabs.RDF;
import com.stardog.stark.vocabs.XSD;
import java.io.Serializable;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class RDFObfuscator
implements Function<Statement, Statement> {
    private final IRI RULE_CONTENT = Values.iri((String)"tag:stardog:api:rule:content");
    private static final Set<IRI> obfuscatableDatatypes = Sets.newHashSet((Object[])new IRI[]{XSD.STRING, RDF.LANG_STRING});
    private final Map<String, String> prefixes = Maps.newHashMap();
    private final NamespacesImpl namespaces = new NamespacesImpl();
    private final List<Filter> includes = Lists.newArrayList();
    private final List<Filter> excludes = Lists.newArrayList();
    private MessageDigest md;
    private String baseIRI = "tag:stardog:api:obf:";

    public RDFObfuscator() throws Exception {
        this(null, (Iterable<Namespace>)ImmutableList.of());
    }

    public RDFObfuscator(String configFile) throws Exception {
        this(configFile, (Iterable<Namespace>)ImmutableList.of());
    }

    public RDFObfuscator(String configFile, Iterable<Namespace> theNamespaces) throws Exception {
        this.addNamespaces((Iterable<Namespace>)Namespaces.DEFAULT);
        this.addNamespaces(theNamespaces);
        if (configFile == null) {
            this.defaultConfig();
        } else {
            this.fileConfig(configFile);
        }
    }

    private void addNamespaces(Iterable<Namespace> theNamespaces) {
        for (Namespace ns : theNamespaces) {
            this.addNamespace(ns);
        }
    }

    private void addNamespace(Namespace ns) {
        this.namespaces.add(ns);
        this.prefixes.put(ns.prefix(), ns.iri());
    }

    private void fileConfig(String configFile) throws Exception {
        RDFStreams.forFile(Paths.get(configFile, new String[0])).parse((RDFHandler)new AbstractRDFHandler(){
            private Map<Value, Filter> filters = Maps.newHashMap();

            public void namespace(String prefix, String IRI2) {
                if (!IRI2.equals("tag:stardog:api:obf:")) {
                    RDFObfuscator.this.addNamespace(Values.namespace((String)prefix, (String)IRI2));
                }
                if (Strings.isNullOrEmpty((String)prefix)) {
                    RDFObfuscator.this.baseIRI = IRI2;
                }
            }

            public void handle(Statement st) {
                Resource s = st.subject();
                IRI p = st.predicate();
                Value o = st.object();
                if (p.equals((Object)ObfVocab.digest)) {
                    String digestName = ((Literal)o).label();
                    try {
                        RDFObfuscator.this.md = MessageDigest.getInstance(digestName);
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new IllegalArgumentException("Unknown message digest algorithm: " + digestName);
                    }
                } else if (p.equals((Object)ObfVocab.include)) {
                    RDFObfuscator.this.includes.add(this.filter(o));
                } else if (p.equals((Object)ObfVocab.exclude)) {
                    RDFObfuscator.this.excludes.add(this.filter(o));
                } else if (p.equals((Object)ObfVocab.position)) {
                    String posName = ((IRI)o).localName().toUpperCase();
                    try {
                        this.filter((Value)s).position(FilterPosition.valueOf(posName));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Invalid position: " + String.valueOf(o));
                    }
                } else if (p.equals((Object)ObfVocab.pattern)) {
                    String pattern = Value.lex((Value)o);
                    this.filter((Value)s).pattern(pattern);
                } else if (p.equals((Object)ObfVocab.namespace)) {
                    String prefix = Value.lex((Value)o);
                    this.filter((Value)s).prefix(prefix);
                }
            }

            private Filter filter(Value r) {
                Filter filter = this.filters.get(r);
                if (filter == null) {
                    filter = new Filter();
                    this.filters.put(r, filter);
                }
                return filter;
            }
        });
        this.validate(this.includes);
        this.validate(this.excludes);
    }

    private void defaultConfig() throws Exception {
        this.md = MessageDigest.getInstance("SHA-256");
        this.addNamespace(Values.namespace((String)"obf", (String)"tag:stardog:api:obf:"));
        this.includes.add(new Filter().position(FilterPosition.ANY).pattern(".*"));
        this.excludes.add(new Filter().position(FilterPosition.ANY).namespace("tag:stardog:api:"));
        this.excludes.add(new Filter().position(FilterPosition.ANY).namespace("http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
        this.excludes.add(new Filter().position(FilterPosition.ANY).namespace("http://www.w3.org/2002/07/owl#"));
        this.excludes.add(new Filter().position(FilterPosition.ANY).namespace("http://www.w3.org/2001/XMLSchema#"));
        this.excludes.add(new Filter().position(FilterPosition.PREDICATE).namespace("http://www.w3.org/2000/01/rdf-schema#"));
        this.excludes.add(new Filter().position(FilterPosition.ANY).namespace("http://www.w3.org/2003/11/swrl#"));
        this.excludes.add(new Filter().position(FilterPosition.ANY).namespace("http://www.w3.org/2003/11/swrlb#"));
    }

    private void validate(Iterable<Filter> filters) {
        for (Filter filter : filters) {
            Preconditions.checkNotNull((Object)((Object)filter.pos), (Object)"Filter position not specified");
            Preconditions.checkNotNull(filter.pattern, (Object)"Filter pattern or namespace not specified");
        }
    }

    public Namespaces namespaces() {
        return this.namespaces;
    }

    @Override
    public Statement apply(Statement stmt) {
        Resource subj = this.obfuscateSubj(stmt.subject());
        IRI pred = this.obfuscatePred(stmt.predicate());
        Value obj = pred.equals((Object)this.RULE_CONTENT) ? Values.literal((String)this.obfuscateRule(Value.lex((Value)stmt.object()))) : this.obfuscateObj(stmt.object());
        IRI aContext = stmt.context() == Values.DEFAULT_GRAPH ? Values.DEFAULT_GRAPH : this.obfuscateValue(stmt.context(), FilterPosition.CONTEXT);
        return Values.statement((Resource)subj, (IRI)pred, (Value)obj, (Resource)aContext);
    }

    private String obfuscate(String plainText) {
        byte[] digest = this.md.digest(((String)plainText).getBytes());
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < digest.length; ++i) {
            plainText = Integer.toHexString(0xFF & digest[i]);
            if (((String)plainText).length() < 2) {
                plainText = "0" + (String)plainText;
            }
            hexString.append((String)plainText);
        }
        return hexString.toString();
    }

    private boolean matchesAny(Iterable<Filter> filters, Value val, FilterPosition pos) {
        for (Filter filter : filters) {
            if (!filter.matches(val, pos)) continue;
            return true;
        }
        return false;
    }

    private boolean isObfuscate(Value IRI2, FilterPosition pos) {
        return this.matchesAny(this.includes, IRI2, pos) && !this.matchesAny(this.excludes, IRI2, pos);
    }

    private Resource obfuscateSubj(Resource subject) {
        if (subject instanceof Statement) {
            return this.apply((Statement)subject);
        }
        return this.obfuscateValue(subject, FilterPosition.SUBJECT);
    }

    private IRI obfuscatePred(IRI theIRI) {
        return this.obfuscateIRI(theIRI, FilterPosition.PREDICATE);
    }

    private Value obfuscateObj(Value value) {
        return this.obfuscateValue(value, FilterPosition.OBJECT);
    }

    public <T extends Value> T obfuscateValue(T value, FilterPosition pos) {
        if (value instanceof IRI) {
            value = this.obfuscateIRI((IRI)value, pos);
        } else if (value instanceof BNode) {
            value = this.obfuscateBNode((BNode)value, pos);
        } else if (value instanceof Literal) {
            value = this.obfuscateLiteral((Literal)value, pos);
        }
        return value;
    }

    private IRI obfuscateIRI(IRI theIRI, FilterPosition pos) {
        boolean obfuscate = this.isObfuscate((Value)theIRI, pos);
        if (obfuscate) {
            theIRI = Values.iri((String)(this.baseIRI + this.obfuscate(theIRI.toString())));
        }
        return theIRI;
    }

    private BNode obfuscateBNode(BNode bnode, FilterPosition pos) {
        boolean obfuscate = this.isObfuscate((Value)bnode, pos);
        if (obfuscate) {
            bnode = Values.bnode((String)this.obfuscate(bnode.id()));
        }
        return bnode;
    }

    private Literal obfuscateLiteral(Literal literal, FilterPosition pos) {
        boolean obfuscate;
        String label = literal.label();
        IRI datatype = literal.datatypeIRI();
        boolean bl = obfuscate = obfuscatableDatatypes.contains(datatype) && this.isObfuscate((Value)literal, pos);
        if (obfuscate) {
            label = this.obfuscate(label);
            literal = Literal.isLanguageLiteral((Literal)literal) ? Values.literal((String)label, (String)((String)literal.lang().get())) : (literal.datatype() != Datatype.STRING ? Values.literal((String)label, (IRI)datatype) : Values.literal((String)label));
        }
        return literal;
    }

    public String obfuscateQuery(String theQuery) {
        return this.obfuscateSPARQL(theQuery, false);
    }

    public String obfuscateRule(String theRule) {
        return this.obfuscateSPARQL(theRule, true);
    }

    private String obfuscateSPARQL(String theStr, boolean isRule) {
        try {
            if (isRule) {
                return this.obfuscateSPARQL(SyntaxTreeBuilder.parseIfThenQuery(theStr), new ASTIfThenQueryContainer(1));
            }
            SPARQLUtil.QueryType aType = SPARQLUtil.getType(theStr);
            if (aType == SPARQLUtil.QueryType.UPDATE) {
                return SyntaxTreeBuilder.parseUpdateSequence(theStr).getUpdateContainers().stream().map(aQC -> this.obfuscateSPARQL((ASTOperationContainer)aQC, new ASTUpdateContainer(1))).collect(Collectors.joining(";\n"));
            }
            return this.obfuscateSPARQL(SyntaxTreeBuilder.parseQuery(theStr), new ASTQueryContainer(1));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private String obfuscateSPARQL(ASTOperationContainer theQC, ASTOperationContainer aNewQC) {
        try {
            StringEscapesProcessor.process(theQC);
            BaseDeclProcessor.process(theQC, null);
            PrefixDeclProcessor.process(theQC, this.prefixes);
            aNewQC.jjtAppendChild(theQC.getOperation());
            theQC.getOperation().jjtSetParent(aNewQC);
            aNewQC.jjtAccept(new AbstractASTVisitor(){
                Map<String, String> mVars = Maps.newHashMap();
                FilterPosition mPos = FilterPosition.ANY;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object visit(ASTTriplesSameSubjectPath node, Object data) throws VisitorException {
                    this.mPos = FilterPosition.SUBJECT;
                    try {
                        Object object = super.visit(node, data);
                        return object;
                    }
                    finally {
                        this.mPos = FilterPosition.ANY;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object visit(ASTPropertyList node, Object data) throws VisitorException {
                    this.mPos = FilterPosition.PREDICATE;
                    try {
                        Object object = super.visit(node, data);
                        return object;
                    }
                    finally {
                        this.mPos = FilterPosition.ANY;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object visit(ASTPropertyListPath node, Object data) throws VisitorException {
                    this.mPos = FilterPosition.PREDICATE;
                    try {
                        Object object = super.visit(node, data);
                        return object;
                    }
                    finally {
                        this.mPos = FilterPosition.ANY;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object visit(ASTObjectList node, Object data) throws VisitorException {
                    this.mPos = FilterPosition.OBJECT;
                    try {
                        Object object = super.visit(node, data);
                        return object;
                    }
                    finally {
                        this.mPos = FilterPosition.ANY;
                    }
                }

                @Override
                public Object visit(ASTFunctionCall node, Object data) throws VisitorException {
                    int n = node.jjtGetNumChildren();
                    for (int i = 1; i < n; ++i) {
                        Node childNode = node.jjtGetChild(i);
                        data = childNode.jjtAccept(this, data);
                    }
                    return data;
                }

                @Override
                public Object visit(ASTVar node, Object data) throws VisitorException {
                    String aName = this.obfuscateVarName(node.getName());
                    node.setName(aName);
                    return node.childrenAccept(this, data);
                }

                @Override
                public Object visit(ASTIRI node, Object data) throws VisitorException {
                    IRI uri = Values.iri((String)node.getValue());
                    String aObf = RDFObfuscator.this.obfuscateValue(uri, this.mPos).toString();
                    node.setValue(aObf);
                    return node.childrenAccept(this, data);
                }

                @Override
                public Object visit(ASTRDFLiteral node, Object data) throws VisitorException {
                    Literal literal;
                    String label = node.getLabel().getValue();
                    String lang = node.getLang();
                    ASTIRI datatypeNode = node.getDatatype();
                    if (datatypeNode != null) {
                        IRI datatype;
                        try {
                            datatype = Values.iri((String)datatypeNode.getValue());
                        }
                        catch (IllegalArgumentException e) {
                            throw new VisitorException(e.getMessage());
                        }
                        literal = Values.literal((String)label, (IRI)datatype);
                    } else {
                        literal = lang != null ? Values.literal((String)label, (String)lang) : Values.literal((String)label);
                    }
                    literal = RDFObfuscator.this.obfuscateValue(literal, this.mPos);
                    node.getLabel().setValue(literal.label());
                    return literal;
                }

                @Override
                public Object visit(ASTUnparsedQuadDataBlock node, Object data) throws VisitorException {
                    throw new IllegalArgumentException("INSERT/DELETE DATA queries are not supported for obfuscation");
                }

                private String obfuscateVarName(String theVar) {
                    Object aName = this.mVars.get(theVar);
                    if (aName == null) {
                        aName = "x" + this.mVars.size();
                        this.mVars.put(theVar, (String)aName);
                    }
                    return aName;
                }
            }, null);
            return new ASTSPARQLRenderer().render(aNewQC);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static class ObfVocab {
        public static final String NS = "tag:stardog:api:obf:";
        private static final IRI Obfuscation = Values.iri((String)"tag:stardog:api:obf:Obfuscation");
        private static final IRI digest = Values.iri((String)"tag:stardog:api:obf:digest");
        private static final IRI include = Values.iri((String)"tag:stardog:api:obf:include");
        private static final IRI exclude = Values.iri((String)"tag:stardog:api:obf:exclude");
        private static final IRI position = Values.iri((String)"tag:stardog:api:obf:position");
        private static final IRI subject = Values.iri((String)"tag:stardog:api:obf:subject");
        private static final IRI predicate = Values.iri((String)"tag:stardog:api:obf:predicate");
        private static final IRI object = Values.iri((String)"tag:stardog:api:obf:object");
        private static final IRI any = Values.iri((String)"tag:stardog:api:obf:any");
        private static final IRI pattern = Values.iri((String)"tag:stardog:api:obf:pattern");
        private static final IRI namespace = Values.iri((String)"tag:stardog:api:obf:namespace");

        private ObfVocab() {
        }
    }

    private class Filter {
        private FilterPosition pos;
        private Predicate<? super String> pattern;

        public Filter position(FilterPosition pos) {
            this.pos = pos;
            return this;
        }

        public Filter prefix(String prefix) {
            String iri = RDFObfuscator.this.prefixes.get(prefix);
            Preconditions.checkArgument((iri != null ? 1 : 0) != 0, (Object)("Unknown namespace prefix used in filter: " + prefix));
            return this.namespace(iri);
        }

        public Filter namespace(String iri) {
            this.pattern = theStr -> theStr.startsWith(iri);
            return this;
        }

        public Filter pattern(String pattern) {
            this.pattern = Predicates.containsPattern(pattern);
            return this;
        }

        protected boolean matches(Value val, FilterPosition pos) {
            return (pos == FilterPosition.ANY || this.pos == FilterPosition.ANY || this.pos == pos) && this.pattern.test(Value.lex((Value)val));
        }

        public String toString() {
            return "Filter[" + String.valueOf((Object)this.pos) + ", " + String.valueOf(this.pattern) + "]";
        }
    }

    static enum FilterPosition {
        ANY,
        SUBJECT,
        PREDICATE,
        OBJECT,
        CONTEXT;

    }

    private static final class Predicates {
        private Predicates() {
            throw new AssertionError();
        }

        public static Predicate<CharSequence> containsPattern(String thePattern) {
            return new ContainsPatternPredicate(thePattern);
        }

        private static class ContainsPatternPredicate
        implements Predicate<CharSequence>,
        Serializable {
            final Pattern pattern;
            private static final long serialVersionUID = 0L;

            ContainsPatternPredicate(Pattern pattern) {
                this.pattern = (Pattern)Preconditions.checkNotNull((Object)pattern);
            }

            ContainsPatternPredicate(String patternStr) {
                this(Pattern.compile(patternStr));
            }

            @Override
            public boolean test(CharSequence t) {
                return this.pattern.matcher(t).find();
            }

            public int hashCode() {
                return Objects.hash(this.pattern.pattern(), this.pattern.flags());
            }

            public boolean equals(Object obj) {
                if (obj instanceof ContainsPatternPredicate) {
                    ContainsPatternPredicate that = (ContainsPatternPredicate)obj;
                    return Objects.equals(this.pattern.pattern(), that.pattern.pattern()) && this.pattern.flags() == that.pattern.flags();
                }
                return false;
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("pattern", (Object)this.pattern).add("pattern.flags", (Object)Integer.toHexString(this.pattern.flags())).toString();
            }
        }
    }
}

