/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.rio;

import com.complexible.common.util.concurrent.SharedExecutor;
import com.google.common.base.Preconditions;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ProcessorContext {
    public static final int DEFAULT_MAX_PARSER_COUNT;
    public static final int DEFAULT_MAX_HANDLER_COUNT;
    protected final AtomicInteger mProducersRunning = new AtomicInteger(0);
    protected final AtomicInteger mConsumersRunning = new AtomicInteger(0);
    protected int mMaxProducers;
    protected int mMaxConsumers;
    private static final ExecutorService EXECUTOR;

    protected ProcessorContext(int maxProducers, int maxConsumers) {
        this.mMaxProducers = maxProducers;
        this.mMaxConsumers = maxConsumers;
    }

    abstract ExecutorService getExecutor();

    public int maxProducerCount() {
        return this.mMaxProducers;
    }

    public int maxConsumerCount() {
        return this.mMaxConsumers;
    }

    public boolean mayStartProducer() {
        return this.mProducersRunning.get() < this.maxProducerCount();
    }

    public boolean mayStartConsumer() {
        return this.mConsumersRunning.get() < this.maxConsumerCount();
    }

    public boolean mustStopConsumer() {
        return this.mConsumersRunning.get() > this.maxConsumerCount();
    }

    public int startedProducer() {
        return this.mProducersRunning.incrementAndGet();
    }

    public int startedConsumer() {
        return this.mConsumersRunning.incrementAndGet();
    }

    public int stoppedProducer() {
        return this.mProducersRunning.decrementAndGet();
    }

    public void stoppedConsumer() {
        this.mConsumersRunning.decrementAndGet();
    }

    int getRunningProducers() {
        return this.mProducersRunning.get();
    }

    int getRunningConsumers() {
        return this.mConsumersRunning.get();
    }

    public static ProcessorContext shared() {
        return Global.INSTANCE;
    }

    static {
        DEFAULT_MAX_HANDLER_COUNT = DEFAULT_MAX_PARSER_COUNT = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        EXECUTOR = SharedExecutor.get();
    }

    private static final class Global
    extends ProcessorContext {
        private final ExecutorService mExecutor;
        private static final ProcessorContext INSTANCE = new Global(EXECUTOR, DEFAULT_MAX_PARSER_COUNT, DEFAULT_MAX_HANDLER_COUNT);

        public Global(ExecutorService service, int theMaxProducerCount, int theMaxConsumerCount) {
            super(theMaxProducerCount, theMaxConsumerCount);
            this.mExecutor = service;
        }

        @Override
        public ExecutorService getExecutor() {
            return this.mExecutor;
        }
    }

    static final class Local
    extends ProcessorContext {
        private final ProcessorContext mGlobal;
        private boolean mResizeConsumers = true;

        public Local(ProcessorContext theDelegate) {
            super(Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.mGlobal = theDelegate;
        }

        public void setMaxProducers(int theMaxProducers) {
            this.mMaxProducers = theMaxProducers;
        }

        public void setMaxConsumers(int theMaxConsumers) {
            Preconditions.checkState((theMaxConsumers > 0 ? 1 : 0) != 0, (Object)"Must have at least one consumer");
            this.mMaxConsumers = theMaxConsumers;
        }

        public void setResizeConsumers(boolean theResizeConsumers) {
            this.mResizeConsumers = theResizeConsumers;
        }

        @Override
        public ExecutorService getExecutor() {
            return this.mGlobal.getExecutor();
        }

        @Override
        public int maxProducerCount() {
            return Math.min(this.mGlobal.maxProducerCount(), this.mMaxProducers);
        }

        @Override
        public int maxConsumerCount() {
            return Math.max(1, Math.min(this.mGlobal.maxConsumerCount(), this.mMaxConsumers));
        }

        @Override
        public boolean mayStartProducer() {
            assert (this.mMaxProducers > 0) : "Must be configured to start a single producer thread";
            int local = this.mProducersRunning.get();
            if (local == 0) {
                return true;
            }
            return local < this.mMaxProducers && this.mGlobal.mayStartProducer();
        }

        public boolean wouldExceedProducerLimits() {
            return this.mProducersRunning.get() == 0 && !this.mGlobal.mayStartProducer();
        }

        @Override
        public boolean mayStartConsumer() {
            int limit;
            int consumers = this.mConsumersRunning.get();
            int n = limit = this.mResizeConsumers ? Math.max(1, this.mProducersRunning.get()) : this.maxConsumerCount();
            assert (limit >= 1) : "Must have at least one consumer";
            return consumers < limit && (consumers == 0 || this.mGlobal.mayStartConsumer());
        }

        @Override
        public boolean mustStopConsumer() {
            boolean doStop;
            int limit;
            int consumers = this.mConsumersRunning.get();
            int n = limit = this.mResizeConsumers ? Math.max(1, this.mProducersRunning.get()) : Math.min(this.mMaxConsumers, this.maxProducerCount());
            assert (limit >= 1) : "Must have at least one consumer";
            boolean bl = doStop = consumers > limit || consumers > 1 && this.mGlobal.mustStopConsumer();
            if (doStop) {
                return this.mConsumersRunning.compareAndSet(consumers, consumers - 1);
            }
            return false;
        }

        public void willStopAllConsumers() {
            this.mConsumersRunning.set(0);
        }

        @Override
        public int startedProducer() {
            this.mGlobal.startedProducer();
            return this.mProducersRunning.incrementAndGet();
        }

        @Override
        public int startedConsumer() {
            this.mGlobal.startedConsumer();
            return this.mConsumersRunning.incrementAndGet();
        }

        @Override
        public int stoppedProducer() {
            this.mGlobal.stoppedProducer();
            return this.mProducersRunning.decrementAndGet();
        }

        @Override
        public void stoppedConsumer() {
            assert (this.mConsumersRunning.get() < this.mGlobal.getRunningConsumers()) : "Should always be smaller than the global tracker";
            this.mGlobal.stoppedConsumer();
        }
    }
}

