/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.random;

import com.complexible.common.rdf.random.RandomStatementGenerator;
import com.complexible.common.rdf.random.RandomValueGenerator;
import com.complexible.common.rdf.rio.RDFStream;
import com.complexible.common.rdf.rio.RDFStreamFactory;
import com.google.common.base.Preconditions;
import com.stardog.stark.Resource;
import com.stardog.stark.io.RDFHandler;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RandomStream
implements RDFStream {
    private final RandomStatementGenerator generator;
    private final long count;
    private long progress = 0L;

    public RandomStream(long seed, long cnt) {
        this.generator = new RandomStatementGenerator(new RandomValueGenerator(seed, 1));
        this.count = cnt;
    }

    @Override
    public void parse(RDFHandler handler) {
        handler.start();
        while (this.progress++ < this.count) {
            handler.handle(this.generator.next());
        }
        handler.end();
    }

    @Override
    public Resource getContext() {
        return null;
    }

    @Override
    public boolean hasContext() {
        return false;
    }

    @Override
    public String getName() {
        return "Random(" + this.count + ")";
    }

    @Override
    public void close() {
    }

    @Override
    public long bytesRead() {
        return this.progress;
    }

    @Override
    public long length() {
        return this.count;
    }

    @Override
    public long estimatedCount() {
        return this.count;
    }

    public static class Factory
    implements RDFStreamFactory {
        @Override
        public List<RDFStream> createStreams(Map<String, String> options) {
            long seed = Long.parseLong(options.getOrDefault("seed", "0"));
            long count = Long.parseLong((String)Preconditions.checkNotNull((Object)options.get("count"), (Object)"Count parameter is missing"));
            return Collections.singletonList(new RandomStream(seed, count));
        }
    }
}

