/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.query.resultio;

import com.brsanthu.dataexporter.DataExporter;
import com.complexible.common.base.Options;
import com.complexible.common.dataexporter.TableExporter;
import com.complexible.common.rdf.query.resultio.AbstractDataExporterQueryResultWriter;
import com.complexible.common.timer.DurationFormat;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.QueryResultFormats;
import com.stardog.stark.query.io.QueryResultWriter;
import com.stardog.stark.query.io.QueryResultWriterFactory;
import java.io.OutputStream;
import javax.annotation.Nonnull;

public class TextTableQueryResultWriter
extends AbstractDataExporterQueryResultWriter {
    public static final QueryResultFormat FORMAT = QueryResultFormats.TEXT_TABLE;
    private boolean mShowSummary = true;
    private final DurationFormat mTimeFormat = DurationFormat.LONG;
    private long mStartTime = System.currentTimeMillis();

    public TextTableQueryResultWriter(OutputStream theOut, @Nonnull Options theOptions) {
        super(theOut, theOptions, FORMAT);
    }

    public boolean isShowSummary() {
        return this.mShowSummary;
    }

    public void setShowSummary(boolean mShowSummary) {
        this.mShowSummary = mShowSummary;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public void setStartTime(long theStartTime) {
        this.mStartTime = theStartTime;
    }

    @Override
    public void end() {
        long mResultCount = this.mExporter.output();
        if (this.mShowSummary) {
            long aTime = System.currentTimeMillis() - this.mStartTime;
            this.mOut.format("%nQuery returned %,d results in %s%n", mResultCount, this.mTimeFormat.format(aTime));
        }
    }

    @Override
    protected DataExporter createExporter() {
        return new TableExporter((OutputStream)this.mOut);
    }

    DurationFormat getTimeFormat() {
        return this.mTimeFormat;
    }

    public static final class TextTableQueryResultWriterFactory
    implements QueryResultWriterFactory {
        @Nonnull
        public QueryResultFormat format() {
            return FORMAT;
        }

        @Nonnull
        public QueryResultWriter create(@Nonnull OutputStream theOutputStream, @Nonnull Options theOptions) {
            return new TextTableQueryResultWriter(theOutputStream, theOptions);
        }
    }
}

