/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.query.resultio;

import com.brsanthu.dataexporter.DataExporter;
import com.complexible.common.base.Options;
import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.common.rdf.query.RDFValueColumn;
import com.complexible.common.rdf.rio.TurtleValueWriter;
import com.stardog.stark.Namespace;
import com.stardog.stark.Value;
import com.stardog.stark.impl.NamespacesImpl;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.ResultWritingFailed;
import com.stardog.stark.query.io.SelectQueryResultWriter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class AbstractDataExporterQueryResultWriter
implements SelectQueryResultWriter {
    protected final PrintStream mOut;
    protected TextTabularOutput mExporter;
    protected int mColCount;
    protected RDFValueColumn[] mColumns;
    protected Object[] mResult;
    private final NamespacesImpl mNamespaces = new NamespacesImpl();
    private final QueryResultFormat mFormat;
    private final Options mOptions;

    protected AbstractDataExporterQueryResultWriter(OutputStream theOut, Options theOptions, QueryResultFormat theFormat) {
        this.mFormat = theFormat;
        this.mOptions = theOptions;
        this.mOut = theOut == null ? System.out : (theOut instanceof PrintStream ? (PrintStream)theOut : new PrintStream(theOut));
    }

    @Nonnull
    public QueryResultFormat format() {
        return this.mFormat;
    }

    public void links(@Nonnull List<String> theList) {
    }

    public void namespace(@Nonnull String thePrefix, @Nonnull String theIRI) throws ResultWritingFailed {
        this.mNamespaces.add(thePrefix, theIRI);
    }

    public void addNamespaces(Iterable<Namespace> theNamespaces) {
        theNamespaces.forEach(arg_0 -> ((NamespacesImpl)this.mNamespaces).add(arg_0));
    }

    public void start() {
    }

    public void variables(@Nonnull List<String> theSelectVars) {
        this.mColCount = theSelectVars.size();
        this.mResult = new Value[this.mColCount];
        TurtleValueWriter aWriter = new TurtleValueWriter((Iterable<Namespace>)this.mNamespaces, this.mOptions);
        this.mColumns = new RDFValueColumn[this.mColCount];
        for (int i = 0; i < this.mColCount; ++i) {
            this.mColumns[i] = new RDFValueColumn(theSelectVars.get(i), aWriter);
        }
        this.mExporter = new TextTabularOutput(this.createExporter(), Arrays.asList(this.mColumns));
    }

    public void handle(@Nonnull BindingSet theBinding) {
        for (int i = 0; i < this.mColCount; ++i) {
            this.mResult[i] = theBinding.value(this.mColumns[i].getName()).orElse(null);
        }
        this.mExporter.addRow(this.mResult);
    }

    public void end() {
        this.mExporter.output();
    }

    protected abstract DataExporter createExporter();
}

